/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.model;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.Database;
import org.parosproxy.paros.db.paros.ParosDatabase;
import org.parosproxy.paros.model.FileCopier;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SessionListener;
import org.xml.sax.SAXException;
import org.zaproxy.zap.control.ControlOverrides;
import org.zaproxy.zap.db.sql.DbSQL;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.ContextDataFactory;

public class Model {
    private static Model model = null;
    private static final String DBNAME_TEMPLATE = Constant.DBNAME_TEMPLATE;
    private String DBNAME_UNTITLED;
    private static int DBNAME_COPY = 1;
    private Session session;
    private OptionsParam optionsParam;
    private Database db;
    private String currentDBNameUntitled;
    private Logger logger;
    private List<SessionListener> sessionListeners;
    private List<ContextDataFactory> contextDataFactories;
    private boolean postInitialisation;

    public Model() {
        this.DBNAME_UNTITLED = Constant.getInstance().DBNAME_UNTITLED;
        this.session = null;
        this.optionsParam = null;
        this.db = null;
        this.currentDBNameUntitled = "";
        this.logger = Logger.getLogger(Model.class);
        this.sessionListeners = new ArrayList<SessionListener>();
        this.contextDataFactories = new ArrayList<ContextDataFactory>();
        this.session = new Session(this);
        this.optionsParam = new OptionsParam();
    }

    public OptionsParam getOptionsParam() {
        if (this.optionsParam == null) {
            this.optionsParam = new OptionsParam();
        }
        return this.optionsParam;
    }

    public void setOptionsParam(OptionsParam optionsParam) {
        this.optionsParam = optionsParam;
    }

    public Session getSession() {
        if (this.session == null) {
            this.session = new Session(this);
        }
        return this.session;
    }

    public Session newSession() {
        this.session = new Session(this);
        return this.session;
    }

    public void openSession(String string) throws SQLException, SAXException, IOException, Exception {
        this.getSession().open(string);
    }

    public void openSession(String string, SessionListener sessionListener) {
        this.getSession().open(string, sessionListener);
    }

    public void openSession(File file, SessionListener sessionListener) {
        this.getSession().open(file, sessionListener);
    }

    public void saveSession(String string, SessionListener sessionListener) {
        this.getSession().save(string, sessionListener);
    }

    public void saveSession(String string) throws Exception {
        this.getSession().save(string);
    }

    public void snapshotSession(String string, SessionListener sessionListener) {
        this.getSession().snapshot(string, sessionListener);
    }

    public void discardSession() {
        this.getSession().discard();
    }

    public void closeSession() {
        this.getSession().close();
    }

    public void init(ControlOverrides controlOverrides) throws SAXException, IOException, Exception {
        this.getOptionsParam().load(Constant.getInstance().FILE_CONFIG, controlOverrides);
        if (controlOverrides.isExperimentalDb()) {
            this.logger.info((Object)"Using experimental database :/");
            this.db = DbSQL.getSingleton().initDatabase();
        } else {
            ParosDatabase parosDatabase = new ParosDatabase();
            parosDatabase.setDatabaseParam(this.getOptionsParam().getDatabaseParam());
            this.db = parosDatabase;
        }
        this.createAndOpenUntitledDb();
        HistoryReference.setTableHistory(this.getDb().getTableHistory());
        HistoryReference.setTableTag(this.getDb().getTableTag());
        HistoryReference.setTableAlert(this.getDb().getTableAlert());
    }

    public static Model getSingleton() {
        if (model == null) {
            Model.createSingleton();
        }
        return model;
    }

    private static synchronized void createSingleton() {
        if (model == null) {
            model = new Model();
        }
    }

    public Database getDb() {
        return this.db;
    }

    public void moveSessionDb(String string) throws Exception {
        this.copySessionDb(this.currentDBNameUntitled, string);
    }

    protected void copySessionDb(String string, String string2) throws Exception {
        File file;
        File file2;
        File file3;
        File file4;
        this.getDb().close(false, false);
        FileCopier fileCopier = new FileCopier();
        File file5 = new File(string + ".data");
        if (file5.exists()) {
            file4 = new File(string2 + ".data");
            fileCopier.copy(file5, file4);
        }
        if ((file4 = new File(string + ".script")).exists()) {
            file3 = new File(string2 + ".script");
            fileCopier.copy(file4, file3);
        }
        if ((file3 = new File(string + ".properties")).exists()) {
            file2 = new File(string2 + ".properties");
            fileCopier.copy(file3, file2);
        }
        if ((file2 = new File(string + ".backup")).exists()) {
            file = new File(string2 + ".backup");
            fileCopier.copy(file2, file);
        }
        if ((file = new File(string + ".lobs")).exists()) {
            File file6 = new File(string2 + ".lobs");
            fileCopier.copy(file, file6);
        }
        this.getDb().open(string2);
    }

    protected void snapshotSessionDb(String string, String string2) throws Exception {
        File file;
        File file2;
        File file3;
        File file4;
        this.logger.debug((Object)("snapshotSessionDb " + string + " -> " + string2));
        this.getDb().close(false, false);
        FileCopier fileCopier = new FileCopier();
        File file5 = new File(string + ".data");
        if (file5.exists()) {
            file4 = new File(string2 + ".data");
            fileCopier.copy(file5, file4);
        }
        if ((file4 = new File(string + ".script")).exists()) {
            file3 = new File(string2 + ".script");
            fileCopier.copy(file4, file3);
        }
        if ((file3 = new File(string + ".properties")).exists()) {
            file2 = new File(string2 + ".properties");
            fileCopier.copy(file3, file2);
        }
        if ((file2 = new File(string + ".backup")).exists()) {
            file = new File(string2 + ".backup");
            fileCopier.copy(file2, file);
        }
        if ((file = new File(string + ".lobs")).exists()) {
            File file6 = new File(string2 + ".lobs");
            fileCopier.copy(file, file6);
        }
        if (string.length() == 0) {
            this.logger.debug((Object)("snapshotSessionDb using " + this.currentDBNameUntitled + " -> " + string2));
            string = this.currentDBNameUntitled;
        }
        this.getDb().open(string);
    }

    public void createAndOpenUntitledDb() throws ClassNotFoundException, Exception {
        File file;
        this.getDb().close(false);
        File file2 = new File(this.getSession().getSessionFolder());
        File[] fileArray = file2.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.startsWith("untitled");
            }
        });
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].delete()) continue;
            this.logger.error((Object)("Failed to delete file " + fileArray[i].getAbsolutePath()));
        }
        this.currentDBNameUntitled = this.DBNAME_UNTITLED + DBNAME_COPY;
        FileCopier fileCopier = new FileCopier();
        File file3 = new File(Constant.getZapInstall(), DBNAME_TEMPLATE + ".data");
        if (file3.exists()) {
            file = new File(this.currentDBNameUntitled + ".data");
            if (file.exists() && !file.delete()) {
                this.logger.error((Object)("Failed to delete file " + file.getAbsolutePath()));
            }
            fileCopier.copy(file3, file);
        }
        if ((file3 = new File(Constant.getZapInstall(), DBNAME_TEMPLATE + ".properties")).exists()) {
            file = new File(this.currentDBNameUntitled + ".properties");
            if (file.exists() && !file.delete()) {
                this.logger.error((Object)("Failed to delete file " + file.getAbsolutePath()));
            }
            fileCopier.copy(file3, file);
        }
        if ((file3 = new File(Constant.getZapInstall(), DBNAME_TEMPLATE + ".script")).exists()) {
            file = new File(this.currentDBNameUntitled + ".script");
            if (file.exists() && !file.delete()) {
                this.logger.error((Object)("Failed to delete file " + file.getAbsolutePath()));
            }
        } else {
            throw new FileNotFoundException("Required file not found: " + file3.getAbsolutePath());
        }
        fileCopier.copy(file3, file);
        file3 = new File(this.currentDBNameUntitled + ".backup");
        if (file3.exists() && !file3.delete()) {
            this.logger.error((Object)("Failed to delete file " + file3.getAbsolutePath()));
        }
        if ((file3 = new File(this.currentDBNameUntitled + ".lobs")).exists() && !file3.delete()) {
            this.logger.error((Object)("Failed to delete file " + file3.getAbsolutePath()));
        }
        this.getDb().open(this.currentDBNameUntitled);
        ++DBNAME_COPY;
    }

    public void addSessionListener(SessionListener sessionListener) {
        this.sessionListeners.add(sessionListener);
    }

    public void addContextDataFactory(ContextDataFactory contextDataFactory) {
        if (contextDataFactory == null) {
            throw new IllegalArgumentException("Parameter contextDataFactory must not be null.");
        }
        this.contextDataFactories.add(contextDataFactory);
        if (this.postInitialisation) {
            for (Context context : this.getSession().getContexts()) {
                contextDataFactory.loadContextData(this.getSession(), context);
            }
        }
    }

    public void removeContextDataFactory(ContextDataFactory contextDataFactory) {
        if (contextDataFactory == null) {
            throw new IllegalArgumentException("Parameter contextDataFactory must not be null.");
        }
        this.contextDataFactories.remove(contextDataFactory);
    }

    public void loadContext(Context context) {
        for (ContextDataFactory contextDataFactory : this.contextDataFactories) {
            contextDataFactory.loadContextData(this.getSession(), context);
        }
    }

    public void saveContext(Context context) {
        for (ContextDataFactory contextDataFactory : this.contextDataFactories) {
            contextDataFactory.persistContextData(this.getSession(), context);
        }
    }

    public void importContext(Context context, Configuration configuration) throws ConfigurationException {
        for (ContextDataFactory contextDataFactory : this.contextDataFactories) {
            contextDataFactory.importContextData(context, configuration);
        }
    }

    public void exportContext(Context context, Configuration configuration) {
        for (ContextDataFactory contextDataFactory : this.contextDataFactories) {
            contextDataFactory.exportContextData(context, configuration);
        }
    }

    public void postInit() {
        this.postInitialisation = true;
    }
}

