#ifndef EFL_CONFIG_EO_HH
#define EFL_CONFIG_EO_HH
#include <Eo.h>

extern "C" {
#include "efl_config.eo.h"
}
#include <Eina.hh>
#include <Eo.hh>
namespace efl { 
struct Config;
} 
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::Config> : ::std::true_type {}; } }

namespace eo_cxx {
namespace efl { 
struct Config {
   static Eo_Class const* _eo_class()
   {
      return EFL_CONFIG_INTERFACE;
   }
   Eo* _eo_ptr() const { return *(Eo**)this; }
   operator ::efl::Config() const;
   operator ::efl::Config&();
   operator ::efl::Config const&() const;
   /// @cond LOCAL
    ::efl::eolian::address_of_operator<Config> operator&() { return {this}; }
    ::efl::eolian::address_of_operator<Config const > operator&() const { return {this}; }
   /// @endcond
};
} 
}
namespace efl { 
struct Config : ::efl::eo::concrete
{
   explicit Config( ::Eo* eo)
      : ::efl::eo::concrete(eo) {}
   explicit Config(std::nullptr_t)
      : ::efl::eo::concrete(nullptr) {}
   Config(Config const& other) = default;
   Config(Config&& other) = default;
   Config& operator=(Config const& other) = default;
   Config& operator=(Config&& other) = default;
   Config()
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, ::efl::eo::concrete{nullptr}, _eo_class());
   }
   Config( ::efl::eo::concrete parent)
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, parent, _eo_class());
   }
   template <typename F> Config(F f, typename ::std::enable_if< ::efl::eolian::is_callable<F>::value>::type* = 0)
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, ::efl::eo::concrete{nullptr}, _eo_class(), f);
   }
   static Eo_Class const* _eo_class()
   {
      return EFL_CONFIG_INTERFACE;
   }
   Eo* _eo_ptr() const { return *(Eo**)this; }
   /// @cond LOCAL
    ::efl::eolian::address_of_operator<Config> operator&() { return {this}; }
    ::efl::eolian::address_of_operator<Config const > operator&() const { return {this}; }
   /// @endcond
};
static_assert(sizeof(Config) == sizeof(Eo*), "");
static_assert(std::is_standard_layout<Config>::value, "");
} 
#include "efl_config.eo.impl.hh"
#endif
