/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.output.text;

import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.libreoffice.report.pentaho.styles.LengthCalculator;

public class PageContext {
    public static final int KEEP_TOGETHER_GROUP = 1;
    public static final int KEEP_TOGETHER_FIRST_DETAIL = 2;
    private PageContext parent;
    private String header;
    private CSSNumericValue headerHeight;
    private String footer;
    private CSSNumericValue footerHeight;
    private int keepTogether;
    private Integer columnCount = null;
    private boolean sectionOpen;

    public PageContext() {
        this(null);
    }

    public PageContext(PageContext parent) {
        this.parent = parent;
        if (parent != null) {
            this.keepTogether = parent.getKeepTogether();
        }
    }

    public int getActiveColumns() {
        for (PageContext pc = this; pc != null; pc = pc.getParent()) {
            if (this.columnCount == null) continue;
            return this.columnCount;
        }
        return 1;
    }

    public void setColumnCount(Integer columnCount) {
        this.columnCount = columnCount;
    }

    public Integer getColumnCount() {
        return this.columnCount;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header, CSSNumericValue height) {
        this.header = header;
        this.headerHeight = height;
    }

    public String getFooter() {
        return this.footer;
    }

    private CSSNumericValue getHeaderHeight() {
        return this.headerHeight;
    }

    private CSSNumericValue getFooterHeight() {
        return this.footerHeight;
    }

    public void setFooter(String footer, CSSNumericValue height) {
        this.footer = footer;
        this.footerHeight = height;
    }

    public int getKeepTogether() {
        return this.keepTogether;
    }

    public void setKeepTogether(int keepTogether) {
        this.keepTogether = keepTogether;
    }

    public PageContext getParent() {
        return this.parent;
    }

    public CSSNumericValue getAllFooterSize() {
        if (this.parent == null) {
            return this.footerHeight;
        }
        LengthCalculator lnc = new LengthCalculator();
        for (PageContext pc = this; pc != null; pc = pc.getParent()) {
            lnc.add(pc.getFooterHeight());
        }
        return lnc.getResult();
    }

    public CSSNumericValue getAllHeaderSize() {
        if (this.parent == null) {
            return this.headerHeight;
        }
        LengthCalculator lnc = new LengthCalculator();
        for (PageContext pc = this; pc != null; pc = pc.getParent()) {
            lnc.add(pc.getHeaderHeight());
        }
        return lnc.getResult();
    }

    public String getPageFooterContent() {
        if (this.parent == null) {
            return this.getFooter();
        }
        StringBuffer b = new StringBuffer();
        for (PageContext pc = this; pc != null; pc = pc.getParent()) {
            String footer_ = pc.getFooter();
            if (footer_ == null) continue;
            b.append(footer_);
        }
        if (b.length() != 0) {
            return b.toString();
        }
        return null;
    }

    public String getPageHeaderContent() {
        if (this.parent == null) {
            return this.getHeader();
        }
        StringBuffer b = new StringBuffer();
        b.append(this.parent.getPageHeaderContent());
        b.append(this.getHeader());
        if (b.length() != 0) {
            return b.toString();
        }
        return null;
    }

    public boolean isSectionOpen() {
        return this.sectionOpen;
    }

    public void setSectionOpen(boolean sectionOpen) {
        this.sectionOpen = sectionOpen;
    }
}

