/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.TypeCapabilities;
import kotlin.reflect.jvm.internal.impl.types.TypeCapability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SingletonTypeCapabilities
implements TypeCapabilities {
    private final Class<?> clazz;
    private final TypeCapability typeCapability;

    @Override
    @Nullable
    public <T extends TypeCapability> T getCapability(@NotNull Class<T> capabilityClass) {
        Intrinsics.checkParameterIsNotNull(capabilityClass, "capabilityClass");
        if (Intrinsics.areEqual(capabilityClass, this.clazz)) {
            TypeCapability typeCapability = this.typeCapability;
            if (typeCapability == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            return (T)typeCapability;
        }
        return (T)((TypeCapability)null);
    }

    public SingletonTypeCapabilities(@NotNull Class<?> clazz, @NotNull TypeCapability typeCapability) {
        Intrinsics.checkParameterIsNotNull(clazz, "clazz");
        Intrinsics.checkParameterIsNotNull(typeCapability, "typeCapability");
        this.clazz = clazz;
        this.typeCapability = typeCapability;
    }
}

