/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.search;

public final class ReplacePattern {
    private String replaceExpression;
    private boolean preserveCase;

    private ReplacePattern(String string, boolean bl) {
        this.replaceExpression = string;
        this.preserveCase = bl;
    }

    public static ReplacePattern create(String string, boolean bl) {
        return new ReplacePattern(string, bl);
    }

    public String getReplaceExpression() {
        return this.replaceExpression;
    }

    public boolean isPreserveCase() {
        return this.preserveCase;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ReplacePattern)) {
            return false;
        }
        ReplacePattern replacePattern = (ReplacePattern)object;
        return this.replaceExpression.equals(replacePattern.getReplaceExpression()) && this.preserveCase == replacePattern.isPreserveCase();
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + (this.preserveCase ? 1 : 0);
        n = 37 * n + this.replaceExpression.hashCode();
        return n;
    }

    public ReplacePattern changeReplaceExpression(String string) {
        if (string == null && this.replaceExpression == null || string != null && string.equals(this.replaceExpression)) {
            return this;
        }
        return ReplacePattern.create(string, this.preserveCase);
    }

    public ReplacePattern changePreserveCase(boolean bl) {
        if (this.preserveCase == bl) {
            return this;
        }
        return ReplacePattern.create(this.replaceExpression, bl);
    }

    String toCanonicalString() {
        char c = this.isPreserveCase() ? (char)'P' : 'p';
        return "" + c + "-" + this.getReplaceExpression();
    }

    static ReplacePattern parsePattern(String string) {
        if (string == null || Character.toUpperCase(string.charAt(0)) != 'P' || string.charAt(1) != '-') {
            return null;
        }
        boolean bl = Character.isUpperCase(string.charAt(0));
        String string2 = string.substring(2);
        return new ReplacePattern(string2, bl);
    }
}

