/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import org.apache.lucene.codecs.blocktree.FieldReader;
import org.apache.lucene.codecs.blocktree.Stats;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.packed.PackedLongValues;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AtomicOrdinalsFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexOrdinalsFieldData;
import org.elasticsearch.index.fielddata.RamAccountingTermsEnum;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;
import org.elasticsearch.index.fielddata.plain.AbstractAtomicOrdinalsFieldData;
import org.elasticsearch.index.fielddata.plain.AbstractIndexFieldData;
import org.elasticsearch.index.fielddata.plain.AbstractIndexOrdinalsFieldData;
import org.elasticsearch.index.fielddata.plain.PagedBytesAtomicFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;

public class PagedBytesIndexFieldData
extends AbstractIndexOrdinalsFieldData {
    public PagedBytesIndexFieldData(Index index, Settings indexSettings, MappedFieldType.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache cache, CircuitBreakerService breakerService) {
        super(index, indexSettings, fieldNames, fieldDataType, cache, breakerService);
    }

    /*
     * Loose catch block
     */
    @Override
    public AtomicOrdinalsFieldData loadDirect(LeafReaderContext context) throws Exception {
        LeafReader reader = context.reader();
        AtomicOrdinalsFieldData data = null;
        PagedBytesEstimator estimator = new PagedBytesEstimator(context, this.breakerService.getBreaker("fielddata"), this.getFieldNames().fullName());
        Terms terms = reader.terms(this.getFieldNames().indexName());
        if (terms == null) {
            data = AbstractAtomicOrdinalsFieldData.empty();
            estimator.afterLoad(null, data.ramBytesUsed());
            return data;
        }
        PagedBytes bytes = new PagedBytes(15);
        PackedLongValues.Builder termOrdToBytesOffset = PackedLongValues.monotonicBuilder((float)0.0f);
        long numTerms = this.regex == null && this.frequency == null ? terms.size() : -1L;
        float acceptableTransientOverheadRatio = this.fieldDataType.getSettings().getAsFloat("acceptable_transient_overhead_ratio", Float.valueOf(0.5f)).floatValue();
        TermsEnum termsEnum = estimator.beforeLoad(terms);
        boolean success = false;
        try {
            try (OrdinalsBuilder builder = new OrdinalsBuilder(numTerms, reader.maxDoc(), acceptableTransientOverheadRatio);){
                PostingsEnum docsEnum = null;
                BytesRef term = termsEnum.next();
                while (term != null) {
                    long termOrd = builder.nextOrdinal();
                    assert (termOrd == termOrdToBytesOffset.size());
                    termOrdToBytesOffset.add(bytes.copyUsingLengthPrefix(term));
                    docsEnum = termsEnum.postings(docsEnum, 0);
                    int docId = docsEnum.nextDoc();
                    while (docId != Integer.MAX_VALUE) {
                        builder.addDoc(docId);
                        docId = docsEnum.nextDoc();
                    }
                    term = termsEnum.next();
                }
                PagedBytes.Reader bytesReader = bytes.freeze(true);
                Ordinals ordinals = builder.build(this.fieldDataType.getSettings());
                data = new PagedBytesAtomicFieldData(bytesReader, termOrdToBytesOffset.build(), ordinals);
                success = true;
                AtomicOrdinalsFieldData atomicOrdinalsFieldData = data;
                return atomicOrdinalsFieldData;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (!success) {
                estimator.afterLoad(termsEnum, 0L);
            } else {
                estimator.afterLoad(termsEnum, data.ramBytesUsed());
            }
        }
    }

    static final class FilterSettingFields {
        static final String ACCEPTABLE_TRANSIENT_OVERHEAD_RATIO = "acceptable_transient_overhead_ratio";
        static final String FREQUENCY_MIN = "filter.frequency.min";
        static final String FREQUENCY_MAX = "filter.frequency.max";
        static final String FREQUENCY_MIN_SEGMENT_SIZE = "filter.frequency.min_segment_size";
        static final String REGEX_PATTERN = "filter.regex.pattern";

        FilterSettingFields() {
        }
    }

    public class PagedBytesEstimator
    implements AbstractIndexFieldData.PerValueEstimator {
        private final LeafReaderContext context;
        private final CircuitBreaker breaker;
        private final String fieldName;
        private long estimatedBytes;

        PagedBytesEstimator(LeafReaderContext context, CircuitBreaker breaker, String fieldName) {
            this.breaker = breaker;
            this.context = context;
            this.fieldName = fieldName;
        }

        @Override
        public long bytesPerValue(BytesRef term) {
            if (term == null) {
                return 0L;
            }
            long bytes = term.length;
            bytes += 64L;
            bytes = (long)((double)bytes / 1.5) + 1L;
            return bytes;
        }

        public long estimateStringFieldData() {
            try {
                LeafReader reader = this.context.reader();
                Terms terms = reader.terms(PagedBytesIndexFieldData.this.getFieldNames().indexName());
                Fields fields = reader.fields();
                Terms fieldTerms = fields.terms(PagedBytesIndexFieldData.this.getFieldNames().indexName());
                if (fieldTerms instanceof FieldReader) {
                    Stats stats = ((FieldReader)fieldTerms).getStats();
                    long totalTermBytes = stats.totalTermBytes;
                    if (PagedBytesIndexFieldData.this.logger.isTraceEnabled()) {
                        PagedBytesIndexFieldData.this.logger.trace("totalTermBytes: {}, terms.size(): {}, terms.getSumDocFreq(): {}", totalTermBytes, terms.size(), terms.getSumDocFreq());
                    }
                    long totalBytes = totalTermBytes + 2L * terms.size() + 4L * terms.getSumDocFreq();
                    return totalBytes;
                }
            }
            catch (Exception e) {
                PagedBytesIndexFieldData.this.logger.warn("Unable to estimate memory overhead", e, new Object[0]);
            }
            return 0L;
        }

        @Override
        public TermsEnum beforeLoad(Terms terms) throws IOException {
            float acceptableTransientOverheadRatio = PagedBytesIndexFieldData.this.fieldDataType.getSettings().getAsFloat("acceptable_transient_overhead_ratio", Float.valueOf(0.5f)).floatValue();
            LeafReader reader = this.context.reader();
            if (acceptableTransientOverheadRatio != 0.5f || PagedBytesIndexFieldData.this.fieldDataType.getSettings().getAsDouble("filter.frequency.min", (Double)0.0) != 0.0 || PagedBytesIndexFieldData.this.fieldDataType.getSettings().getAsDouble("filter.frequency.max", (Double)0.0) != 0.0 || PagedBytesIndexFieldData.this.fieldDataType.getSettings().getAsDouble("filter.frequency.min_segment_size", (Double)0.0) != 0.0 || PagedBytesIndexFieldData.this.fieldDataType.getSettings().get("filter.regex.pattern") != null) {
                if (PagedBytesIndexFieldData.this.logger.isTraceEnabled()) {
                    PagedBytesIndexFieldData.this.logger.trace("Filter exists, can't circuit break normally, using RamAccountingTermsEnum", new Object[0]);
                }
                return new RamAccountingTermsEnum(PagedBytesIndexFieldData.this.filter(terms, reader), this.breaker, this, this.fieldName);
            }
            this.estimatedBytes = this.estimateStringFieldData();
            if (this.estimatedBytes == 0L) {
                return new RamAccountingTermsEnum(PagedBytesIndexFieldData.this.filter(terms, reader), this.breaker, this, this.fieldName);
            }
            this.breaker.addEstimateBytesAndMaybeBreak(this.estimatedBytes, this.fieldName);
            return PagedBytesIndexFieldData.this.filter(terms, reader);
        }

        @Override
        public void afterLoad(TermsEnum termsEnum, long actualUsed) {
            if (termsEnum instanceof RamAccountingTermsEnum) {
                this.estimatedBytes = ((RamAccountingTermsEnum)termsEnum).getTotalBytes();
            }
            this.breaker.addWithoutBreaking(-(this.estimatedBytes - actualUsed));
        }

        public void adjustForNoTerms(long actualUsed) {
            this.breaker.addWithoutBreaking(actualUsed);
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        public IndexOrdinalsFieldData build(Index index, Settings indexSettings, MappedFieldType fieldType, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService) {
            return new PagedBytesIndexFieldData(index, indexSettings, fieldType.names(), fieldType.fieldDataType(), cache, breakerService);
        }
    }
}

