/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryBuilder;

public class GeoDistanceQueryBuilder
extends QueryBuilder {
    private final String name;
    private String distance;
    private double lat;
    private double lon;
    private String geohash;
    private GeoDistance geoDistance;
    private String optimizeBbox;
    private String queryName;
    private Boolean coerce;
    private Boolean ignoreMalformed;

    public GeoDistanceQueryBuilder(String name) {
        this.name = name;
    }

    public GeoDistanceQueryBuilder point(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
        return this;
    }

    public GeoDistanceQueryBuilder lat(double lat) {
        this.lat = lat;
        return this;
    }

    public GeoDistanceQueryBuilder lon(double lon) {
        this.lon = lon;
        return this;
    }

    public GeoDistanceQueryBuilder distance(String distance) {
        this.distance = distance;
        return this;
    }

    public GeoDistanceQueryBuilder distance(double distance, DistanceUnit unit) {
        this.distance = unit.toString(distance);
        return this;
    }

    public GeoDistanceQueryBuilder geohash(String geohash) {
        this.geohash = geohash;
        return this;
    }

    public GeoDistanceQueryBuilder geoDistance(GeoDistance geoDistance) {
        this.geoDistance = geoDistance;
        return this;
    }

    public GeoDistanceQueryBuilder optimizeBbox(String optimizeBbox) {
        this.optimizeBbox = optimizeBbox;
        return this;
    }

    public GeoDistanceQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    public GeoDistanceQueryBuilder coerce(boolean coerce) {
        this.coerce = coerce;
        return this;
    }

    public GeoDistanceQueryBuilder ignoreMalformed(boolean ignoreMalformed) {
        this.ignoreMalformed = ignoreMalformed;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("geo_distance");
        if (this.geohash != null) {
            builder.field(this.name, this.geohash);
        } else {
            builder.startArray(this.name).value(this.lon).value(this.lat).endArray();
        }
        builder.field("distance", this.distance);
        if (this.geoDistance != null) {
            builder.field("distance_type", this.geoDistance.name().toLowerCase(Locale.ROOT));
        }
        if (this.optimizeBbox != null) {
            builder.field("optimize_bbox", this.optimizeBbox);
        }
        if (this.queryName != null) {
            builder.field("_name", this.queryName);
        }
        if (this.coerce != null) {
            builder.field("coerce", (Object)this.coerce);
        }
        if (this.ignoreMalformed != null) {
            builder.field("ignore_malformed", (Object)this.ignoreMalformed);
        }
        builder.endObject();
    }
}

