/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;

public class SpanNearQueryParser
implements QueryParser {
    public static final String NAME = "span_near";

    @Inject
    public SpanNearQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        Query query;
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        float boost = 1.0f;
        Integer slop = null;
        boolean inOrder = true;
        boolean collectPayloads = true;
        String queryName = null;
        ArrayList<SpanQuery> clauses = new ArrayList<SpanQuery>();
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if ("clauses".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        query = parseContext.parseInnerQuery();
                        if (!(query instanceof SpanQuery)) {
                            throw new QueryParsingException(parseContext, "spanNear [clauses] must be of type span query", new Object[0]);
                        }
                        clauses.add((SpanQuery)query);
                    }
                    continue;
                }
                throw new QueryParsingException(parseContext, "[span_near] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (token.isValue()) {
                if ("in_order".equals(currentFieldName) || "inOrder".equals(currentFieldName)) {
                    inOrder = parser.booleanValue();
                    continue;
                }
                if ("collect_payloads".equals(currentFieldName) || "collectPayloads".equals(currentFieldName)) {
                    collectPayloads = parser.booleanValue();
                    continue;
                }
                if ("slop".equals(currentFieldName)) {
                    slop = parser.intValue();
                    continue;
                }
                if ("boost".equals(currentFieldName)) {
                    boost = parser.floatValue();
                    continue;
                }
                if ("_name".equals(currentFieldName)) {
                    queryName = parser.text();
                    continue;
                }
                throw new QueryParsingException(parseContext, "[span_near] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            throw new QueryParsingException(parseContext, "[span_near] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (clauses.isEmpty()) {
            throw new QueryParsingException(parseContext, "span_near must include [clauses]", new Object[0]);
        }
        if (slop == null) {
            throw new QueryParsingException(parseContext, "span_near must include [slop]", new Object[0]);
        }
        query = new SpanNearQuery(clauses.toArray(new SpanQuery[clauses.size()]), slop.intValue(), inOrder, collectPayloads);
        query.setBoost(boost);
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, query);
        }
        return query;
    }
}

