/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.SB;
import javajs.util.T3;
import org.jmol.java.BS;
import org.jmol.smiles.InvalidSmilesException;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;
import org.jmol.smiles.SmilesMatcher;
import org.jmol.smiles.SmilesParser;
import org.jmol.smiles.SmilesSearch;
import org.jmol.smiles.SmilesStereo;
import org.jmol.smiles.VTemp;
import org.jmol.util.BSUtil;
import org.jmol.util.Edge;
import org.jmol.util.Elements;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.Node;

public class SmilesGenerator {
    private Node[] atoms;
    private int ac;
    private BS bsSelected;
    private BS bsAromatic;
    private int flags;
    private boolean explicitH;
    private SB ringSets;
    private VTemp vTemp = new VTemp();
    private int nPairs;
    private int nPairsMax;
    private BS bsBondsUp = new BS();
    private BS bsBondsDn = new BS();
    private BS bsToDo;
    private Node prevAtom;
    private Node[] prevSp2Atoms;
    private Map<String, Object[]> htRingsSequence = new Hashtable<String, Object[]>();
    private Map<String, Object[]> htRings = new Hashtable<String, Object[]>();
    private BS bsRingKeys = new BS();
    private BS bsIncludingH;
    private boolean topologyOnly;
    boolean getAromatic = true;
    private boolean addAtomComment;
    private boolean noBioComment;
    private boolean aromaticDouble;
    private boolean noStereo;
    private boolean openSMILES;
    public P3 polySmilesCenter;
    private SmilesStereo smilesStereo;
    private boolean isPolyhedral;
    private Lst<BS> aromaticRings;
    private SmilesMatcher sm;
    private int iHypervalent;
    private Node[] atemp;
    private int chainCheck;

    String getSmiles(SmilesMatcher sm, Node[] atoms, int ac, BS bsSelected, String comment, int flags) throws InvalidSmilesException {
        int ipt = bsSelected.nextSetBit(0);
        if (ipt < 0) {
            return "";
        }
        this.sm = sm;
        this.flags = flags;
        this.atoms = atoms;
        this.ac = ac;
        this.bsSelected = bsSelected = BSUtil.copy((BS)bsSelected);
        this.flags = flags = SmilesSearch.addFlags(flags, comment == null ? "" : comment.toUpperCase());
        if ((flags & 0x100000) == 0x100000) {
            return this.getBioSmiles(bsSelected, comment, flags);
        }
        this.openSMILES = (flags & 5) == 5;
        this.addAtomComment = (flags & 0x20000) == 131072;
        this.aromaticDouble = (flags & 0x200) == 512;
        this.explicitH = (flags & 0x1000) == 4096;
        this.topologyOnly = (flags & 0x2000) == 8192;
        this.getAromatic = (flags & 0x10) != 16;
        this.noStereo = (flags & 0x20) == 32;
        this.isPolyhedral = (flags & 0x10000) == 65536;
        return this.getSmilesComponent(atoms[ipt], bsSelected, true, false, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getBioSmiles(BS bsSelected, String comment, int flags) throws InvalidSmilesException {
        String s;
        SB sb;
        boolean noBioComments;
        boolean allowUnmatchedRings;
        block26: {
            this.addAtomComment = (flags & 0x20000) == 131072;
            allowUnmatchedRings = (flags & 0x300000) == 0x300000;
            noBioComments = (flags & 0x2100000) == 0x2100000;
            boolean crosslinkCovalent = (flags & 0x500000) == 0x500000;
            boolean crosslinkHBonds = (flags & 0x900000) == 0x900000;
            boolean addCrosslinks = crosslinkCovalent || crosslinkHBonds;
            sb = new SB();
            BS bs = bsSelected;
            if (comment != null && !this.noBioComment) {
                sb.append("//* Jmol bioSMILES ").append(comment.replace('*', '_')).append(" *//");
            }
            String end = this.noBioComment ? "" : "\n";
            BS bsIgnore = new BS();
            String lastComponent = null;
            String groupString = "";
            Lst vLinks = new Lst();
            try {
                int len = 0;
                int i = bs.nextSetBit(0);
                while (i >= 0) {
                    block25: {
                        boolean unknown;
                        String bioStructureName;
                        String ch;
                        Node a;
                        block27: {
                            block28: {
                                a = this.atoms[i];
                                ch = a.getGroup1('?');
                                bioStructureName = a.getBioStructureTypeName();
                                boolean bl = unknown = ch == ch.toLowerCase();
                                if (end == null) break block27;
                                if (sb.length() > 0) {
                                    sb.append(end);
                                }
                                end = null;
                                len = 0;
                                if (bioStructureName.length() > 0) break block28;
                                s = this.getSmilesComponent(a, bs, false, true, true);
                                if (s.equals(lastComponent)) {
                                    end = "";
                                    break block25;
                                } else {
                                    String key;
                                    lastComponent = s;
                                    String groupName = a.getGroup3(true);
                                    if (noBioComments) {
                                        key = "/" + s + "/";
                                    } else {
                                        if (groupName != null) {
                                            s = "//* " + groupName + " *//" + s;
                                        }
                                        key = s + "//";
                                    }
                                    if (groupString.indexOf(key) >= 0) {
                                        end = "";
                                        break block25;
                                    } else {
                                        groupString = groupString + key;
                                        sb.append(s);
                                        end = noBioComments ? "." : ".\n";
                                    }
                                }
                                break block25;
                            }
                            int id = a.getChainID();
                            if (id != 0 && !noBioComments) {
                                s = "//* chain " + a.getChainIDStr() + " " + bioStructureName + " " + a.getResno() + " *// ";
                                len = s.length();
                                sb.append(s);
                            }
                            ++len;
                            sb.append("~").appendC(bioStructureName.toLowerCase().charAt(0)).append("~");
                        }
                        if (len >= 75 && !noBioComments) {
                            sb.append("\n  ");
                            len = 2;
                        }
                        if (this.addAtomComment) {
                            sb.append("\n//* [" + a.getGroup3(false) + "#" + a.getResno() + "] *//\t");
                        }
                        if (unknown) {
                            this.addBracketedBioName(sb, a, bioStructureName.length() > 0 ? ".0" : null, false);
                        } else {
                            sb.append(ch);
                        }
                        ++len;
                        if (addCrosslinks) {
                            a.getCrossLinkVector(vLinks, crosslinkCovalent, crosslinkHBonds);
                            for (int j = 0; j < vLinks.size(); len += 1 + s.length(), j += 3) {
                                sb.append(":");
                                s = this.getRingCache((Integer)vLinks.get(j), (Integer)vLinks.get(j + 1), this.htRingsSequence);
                                sb.append(s);
                            }
                            vLinks.clear();
                        }
                        a.getGroupBits(bsIgnore);
                        bs.andNot(bsIgnore);
                        int i2 = a.getOffsetResidueAtom("\u0000", 1);
                        if (i2 < 0 || !bs.get(i2)) {
                            if (!noBioComments) {
                                sb.append(" //* ").appendI(a.getResno()).append(" *//");
                            }
                            if (i2 < 0 && (i2 = bs.nextSetBit(i + 1)) < 0) break block26;
                            if (len > 0) {
                                end = noBioComments ? "." : ".\n";
                            }
                        }
                        i = i2 - 1;
                    }
                    i = bs.nextSetBit(i + 1);
                }
            }
            catch (Exception e) {
                throw new InvalidSmilesException("//* error: " + e.getMessage() + " *//");
            }
        }
        if (!allowUnmatchedRings && !this.htRingsSequence.isEmpty()) {
            this.dumpRingKeys(sb, this.htRingsSequence);
            throw new InvalidSmilesException("//* ?ring error? *//");
        }
        s = sb.toString();
        if (s.endsWith(".\n")) {
            return s.substring(0, s.length() - 2);
        }
        if (!noBioComments) return s;
        if (!s.endsWith(".")) return s;
        return s.substring(0, s.length() - 1);
    }

    private void addBracketedBioName(SB sb, Node atom, String atomName, boolean addComment) {
        sb.append("[");
        if (atomName != null) {
            String chain = atom.getChainIDStr();
            sb.append(atom.getGroup3(false));
            if (!atomName.equals(".0")) {
                sb.append(atomName).append("#").appendI(atom.getElementNumber());
            }
            if (addComment) {
                sb.append("//* ").appendI(atom.getResno());
                if (chain.length() > 0) {
                    sb.append(":").append(chain);
                }
                sb.append(" *//");
            }
        } else {
            sb.append(Elements.elementNameFromNumber((int)atom.getElementNumber()));
        }
        sb.append("]");
    }

    private String getSmilesComponent(Node atom, BS bs, boolean allowBioResidues, boolean allowConnectionsToOutsideWorld, boolean forceBrackets) throws InvalidSmilesException {
        if (!this.explicitH && atom.getElementNumber() == 1 && atom.getEdges().length > 0) {
            atom = this.atoms[atom.getBondedAtomIndex(0)];
        }
        this.bsSelected = JmolMolecule.getBranchBitSet((Node[])this.atoms, (int)atom.getIndex(), (BS)BSUtil.copy((BS)bs), null, (int)-1, (boolean)true, (boolean)allowBioResidues);
        bs.andNot(this.bsSelected);
        this.iHypervalent = -1;
        int i = this.bsSelected.nextSetBit(0);
        while (i >= 0 && this.iHypervalent < 0) {
            if (this.atoms[i].getCovalentBondCount() > 4 || this.isPolyhedral) {
                this.iHypervalent = i;
            }
            i = this.bsSelected.nextSetBit(i + 1);
        }
        this.bsIncludingH = BSUtil.copy((BS)this.bsSelected);
        if (!this.explicitH) {
            int j = this.bsSelected.nextSetBit(0);
            while (j >= 0) {
                Node a = this.atoms[j];
                if (a.getElementNumber() == 1 && a.getIsotopeNumber() == 0 && a.getBondCount() > 0 && a.getBondedAtomIndex(0) != this.iHypervalent) {
                    this.bsSelected.clear(j);
                }
                j = this.bsSelected.nextSetBit(j + 1);
            }
        }
        this.bsAromatic = new BS();
        if (!this.topologyOnly && this.bsSelected.cardinality() > 2) {
            this.generateRingData();
            this.setBondDirections();
        }
        this.bsToDo = BSUtil.copy((BS)this.bsSelected);
        SB sb = new SB();
        int i2 = this.bsToDo.nextSetBit(0);
        while (i2 >= 0) {
            if (this.atoms[i2].getCovalentBondCount() > 4 || this.isPolyhedral) {
                if (atom == null) {
                    sb.append(".");
                }
                this.getSmilesAt(sb, this.atoms[i2], allowConnectionsToOutsideWorld, false, forceBrackets);
                atom = null;
            }
            i2 = this.bsToDo.nextSetBit(i2 + 1);
        }
        if (atom != null) {
            while ((atom = this.getSmilesAt(sb, atom, allowConnectionsToOutsideWorld, true, forceBrackets)) != null) {
            }
        }
        while (this.bsToDo.cardinality() > 0 || !this.htRings.isEmpty()) {
            Iterator<Object[]> e = this.htRings.values().iterator();
            if (e.hasNext()) {
                atom = this.atoms[(Integer)e.next()[1]];
                if (!this.bsToDo.get(atom.getIndex())) {
                    break;
                }
            } else {
                atom = this.atoms[this.bsToDo.nextSetBit(0)];
            }
            sb.append(".");
            this.prevSp2Atoms = null;
            this.prevAtom = null;
            while ((atom = this.getSmilesAt(sb, atom, allowConnectionsToOutsideWorld, true, forceBrackets)) != null) {
            }
        }
        if (!this.htRings.isEmpty()) {
            this.dumpRingKeys(sb, this.htRings);
            throw new InvalidSmilesException("//* ?ring error? *//\n" + sb);
        }
        String s = sb.toString();
        if (s.indexOf("^-") >= 0) {
            String s0 = s;
            try {
                int pt;
                String keys = this.sm.getAtropisomerKeys(s, this.atoms, this.ac, this.bsSelected, this.bsAromatic, this.flags);
                for (int i3 = 1; i3 < keys.length() && (pt = s.indexOf("^-")) >= 0; i3 += 3) {
                    s = s.substring(0, pt + 1) + keys.substring(i3, i3 + 2) + s.substring(pt + 1);
                }
            }
            catch (Exception e) {
                System.out.println("???");
                s = s0;
            }
        }
        return s;
    }

    private void generateRingData() throws InvalidSmilesException {
        SmilesSearch search = SmilesParser.newSearch("[r500]", true, true);
        search.targetAtoms = this.atoms;
        search.setSelected(this.bsSelected);
        search.setFlags(this.flags);
        search.targetAtomCount = this.ac;
        search.ringDataMax = 7;
        search.flags = this.flags;
        Lst[] vRings = AU.createArrayOfArrayList((int)4);
        search.setRingData(null, vRings, true);
        this.bsAromatic = search.bsAromatic;
        this.ringSets = search.ringSets;
        this.aromaticRings = vRings[3];
    }

    private char getBondStereochemistry(Edge bond, Node atomFrom) {
        boolean isFirst;
        if (bond == null) {
            return '\u0000';
        }
        int i = bond.index;
        boolean bl = isFirst = atomFrom == null || bond.getAtomIndex1() == atomFrom.getIndex();
        return (char)(this.bsBondsUp.get(i) ? (isFirst ? 47 : 92) : (this.bsBondsDn.get(i) ? (isFirst ? 92 : 47) : 0));
    }

    private void setBondDirections() {
        BS bsDone = new BS();
        Edge[][] edges = new Edge[2][3];
        int i = this.bsSelected.nextSetBit(0);
        while (i >= 0) {
            Node atom1 = this.atoms[i];
            Edge[] bonds = atom1.getEdges();
            for (int k = 0; k < bonds.length; ++k) {
                Node atom2;
                Edge bond = bonds[k];
                int index = bond.index;
                if (bsDone.get(index) || bond.getCovalentOrder() != 2 || SmilesSearch.isRingBond(this.ringSets, i, (atom2 = bond.getOtherAtomNode(atom1)).getIndex())) continue;
                bsDone.set(index);
                int nCumulene = 0;
                Node a10 = atom1;
                while (atom2.getCovalentBondCount() == 2 && atom2.getValence() == 4) {
                    Edge[] e2;
                    Edge e = e2[(e2 = atom2.getEdges())[0].getOtherAtomNode(atom2) == a10 ? 1 : 0];
                    bsDone.set(e.index);
                    a10 = atom2;
                    atom2 = e.getOtherAtomNode(atom2);
                    ++nCumulene;
                }
                if (nCumulene % 2 == 1) continue;
                Edge b0 = null;
                Node a0 = null;
                int i0 = 0;
                Node[] atom12 = new Node[]{atom1, atom2};
                int edgeCount = 1;
                for (int j = 0; j < 2 && edgeCount > 0 && edgeCount < 3; ++j) {
                    edgeCount = 0;
                    Node atomA = atom12[j];
                    Edge[] bb = atomA.getEdges();
                    for (int b = 0; b < bb.length; ++b) {
                        if (bb[b].getCovalentOrder() != 1 || bb[b].getOtherAtomNode(atomA).getElementNumber() == 1) continue;
                        edges[j][edgeCount++] = bb[b];
                        if (this.getBondStereochemistry(bb[b], atomA) == '\u0000') continue;
                        b0 = bb[b];
                        i0 = j;
                    }
                }
                if (edgeCount == 3 || edgeCount == 0) continue;
                if (b0 == null) {
                    i0 = 0;
                    b0 = edges[i0][0];
                    this.bsBondsUp.set(b0.index);
                }
                char c0 = this.getBondStereochemistry(b0, atom12[i0]);
                a0 = b0.getOtherAtomNode(atom12[i0]);
                if (a0 == null) continue;
                for (int j = 0; j < 2; ++j) {
                    for (int jj = 0; jj < 2; ++jj) {
                        Edge b1 = edges[j][jj];
                        if (b1 == null || b1 == b0) continue;
                        int bi = b1.index;
                        Node a1 = b1.getOtherAtomNode(atom12[j]);
                        if (a1 == null) continue;
                        char c1 = this.getBondStereochemistry(b1, atom12[j]);
                        boolean isOpposite = SmilesStereo.isDiaxial(atom12[i0], atom12[j], a0, a1, this.vTemp, 0.0f);
                        if (c1 == '\u0000' || c1 != c0 == isOpposite) {
                            boolean isUp = c0 == '\\' && isOpposite || c0 == '/' && !isOpposite;
                            if (isUp == (b1.getAtomIndex1() != a1.getIndex())) {
                                this.bsBondsUp.set(bi);
                            } else {
                                this.bsBondsDn.set(bi);
                            }
                        } else {
                            Logger.error((String)"BOND STEREOCHEMISTRY ERROR");
                        }
                        if (!Logger.debugging) continue;
                        Logger.debug((String)(this.getBondStereochemistry(b0, atom12[0]) + " " + a0.getIndex() + " " + a1.getIndex() + " " + this.getBondStereochemistry(b1, atom12[j])));
                    }
                }
            }
            i = this.bsSelected.nextSetBit(i + 1);
        }
    }

    private Node getSmilesAt(SB sb, Node atom, boolean allowConnectionsToOutsideWorld, boolean allowBranches, boolean forceBrackets) {
        int orderNext;
        Node[] sp2Atoms;
        int nSp2Atoms;
        int stereoFlag;
        int atomIndex = atom.getIndex();
        if (!this.bsToDo.get(atomIndex)) {
            return null;
        }
        this.bsToDo.clear(atomIndex);
        boolean includeHs = atomIndex == this.iHypervalent || this.explicitH;
        boolean isExtension = !this.bsSelected.get(atomIndex);
        int prevIndex = this.prevAtom == null ? -1 : this.prevAtom.getIndex();
        boolean isAromatic = this.bsAromatic.get(atomIndex);
        boolean havePreviousSp2Atoms = this.prevSp2Atoms != null;
        int atomicNumber = atom.getElementNumber();
        int nH = 0;
        Lst v = new Lst();
        Edge bondNext = null;
        Edge bondPrev = null;
        Edge[] bonds = atom.getEdges();
        if (this.polySmilesCenter != null) {
            allowBranches = false;
            this.sortBonds(atom, this.prevAtom, this.polySmilesCenter);
        }
        Node aH = null;
        int n = stereoFlag = isAromatic ? 10 : 0;
        if (Logger.debugging) {
            Logger.debug((String)sb.toString());
        }
        if (bonds != null) {
            int i = bonds.length;
            while (--i >= 0) {
                boolean isH;
                Edge bond = bonds[i];
                if (!bond.isCovalent()) continue;
                Node atom1 = bonds[i].getOtherAtomNode(atom);
                int index1 = atom1.getIndex();
                if (index1 == prevIndex) {
                    bondPrev = bonds[i];
                    continue;
                }
                boolean bl = isH = !includeHs && atom1.getElementNumber() == 1 && atom1.getIsotopeNumber() == 0;
                if (!this.bsIncludingH.get(index1)) {
                    if (isH || !allowConnectionsToOutsideWorld || !this.bsSelected.get(atomIndex)) continue;
                    this.bsToDo.set(index1);
                }
                if (isH) {
                    aH = atom1;
                    if (++nH <= 1) continue;
                    stereoFlag = 10;
                    continue;
                }
                v.addLast((Object)bonds[i]);
            }
        }
        int n2 = nSp2Atoms = (sp2Atoms = this.prevSp2Atoms) == null ? 1 : 2;
        if (sp2Atoms == null) {
            sp2Atoms = new Node[5];
        }
        String strPrev = null;
        if (bondPrev != null) {
            strPrev = this.getBondOrder(bondPrev, atomIndex, prevIndex, isAromatic);
            if (!havePreviousSp2Atoms) {
                sp2Atoms[0] = this.prevAtom;
            }
        }
        nSp2Atoms += nH;
        int nMax = 0;
        BS bsBranches = new BS();
        int nBonds = v.size();
        if (allowBranches) {
            for (int i = 0; i < nBonds; ++i) {
                Edge bond = (Edge)v.get(i);
                Node a = bond.getOtherAtomNode(atom);
                int n3 = a.getCovalentBondCount() - (includeHs ? 0 : a.getCovalentHydrogenCount());
                int order = bond.getCovalentOrder();
                if (n3 == 1 && (bondNext != null || i < nBonds - 1)) {
                    bsBranches.set(bond.index);
                    continue;
                }
                if (order <= 1 && n3 <= nMax || this.htRings.containsKey(SmilesGenerator.getRingKey(a.getIndex(), atomIndex))) continue;
                nMax = order > 1 ? 1000 + order : n3;
                bondNext = bond;
            }
        }
        Node atomNext = bondNext == null ? null : bondNext.getOtherAtomNode(atom);
        int n4 = orderNext = bondNext == null ? 0 : bondNext.getCovalentOrder();
        if (isAromatic || orderNext == 2 && nH > 1 || atomNext != null && SmilesSearch.isRingBond(this.ringSets, atomIndex, atomNext.getIndex())) {
            sp2Atoms = null;
        }
        Node[] stereo = new Node[7];
        if (stereoFlag < 7 && bondPrev != null) {
            if (havePreviousSp2Atoms && bondPrev.getCovalentOrder() == 2 && orderNext == 2 && this.prevSp2Atoms[1] != null) {
                stereo[stereoFlag++] = this.prevSp2Atoms[0];
                stereo[stereoFlag++] = this.prevSp2Atoms[1];
            } else {
                stereo[stereoFlag++] = this.prevAtom;
            }
        }
        if (stereoFlag < 7 && nH == 1) {
            stereo[stereoFlag++] = aH;
        }
        boolean deferStereo = orderNext == 1 && this.prevSp2Atoms == null;
        char chBond = this.getBondStereochemistry(bondPrev, this.prevAtom);
        if (strPrev != null || chBond != '\u0000') {
            if (chBond != '\u0000') {
                strPrev = "" + chBond;
            }
            sb.append(strPrev);
        }
        int stereoFlag0 = stereoFlag;
        int nSp2Atoms0 = nSp2Atoms;
        SB sbBranches = new SB();
        Lst vBranches = new Lst();
        for (int i = 0; i < v.size(); ++i) {
            Edge bond = (Edge)v.get(i);
            if (!bsBranches.get(bond.index)) continue;
            Node a = bond.getOtherAtomNode(atom);
            SB s2 = new SB();
            this.prevAtom = atom;
            this.prevSp2Atoms = null;
            Edge bond0t = bondNext;
            this.getSmilesAt(s2, a, allowConnectionsToOutsideWorld, allowBranches, forceBrackets);
            bondNext = bond0t;
            String branch = s2.toString();
            v.removeItemAt(i--);
            if (bondNext == null) {
                vBranches.addLast((Object)branch);
            } else {
                sbBranches.append("(").append(branch).append(")");
            }
            if (stereoFlag < 7) {
                stereo[stereoFlag++] = a;
            }
            if (sp2Atoms == null || nSp2Atoms >= 5) continue;
            sp2Atoms[nSp2Atoms++] = a;
        }
        SB sbRings = new SB();
        int stereoFlag1 = stereoFlag;
        int nSp2Atoms1 = nSp2Atoms;
        String atat = null;
        if (!(allowBranches || this.noStereo || this.polySmilesCenter != null || v.size() != 5 && v.size() != 6)) {
            atat = this.sortInorganic(atom, (Lst<Edge>)v, this.vTemp);
        }
        for (int i = 0; i < v.size(); ++i) {
            Edge bond = (Edge)v.get(i);
            if (bond == bondNext) continue;
            Node a = bond.getOtherAtomNode(atom);
            strPrev = this.getBondOrder(bond, atomIndex, a.getIndex(), isAromatic);
            if (!deferStereo && (chBond = this.getBondStereochemistry(bond, atom)) != '\u0000') {
                strPrev = "" + chBond;
            }
            sbRings.append(strPrev);
            sbRings.append(this.getRingCache(atomIndex, a.getIndex(), this.htRings));
            if (stereoFlag < 7) {
                stereo[stereoFlag++] = a;
            }
            if (sp2Atoms == null || nSp2Atoms >= 5) continue;
            sp2Atoms[nSp2Atoms++] = a;
        }
        if (stereoFlag0 != stereoFlag1 && stereoFlag1 != stereoFlag) {
            this.swapArray(stereo, stereoFlag0, stereoFlag1, stereoFlag);
        }
        if (nSp2Atoms0 != nSp2Atoms1 && nSp2Atoms1 != nSp2Atoms) {
            this.swapArray(sp2Atoms, nSp2Atoms0, nSp2Atoms1, nSp2Atoms);
        }
        if (havePreviousSp2Atoms && stereoFlag == 2 && orderNext == 2 && atomNext.getCovalentBondCount() == 3) {
            bonds = atomNext.getEdges();
            for (int k = 0; k < bonds.length; ++k) {
                if (!bonds[k].isCovalent() || atomNext.getBondedAtomIndex(k) == atomIndex) continue;
                stereo[stereoFlag++] = this.atoms[atomNext.getBondedAtomIndex(k)];
            }
            nSp2Atoms = 0;
        } else if (atomNext != null && stereoFlag < 7) {
            stereo[stereoFlag++] = atomNext;
        }
        int charge = atom.getFormalCharge();
        int isotope = atom.getIsotopeNumber();
        int valence = atom.getValence();
        float osclass = this.openSMILES ? atom.getFloatProperty("property_atomclass") : Float.NaN;
        String atomName = atom.getAtomName();
        String groupType = atom.getBioStructureTypeName();
        if (this.addAtomComment) {
            sb.append("\n//* " + atom.toString() + " *//\t");
        }
        if (this.topologyOnly) {
            sb.append("*");
        } else if (isExtension && groupType.length() != 0 && atomName.length() != 0) {
            this.addBracketedBioName(sb, atom, "." + atomName, false);
        } else {
            sb.append(SmilesAtom.getAtomLabel(atomicNumber, isotope, forceBrackets ? -1 : valence, charge, osclass, nH, isAromatic, (String)(atat != null ? atat : (this.noStereo ? null : this.checkStereoPairs(atom, atomIndex, stereo, stereoFlag)))));
        }
        sb.appendSB(sbRings);
        if (bondNext == null) {
            int n5 = vBranches.size() - 1;
            if (n5 >= 0) {
                for (int i = 0; i < n5; ++i) {
                    sb.append("(").append((String)vBranches.get(i)).append(")");
                }
                sb.append((String)vBranches.get(n5));
            }
            return null;
        }
        sb.appendSB(sbBranches);
        if (sp2Atoms != null && orderNext == 2 && (nSp2Atoms == 1 || nSp2Atoms == 2)) {
            if (sp2Atoms[0] == null) {
                sp2Atoms[0] = atom;
            }
            if (sp2Atoms[1] == null) {
                sp2Atoms[1] = atom;
            }
        } else {
            sp2Atoms = null;
            nSp2Atoms = 0;
        }
        this.prevSp2Atoms = sp2Atoms;
        this.prevAtom = atom;
        return atomNext;
    }

    private void swapArray(Node[] a, int i0, int i1, int i2) {
        int n = i1 - i0;
        if (this.atemp == null || this.atemp.length < n) {
            this.atemp = new Node[n];
        }
        int p = n;
        int i = i1;
        while (p > 0) {
            this.atemp[--p] = a[--i];
        }
        for (int i3 = i1; i3 < i2; ++i3) {
            a[i3 - n] = a[i3];
        }
        p = n;
        i = i2;
        while (p > 0) {
            a[--i] = this.atemp[--p];
        }
    }

    private String getBondOrder(Edge bondPrev, int atomIndex, int prevIndex, boolean isAromatic) {
        if (this.topologyOnly) {
            return "";
        }
        if ((bondPrev.order & 0x10001) == 65537) {
            return "^-";
        }
        int border = bondPrev.getCovalentOrder();
        return !isAromatic || !this.bsAromatic.get(prevIndex) ? SmilesBond.getBondOrderString(border) : (border == 1 && !this.isSameAromaticRing(atomIndex, prevIndex) ? "-" : (this.aromaticDouble && (border == 2 || border == 514) ? "=" : ""));
    }

    private boolean isSameAromaticRing(int a1, int a2) {
        int i = this.aromaticRings.size();
        while (--i >= 0) {
            BS bs = (BS)this.aromaticRings.get(i);
            if (!bs.get(a1) || !bs.get(a2)) continue;
            return true;
        }
        return false;
    }

    void sortBonds(Node atom, Node refAtom, P3 center) {
        if (this.smilesStereo == null) {
            try {
                this.smilesStereo = SmilesStereo.newStereo(null);
            }
            catch (InvalidSmilesException invalidSmilesException) {
                // empty catch block
            }
        }
        this.smilesStereo.sortBondsByStereo(atom, refAtom, (T3)center, atom.getEdges(), this.vTemp.vA);
    }

    private String sortInorganic(Node atom, Lst<Edge> v, VTemp vTemp) {
        Edge bond1;
        int atomIndex = atom.getIndex();
        int n = v.size();
        Lst axialPairs = new Lst();
        Lst bonds = new Lst();
        Node a01 = null;
        Node a02 = null;
        BS bsDone = new BS();
        Edge[] pair0 = null;
        Node[] stereo = new Node[6];
        boolean isOK = true;
        String s = "";
        int naxial = 0;
        for (int i = 0; i < n; ++i) {
            Node a1;
            bond1 = (Edge)v.get(i);
            stereo[0] = a1 = bond1.getOtherAtomNode(atom);
            if (i == 0) {
                s = this.addStereoCheck(0, atomIndex, a1, "", null);
            } else if (isOK && this.addStereoCheck(0, atomIndex, a1, s, null) != null) {
                isOK = false;
            }
            if (bsDone.get(i)) continue;
            bsDone.set(i);
            boolean isAxial = false;
            for (int j = i + 1; j < n; ++j) {
                Edge bond2;
                Node a2;
                if (bsDone.get(j) || !SmilesStereo.isDiaxial(atom, atom, a1, a2 = (bond2 = (Edge)v.get(j)).getOtherAtomNode(atom), vTemp, -0.95f)) continue;
                switch (++naxial) {
                    case 1: {
                        a01 = a1;
                        break;
                    }
                    case 2: {
                        a02 = a1;
                        break;
                    }
                    case 3: {
                        if (SmilesStereo.getHandedness(a02, a01, a1, atom, vTemp) != 2) break;
                        Edge b = bond1;
                        bond1 = bond2;
                        bond2 = b;
                    }
                }
                axialPairs.addLast((Object)new Edge[]{bond1, bond2});
                isAxial = true;
                bsDone.set(j);
                break;
            }
            if (isAxial) continue;
            bonds.addLast((Object)bond1);
        }
        int npAxial = axialPairs.size();
        if (isOK || n == 6 && npAxial != 3 || n == 5 && npAxial == 0) {
            return "";
        }
        pair0 = (Edge[])axialPairs.get(0);
        bond1 = pair0[0];
        stereo[0] = bond1.getOtherAtomNode(atom);
        v.clear();
        v.addLast((Object)bond1);
        if (npAxial > 1) {
            bonds.addLast((Object)((Edge[])axialPairs.get(1))[0]);
        }
        if (npAxial == 3) {
            bonds.addLast((Object)((Edge[])axialPairs.get(2))[0]);
        }
        if (npAxial > 1) {
            bonds.addLast((Object)((Edge[])axialPairs.get(1))[1]);
        }
        if (npAxial == 3) {
            bonds.addLast((Object)((Edge[])axialPairs.get(2))[1]);
        }
        for (int i = 0; i < bonds.size(); ++i) {
            bond1 = (Edge)bonds.get(i);
            v.addLast((Object)bond1);
            stereo[i + 1] = bond1.getOtherAtomNode(atom);
        }
        v.addLast((Object)pair0[1]);
        stereo[n - 1] = pair0[1].getOtherAtomNode(atom);
        return SmilesStereo.getStereoFlag(atom, stereo, n, vTemp);
    }

    private String checkStereoPairs(Node atom, int atomIndex, Node[] stereo, int stereoFlag) {
        if (stereoFlag < 4) {
            return "";
        }
        if (stereoFlag == 4 && atom.getElementNumber() == 6) {
            String s = "";
            for (int i = 0; i < 4; ++i) {
                if ((s = this.addStereoCheck(0, atomIndex, stereo[i], s, BSUtil.newAndSetBit((int)atomIndex))) != null) continue;
                stereoFlag = 10;
                break;
            }
        }
        return stereoFlag > 6 ? "" : SmilesStereo.getStereoFlag(atom, stereo, stereoFlag, this.vTemp);
    }

    private String addStereoCheck(int level, int atomIndex, Node atom, String s, BS bsDone) {
        int nh;
        if (bsDone != null) {
            bsDone.set(atomIndex);
        }
        int n = atom.getAtomicAndIsotopeNumber();
        int nx = atom.getCovalentBondCount();
        int n2 = nh = n == 6 && !this.explicitH ? atom.getCovalentHydrogenCount() : 0;
        if (n == 6 ? nx != 4 : n == 1 || nx > 1) {
            return s;
        }
        String sa = ";" + level + "/" + n + "/" + nh + "/" + nx + (level == 0 ? "," : "_");
        if (n == 6) {
            switch (nh) {
                case 1: {
                    return s + sa + ++this.chainCheck;
                }
                case 0: 
                case 2: {
                    if (bsDone == null) {
                        return s;
                    }
                    Edge[] edges = atom.getEdges();
                    String s2 = "";
                    String sa2 = "";
                    int nunique = nh == 2 ? 0 : 3;
                    int j = atom.getBondCount();
                    while (--j >= 0) {
                        Node a2 = edges[j].getOtherAtomNode(atom);
                        int i2 = a2.getIndex();
                        if (bsDone.get(i2) || !edges[j].isCovalent() || a2.getElementNumber() == 1) continue;
                        bsDone.set(i2);
                        sa2 = this.addStereoCheck(level + 1, atom.getIndex(), a2, "", bsDone);
                        if (s2.indexOf(sa2) >= 0) {
                            --nunique;
                        }
                        s2 = s2 + sa2;
                    }
                    if (nunique == 3) {
                        return s + sa + ++this.chainCheck;
                    }
                    sa = (sa + s2).replace(',', '_');
                    if (level <= 0) break;
                    return s + sa;
                }
            }
        }
        if (s.indexOf(sa) >= 0) {
            if (nh == 3) {
                int ndt = 0;
                for (int j = 0; j < nx && ndt < 3; ++j) {
                    int ia = atom.getBondedAtomIndex(j);
                    if (ia == atomIndex) continue;
                    ndt += this.atoms[ia].getAtomicAndIsotopeNumber();
                }
                if (ndt > 3) {
                    return s;
                }
            }
            return null;
        }
        return s + sa;
    }

    private String getRingCache(int i0, int i1, Map<String, Object[]> ht) {
        String s;
        String key = SmilesGenerator.getRingKey(i0, i1);
        Object[] o = ht.get(key);
        String string = s = o == null ? null : (String)o[0];
        if (s == null) {
            this.bsRingKeys.set(++this.nPairs);
            this.nPairsMax = Math.max(this.nPairs, this.nPairsMax);
            Object[] objectArray = new Object[3];
            s = this.getRingPointer(this.nPairs);
            objectArray[0] = s;
            objectArray[1] = i1;
            objectArray[2] = this.nPairs;
            ht.put(key, objectArray);
            if (Logger.debugging) {
                Logger.debug((String)("adding for " + i0 + " ring key " + this.nPairs + ": " + key));
            }
        } else {
            ht.remove(key);
            int nPair = (Integer)o[2];
            this.bsRingKeys.clear(nPair);
            if (this.bsRingKeys.nextSetBit(0) < 0 && (this.nPairsMax == 2 || this.nPairsMax == 99)) {
                this.nPairs = this.nPairsMax == 99 ? 10 : 0;
                this.nPairsMax = this.nPairs;
            }
            if (Logger.debugging) {
                Logger.debug((String)("using ring key " + key));
            }
        }
        return s;
    }

    private String getRingPointer(int i) {
        return i < 10 ? "" + i : (i < 100 ? "%" + i : "%(" + i + ")");
    }

    private void dumpRingKeys(SB sb, Map<String, Object[]> ht) {
        Logger.info((String)(sb.toString() + "\n\n"));
        for (String key : ht.keySet()) {
            Logger.info((String)("unmatched connection: " + key));
        }
    }

    protected static String getRingKey(int i0, int i1) {
        return Math.min(i0, i1) + "_" + Math.max(i0, i1);
    }
}

