/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.bugreport;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.gui.preferences.plugin.PluginPreference;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.plugins.PluginDownloadTask;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.bugreport.BugReport;
import org.openstreetmap.josm.tools.bugreport.BugReportQueue;
import org.openstreetmap.josm.tools.bugreport.BugReportSender;
import org.openstreetmap.josm.tools.bugreport.BugReportSettingsPanel;
import org.openstreetmap.josm.tools.bugreport.DebugTextDisplay;
import org.openstreetmap.josm.tools.bugreport.JosmUpdatePanel;
import org.openstreetmap.josm.tools.bugreport.ReportedException;

public class BugReportDialog
extends JDialog {
    private static final int MAX_MESSAGE_SIZE = 500;
    private final JPanel content = new JPanel(new GridBagLayout());
    private final BugReport report;
    private final DebugTextDisplay textPanel;
    private JCheckBox cbSuppressSingle;
    private JCheckBox cbSuppressAll;

    public BugReportDialog(BugReport bugReport) {
        super(BugReportDialog.findParent(), I18n.tr("You have encountered a bug in JOSM", new Object[0]));
        this.report = bugReport;
        this.textPanel = new DebugTextDisplay(bugReport);
        this.setContentPane(this.content);
        this.addMessageSection();
        this.addUpToDateSection();
        this.addCreateTicketSection();
        if (ExpertToggleAction.isExpert()) {
            this.addDebugTextSection();
        }
        this.addIgnoreButton();
        this.pack();
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        InputMapUtils.addEscapeAction(this.getRootPane(), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BugReportDialog.this.closeDialog();
            }
        });
    }

    private void addMessageSection() {
        String string = I18n.tr("An unexpected exception occurred.\nThis is always a coding error. If you are running the latest version of JOSM, please consider being kind and file a bug report.", new Object[0]);
        Icon icon = UIManager.getIcon("OptionPane.errorIcon");
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(icon), GBC.std().insets(0, 0, 10, 0));
        JMultilineLabel jMultilineLabel = new JMultilineLabel(string);
        jMultilineLabel.setMaxWidth(500);
        jPanel.add((Component)jMultilineLabel, GBC.eol().fill());
        this.content.add((Component)jPanel, GBC.eop().fill(2).insets(20));
    }

    private void addDebugTextSection() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        BugReportDialog.addBorder(jPanel, I18n.tr("Debug information", new Object[0]));
        jPanel.add((Component)this.textPanel, GBC.eop().fill());
        jPanel.add((Component)new JLabel(I18n.tr("Manually report at:", new Object[0])), GBC.std());
        jPanel.add((Component)new UrlLabel(Main.getJOSMWebsite() + "/newticket"), GBC.std().fill(2));
        JButton jButton = new JButton("Copy to clipboard");
        jButton.addActionListener(actionEvent -> this.textPanel.copyToClippboard());
        jPanel.add((Component)jButton, GBC.eol().anchor(13));
        this.content.add((Component)jPanel, GBC.eop().fill());
    }

    private void addUpToDateSection() {
        JosmUpdatePanel josmUpdatePanel = new JosmUpdatePanel();
        BugReportDialog.addBorder(josmUpdatePanel, I18n.tr("Is JOSM up to date?", new Object[0]));
        this.content.add((Component)josmUpdatePanel, GBC.eop().fill(2));
    }

    private void addCreateTicketSection() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        BugReportDialog.addBorder(jPanel, I18n.tr("Send bug report", new Object[0]));
        JMultilineLabel jMultilineLabel = new JMultilineLabel(I18n.tr("If you are running the latest version of JOSM and the plugins, please file a bug report in our bugtracker.\nThere the error information should already be filled in for you. Please include information on how to reproduce the error and try to supply as much detail as possible.", new Object[0]));
        jMultilineLabel.setMaxWidth(500);
        jPanel.add((Component)jMultilineLabel, GBC.eop().fill(2));
        if (ExpertToggleAction.isExpert()) {
            jPanel.add((Component)new BugReportSettingsPanel(this.report), GBC.eop().fill(2));
        }
        JButton jButton = new JButton(I18n.tr("Report Bug", new Object[0]), ImageProvider.get("bug"));
        jButton.addActionListener(actionEvent -> this.sendBug());
        jPanel.add((Component)jButton, GBC.eop().anchor(13));
        this.content.add((Component)jPanel, GBC.eop().fill(2));
    }

    private static void addBorder(JPanel jPanel, String string) {
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(string), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
    }

    private void addIgnoreButton() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.cbSuppressSingle = new JCheckBox(I18n.tr("Suppress this error for this session.", new Object[0]));
        this.cbSuppressSingle.setVisible(false);
        jPanel.add((Component)this.cbSuppressSingle, GBC.std(0, 0).fill(2));
        this.cbSuppressAll = new JCheckBox(I18n.tr("Suppress further error dialogs for this session.", new Object[0]));
        this.cbSuppressAll.setVisible(false);
        jPanel.add((Component)this.cbSuppressAll, GBC.std(0, 1).fill(2));
        JButton jButton = new JButton(I18n.tr("Ignore this error.", new Object[0]));
        jButton.addActionListener(actionEvent -> this.closeDialog());
        jPanel.add((Component)jButton, GBC.std(1, 0).span(1, 2).anchor(10));
        this.content.add((Component)jPanel, GBC.eol().fill(2).insets(20));
    }

    public void setShowSuppress(boolean bl) {
        this.cbSuppressSingle.setVisible(bl);
        this.pack();
    }

    public void setShowSuppressAll(boolean bl) {
        this.cbSuppressAll.setVisible(bl);
        this.pack();
    }

    public BugReportQueue.SuppressionMode shouldSuppressFurtherErrors() {
        if (this.cbSuppressAll.isSelected()) {
            return BugReportQueue.SuppressionMode.ALL;
        }
        if (this.cbSuppressSingle.isSelected()) {
            return BugReportQueue.SuppressionMode.SAME;
        }
        return BugReportQueue.SuppressionMode.NONE;
    }

    private void closeDialog() {
        this.setVisible(false);
    }

    private void sendBug() {
        BugReportSender.reportBug(this.textPanel.getCodeText());
    }

    private static Frame findParent() {
        Component component = Main.parent;
        try {
            for (int n = 0; n < 20 && component != null; component = component.getParent(), ++n) {
                if (!(component instanceof Frame)) continue;
                return (Frame)component;
            }
        }
        catch (RuntimeException runtimeException) {
            BugReport.intercept(runtimeException).put("current", component).warn();
        }
        return null;
    }

    public static BugReportQueue.SuppressionMode showFor(ReportedException reportedException, int n) {
        if (reportedException.isOutOfMemory()) {
            JOptionPane.showMessageDialog(Main.parent, "JOSM is out of memory. Strange things may happen.\nPlease restart JOSM with the -Xmx###M option,\nwhere ### is the number of MB assigned to JOSM (e.g. 256).\nCurrently, " + Runtime.getRuntime().maxMemory() / 1024L / 1024L + " MB are available to JOSM.", "Error", 0);
            return BugReportQueue.SuppressionMode.NONE;
        }
        return GuiHelper.runInEDTAndWaitAndReturn(() -> {
            PluginDownloadTask pluginDownloadTask = PluginHandler.updateOrdisablePluginAfterException(reportedException);
            if (pluginDownloadTask != null) {
                PluginPreference.notifyDownloadResults(Main.parent, pluginDownloadTask, !pluginDownloadTask.getDownloadedPlugins().isEmpty());
                return BugReportQueue.SuppressionMode.NONE;
            }
            BugReport bugReport = new BugReport(reportedException);
            BugReportDialog bugReportDialog = new BugReportDialog(bugReport);
            bugReportDialog.setShowSuppress(n > 0);
            bugReportDialog.setShowSuppressAll(n > 1);
            bugReportDialog.setVisible(true);
            return bugReportDialog.shouldSuppressFurtherErrors();
        });
    }
}

