/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyLanguage;
import org.jruby.truffle.core.format.BytesResult;
import org.jruby.truffle.core.format.FormatEncoding;
import org.jruby.truffle.core.format.FormatFrameDescriptor;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.language.backtrace.InternalRootNode;

public class FormatRootNode
extends RootNode
implements InternalRootNode {
    private final String description;
    private final FormatEncoding encoding;
    @Node.Child
    private FormatNode child;
    @CompilerDirectives.CompilationFinal
    private int expectedLength = 0;

    public FormatRootNode(String description, FormatEncoding encoding, FormatNode child) {
        super(RubyLanguage.class, SourceSection.createUnavailable("pack", description), FormatFrameDescriptor.FRAME_DESCRIPTOR);
        this.description = description;
        this.encoding = encoding;
        this.child = child;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        CodeRange stringCodeRange;
        int stringLength;
        boolean taint;
        byte[] output;
        int outputLength;
        frame.setObject(FormatFrameDescriptor.SOURCE_SLOT, frame.getArguments()[0]);
        frame.setInt(FormatFrameDescriptor.SOURCE_LENGTH_SLOT, (Integer)frame.getArguments()[1]);
        frame.setInt(FormatFrameDescriptor.SOURCE_POSITION_SLOT, 0);
        frame.setObject(FormatFrameDescriptor.OUTPUT_SLOT, new byte[this.expectedLength]);
        frame.setInt(FormatFrameDescriptor.OUTPUT_POSITION_SLOT, 0);
        frame.setInt(FormatFrameDescriptor.STRING_LENGTH_SLOT, 0);
        frame.setInt(FormatFrameDescriptor.STRING_CODE_RANGE_SLOT, 0);
        frame.setBoolean(FormatFrameDescriptor.TAINT_SLOT, false);
        this.child.execute(frame);
        try {
            outputLength = frame.getInt(FormatFrameDescriptor.OUTPUT_POSITION_SLOT);
        }
        catch (FrameSlotTypeException e) {
            throw new IllegalStateException(e);
        }
        if (outputLength > this.expectedLength) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.expectedLength = outputLength;
        }
        try {
            output = (byte[])frame.getObject(FormatFrameDescriptor.OUTPUT_SLOT);
        }
        catch (FrameSlotTypeException e) {
            throw new IllegalStateException(e);
        }
        try {
            taint = frame.getBoolean(FormatFrameDescriptor.TAINT_SLOT);
        }
        catch (FrameSlotTypeException e) {
            throw new IllegalStateException(e);
        }
        if (this.encoding == FormatEncoding.UTF_8) {
            try {
                stringLength = frame.getInt(FormatFrameDescriptor.STRING_LENGTH_SLOT);
            }
            catch (FrameSlotTypeException e) {
                throw new IllegalStateException(e);
            }
        } else {
            stringLength = outputLength;
        }
        try {
            stringCodeRange = CodeRange.fromInt(frame.getInt(FormatFrameDescriptor.STRING_CODE_RANGE_SLOT));
        }
        catch (FrameSlotTypeException e) {
            throw new IllegalStateException(e);
        }
        return new BytesResult(output, outputLength, stringLength, stringCodeRange, taint, this.encoding);
    }

    @Override
    public boolean isCloningAllowed() {
        return true;
    }

    @Override
    public String toString() {
        return this.description;
    }
}

