/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util.rewriters;

import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBreak;
import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsExpressionStatement;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import com.google.dart.compiler.backend.js.ast.JsReturn;
import com.google.dart.compiler.backend.js.ast.JsVisitorWithContextImpl;
import com.google.dart.compiler.backend.js.ast.metadata.MetadataProperties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0002J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u00142\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/js/inline/util/rewriters/ReturnReplacingVisitor;", "Lcom/google/dart/compiler/backend/js/ast/JsVisitorWithContextImpl;", "resultRef", "Lcom/google/dart/compiler/backend/js/ast/JsNameRef;", "breakLabel", "function", "Lcom/google/dart/compiler/backend/js/ast/JsFunction;", "(Lcom/google/dart/compiler/backend/js/ast/JsNameRef;Lcom/google/dart/compiler/backend/js/ast/JsNameRef;Lcom/google/dart/compiler/backend/js/ast/JsFunction;)V", "endVisit", "", "x", "Lcom/google/dart/compiler/backend/js/ast/JsReturn;", "ctx", "Lcom/google/dart/compiler/backend/js/ast/JsContext;", "Lcom/google/dart/compiler/backend/js/ast/JsNode;", "getReturnReplacement", "Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "returnExpression", "visit", "", "Lcom/google/dart/compiler/backend/js/ast/JsObjectLiteral;", "kotlin-compiler"})
public final class ReturnReplacingVisitor
extends JsVisitorWithContextImpl {
    private final JsNameRef resultRef;
    private final JsNameRef breakLabel;
    private final JsFunction function;

    public boolean visit(@NotNull JsObjectLiteral x, @NotNull JsContext<JsNode> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        return false;
    }

    public boolean visit(@NotNull JsFunction x, @NotNull JsContext<JsNode> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        return false;
    }

    public void endVisit(@NotNull JsReturn x, @NotNull JsContext<JsNode> ctx) {
        Intrinsics.checkParameterIsNotNull(x, "x");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        if (MetadataProperties.getReturnTarget(x) != null && Intrinsics.areEqual(MetadataProperties.getFunctionDescriptor(this.function), MetadataProperties.getReturnTarget(x)) ^ true) {
            return;
        }
        ctx.removeMe();
        JsExpression returnReplacement = this.getReturnReplacement(x.getExpression());
        if (returnReplacement != null) {
            JsExpressionStatement jsExpressionStatement = new JsExpressionStatement(returnReplacement);
            JsContext<JsNode> jsContext = ctx;
            JsExpressionStatement $receiver = jsExpressionStatement;
            MetadataProperties.setSynthetic($receiver, true);
            JsExpressionStatement jsExpressionStatement2 = jsExpressionStatement;
            jsContext.addNext((JsNode)jsExpressionStatement2);
        }
        if (this.breakLabel != null) {
            ctx.addNext((JsNode)new JsBreak(this.breakLabel));
        }
    }

    private final JsExpression getReturnReplacement(JsExpression returnExpression) {
        JsExpression jsExpression;
        if (returnExpression != null) {
            JsBinaryOperation assignment;
            JsBinaryOperation jsBinaryOperation;
            JsNameRef jsNameRef = this.resultRef;
            if (jsNameRef != null) {
                JsNameRef jsNameRef2 = jsNameRef;
                JsNameRef it = jsNameRef2;
                JsBinaryOperation jsBinaryOperation2 = JsAstUtils.assignment(this.resultRef, returnExpression);
                JsBinaryOperation $receiver = jsBinaryOperation2;
                MetadataProperties.setSynthetic($receiver, true);
                jsBinaryOperation = jsBinaryOperation2;
            } else {
                jsBinaryOperation = null;
            }
            JsBinaryOperation jsBinaryOperation3 = assignment = jsBinaryOperation;
            jsExpression = jsBinaryOperation3 != null ? (JsExpression)jsBinaryOperation3 : returnExpression;
        } else {
            jsExpression = null;
        }
        return jsExpression;
    }

    public ReturnReplacingVisitor(@Nullable JsNameRef resultRef, @Nullable JsNameRef breakLabel, @NotNull JsFunction function) {
        Intrinsics.checkParameterIsNotNull(function, "function");
        this.resultRef = resultRef;
        this.breakLabel = breakLabel;
        this.function = function;
    }
}

