/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeatureSettings;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u001b\b\u0016\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B-\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "", "c", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "languageFeatureSettings", "Lorg/jetbrains/kotlin/config/LanguageFeatureSettings;", "(Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;Lorg/jetbrains/kotlin/config/LanguageFeatureSettings;)V", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "isAnnotationContext", "", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/config/LanguageFeatureSettings;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;Z)V", "getDataFlowInfo", "()Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "()Z", "getLanguageFeatureSettings", "()Lorg/jetbrains/kotlin/config/LanguageFeatureSettings;", "getScope", "()Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "getTrace", "()Lorg/jetbrains/kotlin/resolve/BindingTrace;", "kotlin-compiler"})
public final class CallCheckerContext {
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final LexicalScope scope;
    @NotNull
    private final LanguageFeatureSettings languageFeatureSettings;
    @NotNull
    private final DataFlowInfo dataFlowInfo;
    private final boolean isAnnotationContext;

    @NotNull
    public final BindingTrace getTrace() {
        return this.trace;
    }

    @NotNull
    public final LexicalScope getScope() {
        return this.scope;
    }

    @NotNull
    public final LanguageFeatureSettings getLanguageFeatureSettings() {
        return this.languageFeatureSettings;
    }

    @NotNull
    public final DataFlowInfo getDataFlowInfo() {
        return this.dataFlowInfo;
    }

    public final boolean isAnnotationContext() {
        return this.isAnnotationContext;
    }

    public CallCheckerContext(@NotNull BindingTrace trace, @NotNull LexicalScope scope, @NotNull LanguageFeatureSettings languageFeatureSettings, @NotNull DataFlowInfo dataFlowInfo, boolean isAnnotationContext) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Intrinsics.checkParameterIsNotNull(languageFeatureSettings, "languageFeatureSettings");
        Intrinsics.checkParameterIsNotNull(dataFlowInfo, "dataFlowInfo");
        this.trace = trace;
        this.scope = scope;
        this.languageFeatureSettings = languageFeatureSettings;
        this.dataFlowInfo = dataFlowInfo;
        this.isAnnotationContext = isAnnotationContext;
    }

    public CallCheckerContext(@NotNull ResolutionContext<?> c, @NotNull LanguageFeatureSettings languageFeatureSettings) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        Intrinsics.checkParameterIsNotNull(languageFeatureSettings, "languageFeatureSettings");
        BindingTrace bindingTrace = c.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "c.trace");
        LexicalScope lexicalScope = c.scope;
        Intrinsics.checkExpressionValueIsNotNull(lexicalScope, "c.scope");
        DataFlowInfo dataFlowInfo = c.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "c.dataFlowInfo");
        this(bindingTrace, lexicalScope, languageFeatureSettings, dataFlowInfo, c.isAnnotationContext);
    }
}

