/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ElementValue;

public class ElementValuesEditor {
    private final ProgramClass targetClass;
    private final Annotation targetAnnotation;
    private final ArrayElementValue targetArrayElementValue;
    private final boolean replaceElementValues;

    public ElementValuesEditor(ProgramClass programClass, Annotation annotation, boolean bl) {
        this.targetClass = programClass;
        this.targetAnnotation = annotation;
        this.targetArrayElementValue = null;
        this.replaceElementValues = bl;
    }

    public ElementValuesEditor(ProgramClass programClass, ArrayElementValue arrayElementValue, boolean bl) {
        this.targetClass = programClass;
        this.targetAnnotation = null;
        this.targetArrayElementValue = arrayElementValue;
        this.replaceElementValues = bl;
    }

    public void addElementValue(ElementValue elementValue) {
        if (this.targetAnnotation != null) {
            if (!this.replaceElementValues || !this.replaceElementValue(this.targetAnnotation.u2elementValuesCount, this.targetAnnotation.elementValues, elementValue)) {
                this.targetAnnotation.elementValues = this.addElementValue(this.targetAnnotation.u2elementValuesCount, this.targetAnnotation.elementValues, elementValue);
                ++this.targetAnnotation.u2elementValuesCount;
            }
        } else if (!this.replaceElementValues || !this.replaceElementValue(this.targetArrayElementValue.u2elementValuesCount, this.targetArrayElementValue.elementValues, elementValue)) {
            this.targetArrayElementValue.elementValues = this.addElementValue(this.targetArrayElementValue.u2elementValuesCount, this.targetArrayElementValue.elementValues, elementValue);
            ++this.targetArrayElementValue.u2elementValuesCount;
        }
    }

    public void deleteElementValue(String string) {
        if (this.targetAnnotation != null) {
            this.targetAnnotation.u2elementValuesCount = this.deleteElementValue(this.targetAnnotation.u2elementValuesCount, this.targetAnnotation.elementValues, string);
        } else {
            this.targetArrayElementValue.u2elementValuesCount = this.deleteElementValue(this.targetArrayElementValue.u2elementValuesCount, this.targetArrayElementValue.elementValues, string);
        }
    }

    private boolean replaceElementValue(int n, ElementValue[] elementValueArray, ElementValue elementValue) {
        int n2 = this.findElementValue(n, elementValueArray, elementValue.getMethodName(this.targetClass));
        if (n2 < 0) {
            return false;
        }
        elementValueArray[n2] = elementValue;
        return true;
    }

    private ElementValue[] addElementValue(int n, ElementValue[] elementValueArray, ElementValue elementValue) {
        if (elementValueArray.length <= n) {
            ElementValue[] elementValueArray2 = new ElementValue[n + 1];
            System.arraycopy(elementValueArray, 0, elementValueArray2, 0, n);
            elementValueArray = elementValueArray2;
        }
        elementValueArray[n] = elementValue;
        return elementValueArray;
    }

    private int deleteElementValue(int n, ElementValue[] elementValueArray, String string) {
        int n2 = this.findElementValue(n, elementValueArray, string);
        if (n2 < 0) {
            return n;
        }
        System.arraycopy(elementValueArray, n2 + 1, elementValueArray, n2, n - n2 - 1);
        elementValueArray[--n] = null;
        return n;
    }

    private int findElementValue(int n, ElementValue[] elementValueArray, String string) {
        for (int i = 0; i < n; ++i) {
            if (!elementValueArray[i].getMethodName(this.targetClass).equals(string)) continue;
            return i;
        }
        return -1;
    }
}

