/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.DimensionLine;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.TextStyle;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.FurnitureTable;
import com.eteks.sweethome3d.swing.PlanComponent;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.PlanController;
import com.eteks.sweethome3d.viewcontroller.PlanView;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleLevelsPlanPanel
extends JPanel
implements PlanView,
Printable {
    private static final String ONE_LEVEL_PANEL_NAME = "oneLevelPanel";
    private static final String MULTIPLE_LEVELS_PANEL_NAME = "multipleLevelsPanel";
    private static final ImageIcon sameElevationIcon = SwingTools.getScaledImageIcon(FurnitureTable.class.getResource("resources/sameElevation.png"));
    private PlanComponent planComponent;
    private JScrollPane planScrollPane;
    private JTabbedPane multipleLevelsTabbedPane;
    private JPanel oneLevelPanel;

    public MultipleLevelsPlanPanel(Home home, UserPreferences userPreferences, PlanController planController) {
        super(new CardLayout());
        this.createComponents(home, userPreferences, planController);
        this.layoutComponents();
        this.updateSelectedTab(home);
    }

    private void createComponents(final Home home, final UserPreferences userPreferences, final PlanController planController) {
        this.planComponent = this.createPlanComponent(home, userPreferences, planController);
        UIManager.getDefaults().put("TabbedPane.contentBorderInsets", OperatingSystem.isMacOSX() ? new Insets(2, 2, 2, 2) : new Insets(-1, 0, 2, 2));
        this.multipleLevelsTabbedPane = new JTabbedPane();
        if (OperatingSystem.isMacOSX()) {
            this.multipleLevelsTabbedPane.setBorder(new EmptyBorder(-2, -6, -7, -6));
        }
        List<Level> list = home.getLevels();
        this.planScrollPane = new JScrollPane(this.planComponent);
        this.planScrollPane.setMinimumSize(new Dimension());
        if (OperatingSystem.isMacOSX()) {
            this.planScrollPane.setHorizontalScrollBarPolicy(32);
            this.planScrollPane.setVerticalScrollBarPolicy(22);
        }
        this.createTabs(home, userPreferences);
        final ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Component component = MultipleLevelsPlanPanel.this.multipleLevelsTabbedPane.getSelectedComponent();
                if (component instanceof LevelLabel) {
                    planController.setSelectedLevel(((LevelLabel)component).getLevel());
                }
            }
        };
        this.multipleLevelsTabbedPane.addChangeListener(changeListener);
        this.multipleLevelsTabbedPane.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = MultipleLevelsPlanPanel.this.multipleLevelsTabbedPane.indexAtLocation(mouseEvent.getX(), mouseEvent.getY());
                if (mouseEvent.getClickCount() == 1) {
                    if (n == MultipleLevelsPlanPanel.this.multipleLevelsTabbedPane.getTabCount() - 1) {
                        planController.addLevel();
                    }
                    final Level level = home.getSelectedLevel();
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            if (level == home.getSelectedLevel()) {
                                MultipleLevelsPlanPanel.this.planComponent.requestFocusInWindow();
                            }
                        }
                    });
                } else if (n != -1) {
                    if (MultipleLevelsPlanPanel.this.multipleLevelsTabbedPane.getSelectedIndex() == MultipleLevelsPlanPanel.this.multipleLevelsTabbedPane.getTabCount() - 1) {
                        MultipleLevelsPlanPanel.this.multipleLevelsTabbedPane.setSelectedIndex(MultipleLevelsPlanPanel.this.multipleLevelsTabbedPane.getTabCount() - 2);
                    }
                    planController.modifySelectedLevel();
                }
            }
        });
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (Level.Property.NAME.name().equals(propertyChangeEvent.getPropertyName())) {
                    int n = home.getLevels().indexOf(propertyChangeEvent.getSource());
                    MultipleLevelsPlanPanel.this.multipleLevelsTabbedPane.setTitleAt(n, (String)propertyChangeEvent.getNewValue());
                    MultipleLevelsPlanPanel.this.updateTabComponent(home, n);
                } else if (Level.Property.VIEWABLE.name().equals(propertyChangeEvent.getPropertyName())) {
                    MultipleLevelsPlanPanel.this.updateTabComponent(home, home.getLevels().indexOf(propertyChangeEvent.getSource()));
                } else if (Level.Property.ELEVATION.name().equals(propertyChangeEvent.getPropertyName()) || Level.Property.ELEVATION_INDEX.name().equals(propertyChangeEvent.getPropertyName())) {
                    MultipleLevelsPlanPanel.this.multipleLevelsTabbedPane.removeChangeListener(changeListener);
                    MultipleLevelsPlanPanel.this.multipleLevelsTabbedPane.removeAll();
                    MultipleLevelsPlanPanel.this.createTabs(home, userPreferences);
                    MultipleLevelsPlanPanel.this.updateSelectedTab(home);
                    MultipleLevelsPlanPanel.this.multipleLevelsTabbedPane.addChangeListener(changeListener);
                }
            }
        };
        for (Level level : list) {
            level.addPropertyChangeListener(propertyChangeListener);
        }
        home.addLevelsListener(new CollectionListener<Level>(){

            @Override
            public void collectionChanged(CollectionEvent<Level> collectionEvent) {
                MultipleLevelsPlanPanel.this.multipleLevelsTabbedPane.removeChangeListener(changeListener);
                switch (collectionEvent.getType()) {
                    case ADD: {
                        MultipleLevelsPlanPanel.this.multipleLevelsTabbedPane.insertTab(collectionEvent.getItem().getName(), null, new LevelLabel(collectionEvent.getItem()), null, collectionEvent.getIndex());
                        MultipleLevelsPlanPanel.this.updateTabComponent(home, collectionEvent.getIndex());
                        collectionEvent.getItem().addPropertyChangeListener(propertyChangeListener);
                        break;
                    }
                    case DELETE: {
                        collectionEvent.getItem().removePropertyChangeListener(propertyChangeListener);
                        MultipleLevelsPlanPanel.this.multipleLevelsTabbedPane.remove(collectionEvent.getIndex());
                    }
                }
                MultipleLevelsPlanPanel.this.updateLayout(home);
                MultipleLevelsPlanPanel.this.multipleLevelsTabbedPane.addChangeListener(changeListener);
            }
        });
        home.addPropertyChangeListener(Home.Property.SELECTED_LEVEL, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                MultipleLevelsPlanPanel.this.multipleLevelsTabbedPane.removeChangeListener(changeListener);
                MultipleLevelsPlanPanel.this.updateSelectedTab(home);
                MultipleLevelsPlanPanel.this.multipleLevelsTabbedPane.addChangeListener(changeListener);
            }
        });
        this.oneLevelPanel = new JPanel(new BorderLayout());
        if (OperatingSystem.isJavaVersionGreaterOrEqual("1.6")) {
            home.addPropertyChangeListener(Home.Property.ALL_LEVELS_SELECTION, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    MultipleLevelsPlanPanel.this.multipleLevelsTabbedPane.repaint();
                }
            });
        }
        userPreferences.addPropertyChangeListener(UserPreferences.Property.LANGUAGE, new LanguageChangeListener(this));
    }

    protected PlanComponent createPlanComponent(Home home, UserPreferences userPreferences, PlanController planController) {
        return new PlanComponent(home, userPreferences, planController);
    }

    private void updateTabComponent(final Home home, int n) {
        if (OperatingSystem.isJavaVersionGreaterOrEqual("1.6")) {
            JLabel jLabel = new JLabel(this.multipleLevelsTabbedPane.getTitleAt(n)){

                protected void paintComponent(Graphics graphics) {
                    if (home.isAllLevelsSelection() && this.isEnabled()) {
                        Graphics2D graphics2D = (Graphics2D)graphics;
                        graphics2D.setPaint(MultipleLevelsPlanPanel.this.planComponent.getSelectionColor());
                        Composite composite = graphics2D.getComposite();
                        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
                        Font font = this.getFont();
                        FontMetrics fontMetrics = this.getFontMetrics(font);
                        float f = (float)fontMetrics.getHeight() * 0.125f;
                        graphics2D.setStroke(new BasicStroke(f));
                        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
                        TextLayout textLayout = new TextLayout(this.getText(), font, fontRenderContext);
                        AffineTransform affineTransform = graphics2D.getTransform();
                        if (this.getIcon() != null) {
                            graphics2D.translate(this.getIcon().getIconWidth() + this.getIconTextGap(), 0);
                        }
                        graphics2D.draw(textLayout.getOutline(AffineTransform.getTranslateInstance(-f / 5.0f, (float)((this.getHeight() - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent()) - f / 5.0f)));
                        graphics2D.setComposite(composite);
                        graphics2D.setTransform(affineTransform);
                    }
                    super.paintComponent(graphics);
                }
            };
            List<Level> list = home.getLevels();
            jLabel.setEnabled(list.get(n).isViewable());
            if (n > 0 && list.get(n - 1).getElevation() == list.get(n).getElevation()) {
                jLabel.setIcon(sameElevationIcon);
            }
            try {
                this.multipleLevelsTabbedPane.getClass().getMethod("setTabComponentAt", Integer.TYPE, Component.class).invoke((Object)this.multipleLevelsTabbedPane, n, jLabel);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalAccessError(illegalAccessException.getMessage());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new NoSuchMethodError(noSuchMethodException.getMessage());
            }
        }
    }

    private void createTabs(Home home, UserPreferences userPreferences) {
        Object object;
        List<Level> list = home.getLevels();
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            this.multipleLevelsTabbedPane.addTab(((Level)object).getName(), new LevelLabel((Level)object));
            this.updateTabComponent(home, i);
        }
        String string = userPreferences.getLocalizedString(MultipleLevelsPlanPanel.class, "ADD_LEVEL.SmallIcon", new Object[0]);
        object = userPreferences.getLocalizedString(MultipleLevelsPlanPanel.class, "ADD_LEVEL.ShortDescription", new Object[0]);
        ImageIcon imageIcon = SwingTools.getScaledImageIcon(MultipleLevelsPlanPanel.class.getResource(string));
        this.multipleLevelsTabbedPane.addTab("", imageIcon, new JLabel(), (String)object);
        this.multipleLevelsTabbedPane.setEnabledAt(this.multipleLevelsTabbedPane.getTabCount() - 1, false);
        this.multipleLevelsTabbedPane.setDisabledIconAt(this.multipleLevelsTabbedPane.getTabCount() - 1, imageIcon);
    }

    private void updateSelectedTab(Home home) {
        List<Level> list = home.getLevels();
        Level level = home.getSelectedLevel();
        if (list.size() >= 2 && level != null) {
            this.multipleLevelsTabbedPane.setSelectedIndex(list.indexOf(level));
            this.displayPlanComponentAtSelectedIndex(home);
        }
        this.updateLayout(home);
    }

    private void displayPlanComponentAtSelectedIndex(Home home) {
        int n = this.multipleLevelsTabbedPane.indexOfComponent(this.planScrollPane);
        if (n != -1) {
            this.multipleLevelsTabbedPane.setComponentAt(n, new LevelLabel(home.getLevels().get(n)));
        }
        this.multipleLevelsTabbedPane.setComponentAt(this.multipleLevelsTabbedPane.getSelectedIndex(), this.planScrollPane);
    }

    private void updateLayout(Home home) {
        CardLayout cardLayout = (CardLayout)this.getLayout();
        List<Level> list = home.getLevels();
        boolean bl = this.planComponent.hasFocus();
        if (list.size() < 2 || home.getSelectedLevel() == null) {
            int n = this.multipleLevelsTabbedPane.indexOfComponent(this.planScrollPane);
            if (n != -1) {
                this.multipleLevelsTabbedPane.setComponentAt(n, new LevelLabel(home.getLevels().get(n)));
            }
            this.oneLevelPanel.add(this.planScrollPane);
            cardLayout.show(this, ONE_LEVEL_PANEL_NAME);
        } else {
            cardLayout.show(this, MULTIPLE_LEVELS_PANEL_NAME);
        }
        if (bl) {
            this.planComponent.requestFocusInWindow();
        }
    }

    private void layoutComponents() {
        this.add((Component)this.multipleLevelsTabbedPane, MULTIPLE_LEVELS_PANEL_NAME);
        this.add((Component)this.oneLevelPanel, ONE_LEVEL_PANEL_NAME);
        SwingTools.installFocusBorder(this.planComponent);
        this.setFocusTraversalPolicyProvider(false);
        this.setMinimumSize(new Dimension());
    }

    @Override
    public void setTransferHandler(TransferHandler transferHandler) {
        this.planComponent.setTransferHandler(transferHandler);
    }

    @Override
    public void setComponentPopupMenu(JPopupMenu jPopupMenu) {
        this.planComponent.setComponentPopupMenu(jPopupMenu);
    }

    @Override
    public void addMouseMotionListener(final MouseMotionListener mouseMotionListener) {
        this.planComponent.addMouseMotionListener(new MouseMotionListener(){

            public void mouseMoved(MouseEvent mouseEvent) {
                mouseMotionListener.mouseMoved(SwingUtilities.convertMouseEvent(MultipleLevelsPlanPanel.this.planComponent, mouseEvent, MultipleLevelsPlanPanel.this));
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                mouseMotionListener.mouseDragged(SwingUtilities.convertMouseEvent(MultipleLevelsPlanPanel.this.planComponent, mouseEvent, MultipleLevelsPlanPanel.this));
            }
        });
    }

    @Override
    public void addMouseListener(final MouseListener mouseListener) {
        this.planComponent.addMouseListener(new MouseListener(){

            public void mouseReleased(MouseEvent mouseEvent) {
                mouseListener.mouseReleased(SwingUtilities.convertMouseEvent(MultipleLevelsPlanPanel.this.planComponent, mouseEvent, MultipleLevelsPlanPanel.this));
            }

            public void mousePressed(MouseEvent mouseEvent) {
                mouseListener.mousePressed(SwingUtilities.convertMouseEvent(MultipleLevelsPlanPanel.this.planComponent, mouseEvent, MultipleLevelsPlanPanel.this));
            }

            public void mouseExited(MouseEvent mouseEvent) {
                mouseListener.mouseExited(SwingUtilities.convertMouseEvent(MultipleLevelsPlanPanel.this.planComponent, mouseEvent, MultipleLevelsPlanPanel.this));
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                mouseListener.mouseEntered(SwingUtilities.convertMouseEvent(MultipleLevelsPlanPanel.this.planComponent, mouseEvent, MultipleLevelsPlanPanel.this));
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                mouseListener.mouseClicked(SwingUtilities.convertMouseEvent(MultipleLevelsPlanPanel.this.planComponent, mouseEvent, MultipleLevelsPlanPanel.this));
            }
        });
    }

    @Override
    public void addFocusListener(final FocusListener focusListener) {
        FocusListener focusListener2 = new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                focusListener.focusGained(new FocusEvent(MultipleLevelsPlanPanel.this, 1004, focusEvent.isTemporary(), focusEvent.getOppositeComponent()));
            }

            public void focusLost(FocusEvent focusEvent) {
                focusListener.focusLost(new FocusEvent(MultipleLevelsPlanPanel.this, 1005, focusEvent.isTemporary(), focusEvent.getOppositeComponent()));
            }
        };
        this.planComponent.addFocusListener(focusListener2);
        this.multipleLevelsTabbedPane.addFocusListener(focusListener2);
    }

    @Override
    public void setRectangleFeedback(float f, float f2, float f3, float f4) {
        this.planComponent.setRectangleFeedback(f, f2, f3, f4);
    }

    @Override
    public void makeSelectionVisible() {
        this.planComponent.makeSelectionVisible();
    }

    @Override
    public void makePointVisible(float f, float f2) {
        this.planComponent.makePointVisible(f, f2);
    }

    @Override
    public float getScale() {
        return this.planComponent.getScale();
    }

    @Override
    public void setScale(float f) {
        this.planComponent.setScale(f);
    }

    @Override
    public void moveView(float f, float f2) {
        this.planComponent.moveView(f, f2);
    }

    @Override
    public float convertXPixelToModel(int n) {
        return this.planComponent.convertXPixelToModel(SwingUtilities.convertPoint((Component)this, (int)n, (int)0, (Component)this.planComponent).x);
    }

    @Override
    public float convertYPixelToModel(int n) {
        return this.planComponent.convertYPixelToModel(SwingUtilities.convertPoint((Component)this, (int)0, (int)n, (Component)this.planComponent).y);
    }

    @Override
    public int convertXModelToScreen(float f) {
        return this.planComponent.convertXModelToScreen(f);
    }

    @Override
    public int convertYModelToScreen(float f) {
        return this.planComponent.convertYModelToScreen(f);
    }

    @Override
    public float getPixelLength() {
        return this.planComponent.getPixelLength();
    }

    @Override
    public float[][] getTextBounds(String string, TextStyle textStyle, float f, float f2, float f3) {
        return this.planComponent.getTextBounds(string, textStyle, f, f2, f3);
    }

    @Override
    public void setCursor(PlanView.CursorType cursorType) {
        this.planComponent.setCursor(cursorType);
    }

    @Override
    public void setCursor(Cursor cursor) {
        this.planComponent.setCursor(cursor);
    }

    @Override
    public Cursor getCursor() {
        return this.planComponent.getCursor();
    }

    @Override
    public void setToolTipFeedback(String string, float f, float f2) {
        this.planComponent.setToolTipFeedback(string, f, f2);
    }

    @Override
    public void setToolTipEditedProperties(PlanController.EditableProperty[] editablePropertyArray, Object[] objectArray, float f, float f2) {
        this.planComponent.setToolTipEditedProperties(editablePropertyArray, objectArray, f, f2);
    }

    @Override
    public void deleteToolTipFeedback() {
        this.planComponent.deleteToolTipFeedback();
    }

    @Override
    public void setResizeIndicatorVisible(boolean bl) {
        this.planComponent.setResizeIndicatorVisible(bl);
    }

    @Override
    public void setAlignmentFeedback(Class<? extends Selectable> clazz, Selectable selectable, float f, float f2, boolean bl) {
        this.planComponent.setAlignmentFeedback(clazz, selectable, f, f2, bl);
    }

    @Override
    public void setAngleFeedback(float f, float f2, float f3, float f4, float f5, float f6) {
        this.planComponent.setAngleFeedback(f, f2, f3, f4, f5, f6);
    }

    @Override
    public void setDraggedItemsFeedback(List<Selectable> list) {
        this.planComponent.setDraggedItemsFeedback(list);
    }

    @Override
    public void setDimensionLinesFeedback(List<DimensionLine> list) {
        this.planComponent.setDimensionLinesFeedback(list);
    }

    @Override
    public void deleteFeedback() {
        this.planComponent.deleteFeedback();
    }

    @Override
    public boolean canImportDraggedItems(List<Selectable> list, int n, int n2) {
        JViewport jViewport = this.planScrollPane.getViewport();
        Point point = SwingUtilities.convertPoint(this, n, n2, jViewport);
        return jViewport.contains(point);
    }

    @Override
    public View getHorizontalRuler() {
        return this.planComponent.getHorizontalRuler();
    }

    @Override
    public View getVerticalRuler() {
        return this.planComponent.getVerticalRuler();
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        return this.planComponent.print(graphics, pageFormat, n);
    }

    public float getPrintPreferredScale(Graphics graphics, PageFormat pageFormat) {
        return this.planComponent.getPrintPreferredScale(graphics, pageFormat);
    }

    private static class LevelLabel
    extends JLabel {
        private final Level level;

        public LevelLabel(Level level) {
            this.level = level;
        }

        public Level getLevel() {
            return this.level;
        }
    }

    private static class LanguageChangeListener
    implements PropertyChangeListener {
        private WeakReference<MultipleLevelsPlanPanel> planPanel;

        public LanguageChangeListener(MultipleLevelsPlanPanel multipleLevelsPlanPanel) {
            this.planPanel = new WeakReference<MultipleLevelsPlanPanel>(multipleLevelsPlanPanel);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            MultipleLevelsPlanPanel multipleLevelsPlanPanel = (MultipleLevelsPlanPanel)this.planPanel.get();
            UserPreferences userPreferences = (UserPreferences)propertyChangeEvent.getSource();
            if (multipleLevelsPlanPanel == null) {
                userPreferences.removePropertyChangeListener(UserPreferences.Property.LANGUAGE, this);
            } else {
                String string = userPreferences.getLocalizedString(MultipleLevelsPlanPanel.class, "ADD_LEVEL.ShortDescription", new Object[0]);
                multipleLevelsPlanPanel.multipleLevelsTabbedPane.setToolTipTextAt(multipleLevelsPlanPanel.multipleLevelsTabbedPane.getTabCount() - 1, string);
            }
        }
    }
}

