/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.AspectRatio;
import com.eteks.sweethome3d.model.BackgroundImage;
import com.eteks.sweethome3d.model.Camera;
import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.CatalogTexture;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.Compass;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.DamagedHomeRecorderException;
import com.eteks.sweethome3d.model.Elevatable;
import com.eteks.sweethome3d.model.FurnitureCatalog;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeApplication;
import com.eteks.sweethome3d.model.HomeDoorOrWindow;
import com.eteks.sweethome3d.model.HomeEnvironment;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomeMaterial;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.HomeRecorder;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.InterruptedRecorderException;
import com.eteks.sweethome3d.model.Label;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.Library;
import com.eteks.sweethome3d.model.NotEnoughSpaceRecorderException;
import com.eteks.sweethome3d.model.Polyline;
import com.eteks.sweethome3d.model.RecorderException;
import com.eteks.sweethome3d.model.Room;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.SelectionEvent;
import com.eteks.sweethome3d.model.SelectionListener;
import com.eteks.sweethome3d.model.TextStyle;
import com.eteks.sweethome3d.model.TextureImage;
import com.eteks.sweethome3d.model.TexturesCatalog;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.model.Wall;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.ResourceURLContent;
import com.eteks.sweethome3d.viewcontroller.BackgroundImageWizardController;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.FurnitureCatalogController;
import com.eteks.sweethome3d.viewcontroller.FurnitureController;
import com.eteks.sweethome3d.viewcontroller.HelpController;
import com.eteks.sweethome3d.viewcontroller.HomeController3D;
import com.eteks.sweethome3d.viewcontroller.HomeFurnitureController;
import com.eteks.sweethome3d.viewcontroller.HomeView;
import com.eteks.sweethome3d.viewcontroller.ImportedTextureWizardController;
import com.eteks.sweethome3d.viewcontroller.LabelController;
import com.eteks.sweethome3d.viewcontroller.PageSetupController;
import com.eteks.sweethome3d.viewcontroller.PhotoController;
import com.eteks.sweethome3d.viewcontroller.PhotosController;
import com.eteks.sweethome3d.viewcontroller.PlanController;
import com.eteks.sweethome3d.viewcontroller.PolylineController;
import com.eteks.sweethome3d.viewcontroller.PrintPreviewController;
import com.eteks.sweethome3d.viewcontroller.RoomController;
import com.eteks.sweethome3d.viewcontroller.ThreadedTaskController;
import com.eteks.sweethome3d.viewcontroller.ThreadedTaskView;
import com.eteks.sweethome3d.viewcontroller.UserPreferencesController;
import com.eteks.sweethome3d.viewcontroller.VideoController;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import com.eteks.sweethome3d.viewcontroller.ViewFactoryAdapter;
import com.eteks.sweethome3d.viewcontroller.WallController;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HomeController
implements Controller {
    private final Home home;
    private final UserPreferences preferences;
    private final HomeApplication application;
    private final ViewFactory viewFactory;
    private final ContentManager contentManager;
    private final UndoableEditSupport undoSupport;
    private final UndoManager undoManager;
    private HomeView homeView;
    private FurnitureCatalogController furnitureCatalogController;
    private FurnitureController furnitureController;
    private PlanController planController;
    private HomeController3D homeController3D;
    private static HelpController helpController;
    private int saveUndoLevel;
    private boolean notUndoableModifications;
    private View focusedView;
    private static final Content REPAIRED_IMAGE_CONTENT;
    private static final Content REPAIRED_ICON_CONTENT;
    private static final Content REPAIRED_MODEL_CONTENT;

    public HomeController(Home home, HomeApplication homeApplication, ViewFactory viewFactory, ContentManager contentManager) {
        this(home, homeApplication.getUserPreferences(), viewFactory, contentManager, homeApplication);
    }

    public HomeController(Home home, HomeApplication homeApplication, ViewFactory viewFactory) {
        this(home, homeApplication.getUserPreferences(), viewFactory, null, homeApplication);
    }

    public HomeController(Home home, UserPreferences userPreferences, ViewFactory viewFactory) {
        this(home, userPreferences, viewFactory, null, null);
    }

    public HomeController(Home home, UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager) {
        this(home, userPreferences, viewFactory, contentManager, null);
    }

    private HomeController(final Home home, final UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager, HomeApplication homeApplication) {
        this.home = home;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.contentManager = contentManager;
        this.application = homeApplication;
        this.undoSupport = new UndoableEditSupport(){

            protected void _postEdit(UndoableEdit undoableEdit) {
                if (!(undoableEdit instanceof CompoundEdit) || undoableEdit.isSignificant()) {
                    super._postEdit(undoableEdit);
                }
            }
        };
        this.undoManager = new UndoManager();
        this.undoSupport.addUndoableEditListener(this.undoManager);
        if (home.getName() != null) {
            ArrayList<String> arrayList = new ArrayList<String>(this.preferences.getRecentHomes());
            arrayList.remove(home.getName());
            arrayList.add(0, home.getName());
            this.updateUserPreferencesRecentHomes(arrayList);
            if (home.getVersion() > 5200L) {
                this.getView().invokeLater(new Runnable(){

                    public void run() {
                        String string = userPreferences.getLocalizedString(HomeController.class, "moreRecentVersionHome", home.getName());
                        HomeController.this.getView().showMessage(string);
                    }
                });
            }
        }
    }

    private void enableDefaultActions(HomeView homeView) {
        boolean bl = this.application != null;
        homeView.setEnabled(HomeView.ActionType.NEW_HOME, bl);
        homeView.setEnabled(HomeView.ActionType.OPEN, bl);
        homeView.setEnabled(HomeView.ActionType.DELETE_RECENT_HOMES, bl && !this.preferences.getRecentHomes().isEmpty());
        homeView.setEnabled(HomeView.ActionType.CLOSE, bl);
        homeView.setEnabled(HomeView.ActionType.SAVE, bl);
        homeView.setEnabled(HomeView.ActionType.SAVE_AS, bl);
        homeView.setEnabled(HomeView.ActionType.SAVE_AND_COMPRESS, bl);
        homeView.setEnabled(HomeView.ActionType.PAGE_SETUP, true);
        homeView.setEnabled(HomeView.ActionType.PRINT_PREVIEW, true);
        homeView.setEnabled(HomeView.ActionType.PRINT, true);
        homeView.setEnabled(HomeView.ActionType.PRINT_TO_PDF, true);
        homeView.setEnabled(HomeView.ActionType.PREFERENCES, true);
        homeView.setEnabled(HomeView.ActionType.EXIT, bl);
        homeView.setEnabled(HomeView.ActionType.IMPORT_FURNITURE, true);
        homeView.setEnabled(HomeView.ActionType.IMPORT_FURNITURE_LIBRARY, true);
        homeView.setEnabled(HomeView.ActionType.IMPORT_TEXTURE, true);
        homeView.setEnabled(HomeView.ActionType.IMPORT_TEXTURES_LIBRARY, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_CATALOG_ID, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_NAME, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_WIDTH, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_HEIGHT, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_DEPTH, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_X, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_Y, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_ELEVATION, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_ANGLE, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_LEVEL, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_COLOR, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_TEXTURE, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_MOVABILITY, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_TYPE, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_VISIBILITY, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_PRICE, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_VALUE_ADDED_TAX_PERCENTAGE, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_VALUE_ADDED_TAX, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_PRICE_VALUE_ADDED_TAX_INCLUDED, true);
        homeView.setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_DESCENDING_ORDER, this.home.getFurnitureSortedProperty() != null);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_CATALOG_ID, true);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_NAME, true);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_WIDTH, true);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_DEPTH, true);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_HEIGHT, true);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_X, true);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_Y, true);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_ELEVATION, true);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_ANGLE, true);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_LEVEL, true);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_COLOR, true);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_TEXTURE, true);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_MOVABLE, true);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_DOOR_OR_WINDOW, true);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_VISIBLE, true);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_PRICE, true);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_VALUE_ADDED_TAX_PERCENTAGE, true);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_VALUE_ADDED_TAX, true);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_HOME_FURNITURE_PRICE_VALUE_ADDED_TAX_INCLUDED, true);
        homeView.setEnabled(HomeView.ActionType.EXPORT_TO_CSV, true);
        homeView.setEnabled(HomeView.ActionType.SELECT, true);
        homeView.setEnabled(HomeView.ActionType.PAN, true);
        homeView.setEnabled(HomeView.ActionType.LOCK_BASE_PLAN, true);
        homeView.setEnabled(HomeView.ActionType.UNLOCK_BASE_PLAN, true);
        homeView.setEnabled(HomeView.ActionType.MODIFY_COMPASS, true);
        Level level = this.home.getSelectedLevel();
        this.enableBackgroungImageActions(homeView, level != null ? level.getBackgroundImage() : this.home.getBackgroundImage());
        homeView.setEnabled(HomeView.ActionType.ADD_LEVEL, true);
        homeView.setEnabled(HomeView.ActionType.ADD_LEVEL_AT_SAME_ELEVATION, true);
        List<Level> list = this.home.getLevels();
        boolean bl2 = list.size() > 1 && level != null;
        homeView.setEnabled(HomeView.ActionType.SELECT_ALL_AT_ALL_LEVELS, list.size() > 1);
        homeView.setEnabled(HomeView.ActionType.MAKE_LEVEL_VIEWABLE, bl2);
        homeView.setEnabled(HomeView.ActionType.MAKE_LEVEL_UNVIEWABLE, bl2);
        homeView.setEnabled(HomeView.ActionType.MODIFY_LEVEL, bl2);
        homeView.setEnabled(HomeView.ActionType.DELETE_LEVEL, bl2);
        homeView.setEnabled(HomeView.ActionType.ZOOM_IN, true);
        homeView.setEnabled(HomeView.ActionType.ZOOM_OUT, true);
        homeView.setEnabled(HomeView.ActionType.EXPORT_TO_SVG, true);
        homeView.setEnabled(HomeView.ActionType.VIEW_FROM_TOP, true);
        homeView.setEnabled(HomeView.ActionType.VIEW_FROM_OBSERVER, true);
        homeView.setEnabled(HomeView.ActionType.MODIFY_OBSERVER, this.home.getCamera() == this.home.getObserverCamera());
        homeView.setEnabled(HomeView.ActionType.STORE_POINT_OF_VIEW, true);
        boolean bl3 = this.home.getStoredCameras().isEmpty();
        homeView.setEnabled(HomeView.ActionType.DELETE_POINTS_OF_VIEW, !bl3);
        homeView.setEnabled(HomeView.ActionType.CREATE_PHOTOS_AT_POINTS_OF_VIEW, !bl3);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_ALL_LEVELS, list.size() > 1);
        homeView.setEnabled(HomeView.ActionType.DISPLAY_SELECTED_LEVEL, list.size() > 1);
        homeView.setEnabled(HomeView.ActionType.DETACH_3D_VIEW, true);
        homeView.setEnabled(HomeView.ActionType.ATTACH_3D_VIEW, true);
        homeView.setEnabled(HomeView.ActionType.VIEW_FROM_OBSERVER, true);
        homeView.setEnabled(HomeView.ActionType.MODIFY_3D_ATTRIBUTES, true);
        homeView.setEnabled(HomeView.ActionType.CREATE_PHOTO, true);
        homeView.setEnabled(HomeView.ActionType.CREATE_VIDEO, true);
        homeView.setEnabled(HomeView.ActionType.EXPORT_TO_OBJ, true);
        homeView.setEnabled(HomeView.ActionType.HELP, true);
        homeView.setEnabled(HomeView.ActionType.ABOUT, true);
        this.enableCreationToolsActions(homeView);
        homeView.setTransferEnabled(true);
    }

    private void enableCreationToolsActions(HomeView homeView) {
        Level level = this.home.getSelectedLevel();
        boolean bl = level == null || level.isViewable();
        homeView.setEnabled(HomeView.ActionType.CREATE_WALLS, bl);
        homeView.setEnabled(HomeView.ActionType.CREATE_ROOMS, bl);
        homeView.setEnabled(HomeView.ActionType.CREATE_POLYLINES, bl);
        homeView.setEnabled(HomeView.ActionType.CREATE_DIMENSION_LINES, bl);
        homeView.setEnabled(HomeView.ActionType.CREATE_LABELS, bl);
    }

    @Override
    public HomeView getView() {
        if (this.homeView == null) {
            this.homeView = this.viewFactory.createHomeView(this.home, this.preferences, this);
            this.enableDefaultActions(this.homeView);
            this.addListeners();
        }
        return this.homeView;
    }

    public ContentManager getContentManager() {
        return this.contentManager;
    }

    public FurnitureCatalogController getFurnitureCatalogController() {
        if (this.furnitureCatalogController == null) {
            this.furnitureCatalogController = new FurnitureCatalogController(this.preferences.getFurnitureCatalog(), this.preferences, this.viewFactory, this.contentManager);
        }
        return this.furnitureCatalogController;
    }

    public FurnitureController getFurnitureController() {
        if (this.furnitureController == null) {
            this.furnitureController = new FurnitureController(this.home, this.preferences, this.viewFactory, this.contentManager, this.getUndoableEditSupport());
        }
        return this.furnitureController;
    }

    public PlanController getPlanController() {
        if (this.planController == null) {
            this.planController = new PlanController(this.home, this.preferences, this.viewFactory, this.contentManager, this.getUndoableEditSupport());
        }
        return this.planController;
    }

    public HomeController3D getHomeController3D() {
        if (this.homeController3D == null) {
            this.homeController3D = new HomeController3D(this.home, this.preferences, this.viewFactory, this.contentManager, this.getUndoableEditSupport());
        }
        return this.homeController3D;
    }

    protected final UndoableEditSupport getUndoableEditSupport() {
        return this.undoSupport;
    }

    private void addListeners() {
        this.preferences.getFurnitureCatalog().addFurnitureListener(new FurnitureCatalogChangeListener(this));
        this.preferences.getTexturesCatalog().addTexturesListener(new TexturesCatalogChangeListener(this));
        UserPreferencesPropertiesChangeListener userPreferencesPropertiesChangeListener = new UserPreferencesPropertiesChangeListener(this);
        for (UserPreferences.Property property : UserPreferences.Property.values()) {
            this.preferences.addPropertyChangeListener(property, userPreferencesPropertiesChangeListener);
        }
        this.addCatalogSelectionListener();
        this.addHomeBackgroundImageListener();
        this.addNotUndoableModificationListeners();
        this.addHomeSelectionListener();
        this.addFurnitureSortListener();
        this.addUndoSupportListener();
        this.addHomeItemsListener();
        this.addLevelListeners();
        this.addStoredCamerasListener();
        this.addPlanControllerListeners();
        this.addLanguageListener();
    }

    private void addCatalogSelectionListener() {
        this.getFurnitureCatalogController().addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                HomeController.this.enableActionsBoundToSelection();
            }
        });
    }

    private void addLanguageListener() {
        this.preferences.addPropertyChangeListener(UserPreferences.Property.LANGUAGE, new LanguageChangeListener(this));
    }

    private void addHomeSelectionListener() {
        if (this.home != null) {
            this.home.addSelectionListener(new SelectionListener(){

                public void selectionChanged(SelectionEvent selectionEvent) {
                    HomeController.this.enableActionsBoundToSelection();
                }
            });
        }
    }

    private void addFurnitureSortListener() {
        if (this.home != null) {
            this.home.addPropertyChangeListener(Home.Property.FURNITURE_SORTED_PROPERTY, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    HomeController.this.getView().setEnabled(HomeView.ActionType.SORT_HOME_FURNITURE_BY_DESCENDING_ORDER, propertyChangeEvent.getNewValue() != null);
                }
            });
        }
    }

    private void addHomeBackgroundImageListener() {
        if (this.home != null) {
            this.home.addPropertyChangeListener(Home.Property.BACKGROUND_IMAGE, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    HomeController.this.enableBackgroungImageActions(HomeController.this.getView(), (BackgroundImage)propertyChangeEvent.getNewValue());
                }
            });
        }
    }

    private void enableBackgroungImageActions(HomeView homeView, BackgroundImage backgroundImage) {
        Level level = this.home.getSelectedLevel();
        boolean bl = backgroundImage != null && (level == null || level.isViewable());
        this.getView().setEnabled(HomeView.ActionType.IMPORT_BACKGROUND_IMAGE, !bl);
        this.getView().setEnabled(HomeView.ActionType.MODIFY_BACKGROUND_IMAGE, bl);
        this.getView().setEnabled(HomeView.ActionType.HIDE_BACKGROUND_IMAGE, bl && backgroundImage.isVisible());
        this.getView().setEnabled(HomeView.ActionType.SHOW_BACKGROUND_IMAGE, bl && !backgroundImage.isVisible());
        this.getView().setEnabled(HomeView.ActionType.DELETE_BACKGROUND_IMAGE, bl);
    }

    private void addNotUndoableModificationListeners() {
        if (this.home != null) {
            final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    HomeController.this.notUndoableModifications = true;
                    HomeController.this.home.setModified(true);
                }
            };
            this.home.addPropertyChangeListener(Home.Property.STORED_CAMERAS, propertyChangeListener);
            this.home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.OBSERVER_CAMERA_ELEVATION_ADJUSTED, propertyChangeListener);
            this.home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.VIDEO_WIDTH, propertyChangeListener);
            this.home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.VIDEO_ASPECT_RATIO, propertyChangeListener);
            this.home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.VIDEO_FRAME_RATE, propertyChangeListener);
            this.home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.VIDEO_QUALITY, propertyChangeListener);
            this.home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.VIDEO_CAMERA_PATH, propertyChangeListener);
            this.home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.CEILING_LIGHT_COLOR, propertyChangeListener);
            this.home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.PHOTO_QUALITY, propertyChangeListener);
            this.home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.PHOTO_ASPECT_RATIO, propertyChangeListener);
            PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (HomeController.this.home.getEnvironment().getPhotoAspectRatio() != AspectRatio.VIEW_3D_RATIO) {
                        propertyChangeListener.propertyChange(propertyChangeEvent);
                    }
                }
            };
            this.home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.PHOTO_WIDTH, propertyChangeListener2);
            this.home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.PHOTO_HEIGHT, propertyChangeListener2);
            PropertyChangeListener propertyChangeListener3 = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals(Camera.Property.TIME.name()) || propertyChangeEvent.getPropertyName().equals(Camera.Property.LENS.name())) {
                        propertyChangeListener.propertyChange(propertyChangeEvent);
                    }
                }
            };
            this.home.getObserverCamera().addPropertyChangeListener(propertyChangeListener3);
            this.home.getTopCamera().addPropertyChangeListener(propertyChangeListener3);
        }
    }

    protected void enableActionsBoundToSelection() {
        List<HomePieceOfFurniture> list;
        boolean bl = this.getPlanController().isModificationState();
        List<CatalogPieceOfFurniture> list2 = this.getFurnitureCatalogController().getSelectedFurniture();
        boolean bl2 = !list2.isEmpty();
        boolean bl3 = list2.size() == 1 && list2.get(0).isModifiable();
        List<Selectable> list3 = this.home.getSelectedItems();
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = list3.size() == 1 && list3.get(0) instanceof HomeFurnitureGroup;
        boolean bl13 = false;
        boolean bl14 = false;
        boolean bl15 = false;
        boolean bl16 = false;
        boolean bl17 = false;
        boolean bl18 = false;
        boolean bl19 = false;
        boolean bl20 = false;
        boolean bl21 = false;
        boolean bl22 = false;
        FurnitureController furnitureController = this.getFurnitureController();
        if (!bl) {
            List<Wall> list4;
            Object object2;
            list = list3.iterator();
            while (list.hasNext()) {
                Iterator<HomePieceOfFurniture> iterator = (Selectable)list.next();
                if (!this.getPlanController().isItemDeletable((Selectable)((Object)iterator))) continue;
                bl4 = true;
                break;
            }
            bl5 = !(list = Home.getFurnitureSubList(list3)).isEmpty();
            for (HomePieceOfFurniture object22 : list) {
                if (!furnitureController.isPieceOfFurnitureDeletable(object22)) continue;
                bl6 = true;
                break;
            }
            for (HomePieceOfFurniture homePieceOfFurniture : list) {
                if (!(homePieceOfFurniture instanceof HomeFurnitureGroup)) continue;
                bl13 = true;
                break;
            }
            int n = 0;
            for (Object object2 : list) {
                if (!furnitureController.isPieceOfFurnitureMovable((HomePieceOfFurniture)object2)) continue;
                bl8 = true;
                if (++n >= 2) {
                    bl9 = true;
                }
                if (n < 3) continue;
                bl11 = true;
                break;
            }
            if (bl9) {
                bl10 = true;
                List<HomePieceOfFurniture> list5 = this.home.getFurniture();
                for (HomePieceOfFurniture homePieceOfFurniture : list) {
                    if (furnitureController.isPieceOfFurnitureMovable(homePieceOfFurniture) && list5.contains(homePieceOfFurniture)) continue;
                    bl10 = false;
                    break;
                }
            }
            bl14 = !(list4 = Home.getWallsSubList(list3)).isEmpty();
            bl17 = list4.size() == 1;
            object2 = Home.getRoomsSubList(list3);
            bl15 = !object2.isEmpty();
            bl18 = list3.size() == 1 && object2.size() == 1;
            bl19 = bl18 && object2.get(0).getPointCount() >= 4;
            boolean bl23 = !Home.getDimensionLinesSubList(list3).isEmpty();
            bl16 = !Home.getPolylinesSubList(list3).isEmpty();
            bl20 = !Home.getLabelsSubList(list3).isEmpty();
            bl22 = list3.contains(this.home.getCompass());
            bl7 = bl5 || bl14 || bl15 || bl23 || bl16 || bl20 || bl22;
            bl21 = bl5 || bl15 || bl23 || bl20;
        }
        list = this.getView();
        if (this.focusedView == this.getFurnitureCatalogController().getView()) {
            list.setEnabled(HomeView.ActionType.COPY, !bl && bl2);
            list.setEnabled(HomeView.ActionType.CUT, false);
            list.setEnabled(HomeView.ActionType.DELETE, false);
            for (CatalogPieceOfFurniture catalogPieceOfFurniture : list2) {
                if (!catalogPieceOfFurniture.isModifiable()) continue;
                list.setEnabled(HomeView.ActionType.DELETE, true);
                break;
            }
        } else if (this.focusedView == furnitureController.getView()) {
            list.setEnabled(HomeView.ActionType.COPY, bl5);
            list.setEnabled(HomeView.ActionType.CUT, bl6);
            list.setEnabled(HomeView.ActionType.DELETE, bl6);
        } else if (this.focusedView == this.getPlanController().getView()) {
            list.setEnabled(HomeView.ActionType.COPY, bl7);
            list.setEnabled(HomeView.ActionType.CUT, bl4);
            list.setEnabled(HomeView.ActionType.DELETE, bl4);
        } else {
            list.setEnabled(HomeView.ActionType.COPY, false);
            list.setEnabled(HomeView.ActionType.CUT, false);
            list.setEnabled(HomeView.ActionType.DELETE, false);
        }
        this.enablePasteToGroupAction();
        this.enablePasteStyleAction();
        Level level = this.home.getSelectedLevel();
        boolean bl24 = level == null || level.isViewable();
        list.setEnabled(HomeView.ActionType.ADD_HOME_FURNITURE, bl2 && bl24);
        list.setEnabled(HomeView.ActionType.ADD_FURNITURE_TO_GROUP, bl2 && bl24 && bl12);
        list.setEnabled(HomeView.ActionType.DELETE_HOME_FURNITURE, bl6);
        list.setEnabled(HomeView.ActionType.DELETE_SELECTION, bl2 && this.focusedView == this.getFurnitureCatalogController().getView() || bl4 && (this.focusedView == furnitureController.getView() || this.focusedView == this.getPlanController().getView() || this.focusedView == this.getHomeController3D().getView()));
        list.setEnabled(HomeView.ActionType.MODIFY_FURNITURE, bl3 && this.focusedView == this.getFurnitureCatalogController().getView() || bl5 && (this.focusedView == furnitureController.getView() || this.focusedView == this.getPlanController().getView() || this.focusedView == this.getHomeController3D().getView()));
        list.setEnabled(HomeView.ActionType.MODIFY_WALL, bl14);
        list.setEnabled(HomeView.ActionType.REVERSE_WALL_DIRECTION, bl14);
        list.setEnabled(HomeView.ActionType.SPLIT_WALL, bl17);
        list.setEnabled(HomeView.ActionType.MODIFY_ROOM, bl15);
        list.setEnabled(HomeView.ActionType.MODIFY_POLYLINE, bl16);
        list.setEnabled(HomeView.ActionType.MODIFY_LABEL, bl20);
        list.setEnabled(HomeView.ActionType.TOGGLE_BOLD_STYLE, bl21);
        list.setEnabled(HomeView.ActionType.TOGGLE_ITALIC_STYLE, bl21);
        list.setEnabled(HomeView.ActionType.INCREASE_TEXT_SIZE, bl21);
        list.setEnabled(HomeView.ActionType.DECREASE_TEXT_SIZE, bl21);
        list.setEnabled(HomeView.ActionType.ALIGN_FURNITURE_ON_TOP, bl9);
        list.setEnabled(HomeView.ActionType.ALIGN_FURNITURE_ON_BOTTOM, bl9);
        list.setEnabled(HomeView.ActionType.ALIGN_FURNITURE_ON_LEFT, bl9);
        list.setEnabled(HomeView.ActionType.ALIGN_FURNITURE_ON_RIGHT, bl9);
        list.setEnabled(HomeView.ActionType.ALIGN_FURNITURE_ON_FRONT_SIDE, bl9);
        list.setEnabled(HomeView.ActionType.ALIGN_FURNITURE_ON_BACK_SIDE, bl9);
        list.setEnabled(HomeView.ActionType.ALIGN_FURNITURE_ON_LEFT_SIDE, bl9);
        list.setEnabled(HomeView.ActionType.ALIGN_FURNITURE_ON_RIGHT_SIDE, bl9);
        list.setEnabled(HomeView.ActionType.ALIGN_FURNITURE_SIDE_BY_SIDE, bl9);
        list.setEnabled(HomeView.ActionType.DISTRIBUTE_FURNITURE_HORIZONTALLY, bl11);
        list.setEnabled(HomeView.ActionType.DISTRIBUTE_FURNITURE_VERTICALLY, bl11);
        list.setEnabled(HomeView.ActionType.RESET_FURNITURE_ELEVATION, bl8);
        list.setEnabled(HomeView.ActionType.GROUP_FURNITURE, bl10);
        list.setEnabled(HomeView.ActionType.UNGROUP_FURNITURE, bl13);
        boolean bl25 = this.getPlanController() != null && this.getPlanController().getMode() == PlanController.Mode.SELECTION;
        list.setEnabled(HomeView.ActionType.ADD_ROOM_POINT, bl18 && bl25);
        list.setEnabled(HomeView.ActionType.DELETE_ROOM_POINT, bl19 && bl25);
    }

    public void enablePasteAction() {
        HomeView homeView = this.getView();
        boolean bl = false;
        boolean bl2 = false;
        if (this.focusedView == this.getFurnitureController().getView() || this.focusedView == this.getPlanController().getView()) {
            List<Selectable> list;
            Level level = this.home.getSelectedLevel();
            boolean bl3 = bl = (level == null || level.isViewable()) && !this.getPlanController().isModificationState() && !homeView.isClipboardEmpty();
            if (bl && (list = this.home.getSelectedItems()).size() == 1 && list.get(0) instanceof HomeFurnitureGroup) {
                bl2 = true;
                for (Selectable selectable : homeView.getClipboardItems()) {
                    if (selectable instanceof HomePieceOfFurniture) continue;
                    bl2 = false;
                    break;
                }
            }
        }
        homeView.setEnabled(HomeView.ActionType.PASTE, bl);
        this.enablePasteToGroupAction();
        this.enablePasteStyleAction();
    }

    private void enablePasteToGroupAction() {
        List<Selectable> list;
        List<Selectable> list2;
        Level level;
        HomeView homeView = this.getView();
        boolean bl = false;
        if (!(this.focusedView != this.getFurnitureController().getView() && this.focusedView != this.getPlanController().getView() || (level = this.home.getSelectedLevel()) != null && !level.isViewable() || this.getPlanController().isModificationState() || (list2 = this.home.getSelectedItems()).size() != 1 || !(list2.get(0) instanceof HomeFurnitureGroup) || (list = homeView.getClipboardItems()) == null)) {
            bl = true;
            for (Selectable selectable : list) {
                if (selectable instanceof HomePieceOfFurniture) continue;
                bl = false;
                break;
            }
        }
        homeView.setEnabled(HomeView.ActionType.PASTE_TO_GROUP, bl);
    }

    private void enablePasteStyleAction() {
        List<Selectable> list;
        HomeView homeView = this.getView();
        boolean bl = false;
        if (!(this.focusedView != this.getFurnitureController().getView() && this.focusedView != this.getPlanController().getView() || this.getPlanController().isModificationState() || (list = homeView.getClipboardItems()) == null || list.size() != 1)) {
            Selectable selectable = list.get(0);
            for (Selectable selectable2 : this.home.getSelectedItems()) {
                if (!(selectable2 instanceof HomePieceOfFurniture && selectable instanceof HomePieceOfFurniture || selectable2 instanceof Wall && selectable instanceof Wall || selectable2 instanceof Room && selectable instanceof Room || selectable2 instanceof Polyline && selectable instanceof Polyline) && (!(selectable2 instanceof Label) || !(selectable instanceof Label))) continue;
                bl = true;
                break;
            }
        }
        homeView.setEnabled(HomeView.ActionType.PASTE_STYLE, bl);
    }

    protected void enableSelectAllAction() {
        HomeView homeView = this.getView();
        boolean bl = this.getPlanController().isModificationState();
        if (this.focusedView == this.getFurnitureController().getView()) {
            homeView.setEnabled(HomeView.ActionType.SELECT_ALL, !bl && this.home.getFurniture().size() > 0);
        } else if (this.focusedView == this.getPlanController().getView() || this.focusedView == this.getHomeController3D().getView()) {
            boolean bl2 = !this.home.isEmpty() || this.home.getCompass().isVisible();
            homeView.setEnabled(HomeView.ActionType.SELECT_ALL, !bl && bl2);
        } else {
            homeView.setEnabled(HomeView.ActionType.SELECT_ALL, false);
        }
    }

    private void enableZoomActions() {
        PlanController planController = this.getPlanController();
        float f = planController.getScale();
        HomeView homeView = this.getView();
        homeView.setEnabled(HomeView.ActionType.ZOOM_IN, f < planController.getMaximumScale());
        homeView.setEnabled(HomeView.ActionType.ZOOM_OUT, f > planController.getMinimumScale());
    }

    private void addUndoSupportListener() {
        this.getUndoableEditSupport().addUndoableEditListener(new UndoableEditListener(){

            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                HomeView homeView = HomeController.this.getView();
                homeView.setEnabled(HomeView.ActionType.UNDO, !HomeController.this.getPlanController().isModificationState());
                homeView.setEnabled(HomeView.ActionType.REDO, false);
                homeView.setUndoRedoName(undoableEditEvent.getEdit().getUndoPresentationName(), null);
                HomeController.this.saveUndoLevel++;
                HomeController.this.home.setModified(true);
            }
        });
        this.home.addPropertyChangeListener(Home.Property.MODIFIED, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!HomeController.this.home.isModified()) {
                    HomeController.this.saveUndoLevel = 0;
                    HomeController.this.notUndoableModifications = false;
                }
            }
        });
    }

    private void addHomeItemsListener() {
        CollectionListener collectionListener = new CollectionListener(){

            public void collectionChanged(CollectionEvent collectionEvent) {
                if (collectionEvent.getType() == CollectionEvent.Type.ADD || collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    HomeController.this.enableSelectAllAction();
                }
            }
        };
        this.home.addFurnitureListener(collectionListener);
        this.home.addWallsListener(collectionListener);
        this.home.addRoomsListener(collectionListener);
        this.home.addPolylinesListener(collectionListener);
        this.home.addDimensionLinesListener(collectionListener);
        this.home.addLabelsListener(collectionListener);
        this.home.getCompass().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (Compass.Property.VISIBLE.equals(propertyChangeEvent.getPropertyName())) {
                    HomeController.this.enableSelectAllAction();
                }
            }
        });
        this.home.addPropertyChangeListener(Home.Property.CAMERA, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomeController.this.getView().setEnabled(HomeView.ActionType.MODIFY_OBSERVER, HomeController.this.home.getCamera() == HomeController.this.home.getObserverCamera());
            }
        });
    }

    private void addLevelListeners() {
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                List<Object> list;
                Level level = HomeController.this.home.getSelectedLevel();
                if (!HomeController.this.home.isAllLevelsSelection()) {
                    list = new ArrayList<Selectable>();
                    for (Selectable selectable : HomeController.this.home.getSelectedItems()) {
                        if (selectable instanceof Elevatable && !((Elevatable)((Object)selectable)).isAtLevel(level)) continue;
                        list.add(selectable);
                    }
                    HomeController.this.home.setSelectedItems(list);
                }
                HomeController.this.enableCreationToolsActions(HomeController.this.getView());
                HomeController.this.enableBackgroungImageActions(HomeController.this.getView(), level == null ? HomeController.this.home.getBackgroundImage() : level.getBackgroundImage());
                list = HomeController.this.home.getLevels();
                boolean bl = list.size() > 1 && level != null;
                HomeController.this.getView().setEnabled(HomeView.ActionType.SELECT_ALL_AT_ALL_LEVELS, list.size() > 1);
                HomeController.this.getView().setEnabled(HomeView.ActionType.MAKE_LEVEL_VIEWABLE, bl);
                HomeController.this.getView().setEnabled(HomeView.ActionType.MAKE_LEVEL_UNVIEWABLE, bl);
                HomeController.this.getView().setEnabled(HomeView.ActionType.MODIFY_LEVEL, bl);
                HomeController.this.getView().setEnabled(HomeView.ActionType.DELETE_LEVEL, bl);
                HomeController.this.getView().setEnabled(HomeView.ActionType.DISPLAY_ALL_LEVELS, list.size() > 1);
                HomeController.this.getView().setEnabled(HomeView.ActionType.DISPLAY_SELECTED_LEVEL, list.size() > 1);
            }
        };
        this.home.addPropertyChangeListener(Home.Property.SELECTED_LEVEL, propertyChangeListener);
        final PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (Level.Property.BACKGROUND_IMAGE.name().equals(propertyChangeEvent.getPropertyName())) {
                    HomeController.this.enableBackgroungImageActions(HomeController.this.getView(), (BackgroundImage)propertyChangeEvent.getNewValue());
                } else if (Level.Property.VIEWABLE.name().equals(propertyChangeEvent.getPropertyName())) {
                    PlanController.Mode mode;
                    HomeController.this.enableCreationToolsActions(HomeController.this.getView());
                    if (!((Boolean)propertyChangeEvent.getNewValue()).booleanValue() && (mode = HomeController.this.getPlanController().getMode()) != PlanController.Mode.SELECTION && mode != PlanController.Mode.PANNING) {
                        HomeController.this.getPlanController().setMode(PlanController.Mode.SELECTION);
                    }
                }
            }
        };
        for (Level level : this.home.getLevels()) {
            level.addPropertyChangeListener(propertyChangeListener2);
        }
        this.home.addLevelsListener(new CollectionListener<Level>(){

            @Override
            public void collectionChanged(CollectionEvent<Level> collectionEvent) {
                switch (collectionEvent.getType()) {
                    case ADD: {
                        HomeController.this.home.setSelectedLevel(collectionEvent.getItem());
                        collectionEvent.getItem().addPropertyChangeListener(propertyChangeListener2);
                        break;
                    }
                    case DELETE: {
                        propertyChangeListener.propertyChange(null);
                        collectionEvent.getItem().removePropertyChangeListener(propertyChangeListener2);
                    }
                }
            }
        });
    }

    private void addStoredCamerasListener() {
        this.home.addPropertyChangeListener(Home.Property.STORED_CAMERAS, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = HomeController.this.home.getStoredCameras().isEmpty();
                HomeController.this.getView().setEnabled(HomeView.ActionType.DELETE_POINTS_OF_VIEW, !bl);
                HomeController.this.getView().setEnabled(HomeView.ActionType.CREATE_PHOTOS_AT_POINTS_OF_VIEW, !bl);
            }
        });
    }

    private void addPlanControllerListeners() {
        this.getPlanController().addPropertyChangeListener(PlanController.Property.MODIFICATION_STATE, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomeController.this.enableActionsBoundToSelection();
                HomeController.this.enableSelectAllAction();
                HomeView homeView = HomeController.this.getView();
                if (HomeController.this.getPlanController().isModificationState()) {
                    homeView.setEnabled(HomeView.ActionType.PASTE, false);
                    homeView.setEnabled(HomeView.ActionType.UNDO, false);
                    homeView.setEnabled(HomeView.ActionType.REDO, false);
                } else {
                    HomeController.this.enablePasteAction();
                    homeView.setEnabled(HomeView.ActionType.UNDO, HomeController.this.undoManager.canUndo());
                    homeView.setEnabled(HomeView.ActionType.REDO, HomeController.this.undoManager.canRedo());
                }
            }
        });
        this.getPlanController().addPropertyChangeListener(PlanController.Property.MODE, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomeController.this.enableActionsBoundToSelection();
            }
        });
        this.getPlanController().addPropertyChangeListener(PlanController.Property.SCALE, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomeController.this.enableZoomActions();
            }
        });
    }

    public void addHomeFurniture() {
        this.addFurniture(null);
    }

    public void addFurnitureToGroup() {
        this.addFurniture((HomeFurnitureGroup)this.home.getSelectedItems().get(0));
    }

    private void addFurniture(HomeFurnitureGroup homeFurnitureGroup) {
        this.getPlanController().setMode(PlanController.Mode.SELECTION);
        List<CatalogPieceOfFurniture> list = this.getFurnitureCatalogController().getSelectedFurniture();
        if (!list.isEmpty()) {
            ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>();
            for (CatalogPieceOfFurniture catalogPieceOfFurniture : list) {
                arrayList.add(this.getFurnitureController().createHomePieceOfFurniture(catalogPieceOfFurniture));
            }
            this.adjustFurnitureSizeAndElevation(arrayList, false);
            if (homeFurnitureGroup != null) {
                this.getFurnitureController().addFurnitureToGroup(arrayList, homeFurnitureGroup);
            } else {
                this.getFurnitureController().addFurniture(arrayList);
            }
        }
    }

    public void modifySelectedFurniture() {
        if (this.focusedView == this.getFurnitureCatalogController().getView()) {
            this.getFurnitureCatalogController().modifySelectedFurniture();
        } else if (this.focusedView == this.getFurnitureController().getView() || this.focusedView == this.getPlanController().getView() || this.focusedView == this.getHomeController3D().getView()) {
            this.getFurnitureController().modifySelectedFurniture();
        }
    }

    public void importLanguageLibrary() {
        this.getView().invokeLater(new Runnable(){

            public void run() {
                String string = HomeController.this.getView().showImportLanguageLibraryDialog();
                if (string != null) {
                    HomeController.this.importLanguageLibrary(string);
                }
            }
        });
    }

    public void importLanguageLibrary(String string) {
        try {
            if (!this.preferences.languageLibraryExists(string) || this.getView().confirmReplaceLanguageLibrary(string)) {
                this.preferences.addLanguageLibrary(string);
            }
        }
        catch (RecorderException recorderException) {
            String string2 = this.preferences.getLocalizedString(HomeController.class, "importLanguageLibraryError", string);
            this.getView().showError(string2);
        }
    }

    public void importFurniture() {
        this.getPlanController().setMode(PlanController.Mode.SELECTION);
        if (this.focusedView == this.getFurnitureCatalogController().getView()) {
            this.getFurnitureCatalogController().importFurniture();
        } else {
            this.getFurnitureController().importFurniture();
        }
    }

    public void importFurnitureLibrary() {
        this.getView().invokeLater(new Runnable(){

            public void run() {
                String string = HomeController.this.getView().showImportFurnitureLibraryDialog();
                if (string != null) {
                    HomeController.this.importFurnitureLibrary(string);
                }
            }
        });
    }

    public void importFurnitureLibrary(String string) {
        try {
            if (!this.preferences.furnitureLibraryExists(string) || this.getView().confirmReplaceFurnitureLibrary(string)) {
                this.preferences.addFurnitureLibrary(string);
                this.getView().showMessage(this.preferences.getLocalizedString(HomeController.class, "importedFurnitureLibraryMessage", this.contentManager.getPresentationName(string, ContentManager.ContentType.FURNITURE_LIBRARY)));
            }
        }
        catch (RecorderException recorderException) {
            String string2 = this.preferences.getLocalizedString(HomeController.class, "importFurnitureLibraryError", string);
            this.getView().showError(string2);
        }
    }

    public void importTexture() {
        new ImportedTextureWizardController(this.preferences, this.viewFactory, this.contentManager).displayView(this.getView());
    }

    public void importTexturesLibrary() {
        this.getView().invokeLater(new Runnable(){

            public void run() {
                String string = HomeController.this.getView().showImportTexturesLibraryDialog();
                if (string != null) {
                    HomeController.this.importTexturesLibrary(string);
                }
            }
        });
    }

    public void importTexturesLibrary(String string) {
        try {
            if (!this.preferences.texturesLibraryExists(string) || this.getView().confirmReplaceTexturesLibrary(string)) {
                this.preferences.addTexturesLibrary(string);
                this.getView().showMessage(this.preferences.getLocalizedString(HomeController.class, "importedTexturesLibraryMessage", this.contentManager.getPresentationName(string, ContentManager.ContentType.TEXTURES_LIBRARY)));
            }
        }
        catch (RecorderException recorderException) {
            String string2 = this.preferences.getLocalizedString(HomeController.class, "importTexturesLibraryError", string);
            this.getView().showError(string2);
        }
    }

    public void undo() {
        this.undoManager.undo();
        HomeView homeView = this.getView();
        boolean bl = this.undoManager.canUndo();
        homeView.setEnabled(HomeView.ActionType.UNDO, bl);
        homeView.setEnabled(HomeView.ActionType.REDO, true);
        if (bl) {
            homeView.setUndoRedoName(this.undoManager.getUndoPresentationName(), this.undoManager.getRedoPresentationName());
        } else {
            homeView.setUndoRedoName(null, this.undoManager.getRedoPresentationName());
        }
        --this.saveUndoLevel;
        this.home.setModified(this.saveUndoLevel != 0 || this.notUndoableModifications);
    }

    public void redo() {
        this.undoManager.redo();
        HomeView homeView = this.getView();
        boolean bl = this.undoManager.canRedo();
        homeView.setEnabled(HomeView.ActionType.UNDO, true);
        homeView.setEnabled(HomeView.ActionType.REDO, bl);
        if (bl) {
            homeView.setUndoRedoName(this.undoManager.getUndoPresentationName(), this.undoManager.getRedoPresentationName());
        } else {
            homeView.setUndoRedoName(this.undoManager.getUndoPresentationName(), null);
        }
        ++this.saveUndoLevel;
        this.home.setModified(this.saveUndoLevel != 0 || this.notUndoableModifications);
    }

    public void cut(List<? extends Selectable> list) {
        UndoableEditSupport undoableEditSupport = this.getUndoableEditSupport();
        undoableEditSupport.beginUpdate();
        this.getPlanController().deleteItems(list);
        undoableEditSupport.postEdit(new AbstractUndoableEdit(){

            public String getPresentationName() {
                return HomeController.this.preferences.getLocalizedString(HomeController.class, "undoCutName", new Object[0]);
            }
        });
        undoableEditSupport.endUpdate();
    }

    public void paste(List<? extends Selectable> list) {
        List<Selectable> list2 = this.home.getSelectedItems();
        float f = 0.0f;
        if (list.size() == list2.size()) {
            f = 20.0f;
            for (Selectable selectable : list) {
                float[][] fArray = selectable.getPoints();
                boolean bl = false;
                for (Selectable selectable2 : list2) {
                    if (!Arrays.deepEquals((Object[])fArray, (Object[])selectable2.getPoints())) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                f = 0.0f;
                break;
            }
        }
        this.addPastedItems(list, f, f, false, "undoPasteName");
    }

    public void drop(List<? extends Selectable> list, float f, float f2) {
        this.drop(list, null, f, f2);
    }

    public void drop(List<? extends Selectable> list, View view, float f, float f2) {
        this.addPastedItems(list, f, f2, view == this.getPlanController().getView(), "undoDropName");
    }

    private void addPastedItems(List<? extends Selectable> list, float f, float f2, boolean bl, final String string) {
        if (list.size() > 1 || list.size() == 1 && !(list.get(0) instanceof Compass)) {
            this.getPlanController().setMode(PlanController.Mode.SELECTION);
            UndoableEditSupport undoableEditSupport = this.getUndoableEditSupport();
            undoableEditSupport.beginUpdate();
            List<HomePieceOfFurniture> list2 = Home.getFurnitureSubList(list);
            this.adjustFurnitureSizeAndElevation(list2, f == 0.0f && f2 == 0.0f);
            this.getPlanController().moveItems(list, f, f2);
            if (bl && this.preferences.isMagnetismEnabled() && list.size() == 1 && list2.size() == 1) {
                this.getPlanController().adjustMagnetizedPieceOfFurniture((HomePieceOfFurniture)list.get(0), f, f2);
            }
            this.getPlanController().addItems(list);
            undoableEditSupport.postEdit(new AbstractUndoableEdit(){

                public String getPresentationName() {
                    return HomeController.this.preferences.getLocalizedString(HomeController.class, string, new Object[0]);
                }
            });
            undoableEditSupport.endUpdate();
        }
    }

    private void adjustFurnitureSizeAndElevation(List<HomePieceOfFurniture> list, boolean bl) {
        if (this.preferences.isMagnetismEnabled()) {
            for (HomePieceOfFurniture homePieceOfFurniture : list) {
                if (homePieceOfFurniture.isResizable()) {
                    homePieceOfFurniture.setWidth(this.preferences.getLengthUnit().getMagnetizedLength(homePieceOfFurniture.getWidth(), 0.1f));
                    if (!(homePieceOfFurniture instanceof HomeDoorOrWindow) || !bl) {
                        homePieceOfFurniture.setDepth(this.preferences.getLengthUnit().getMagnetizedLength(homePieceOfFurniture.getDepth(), 0.1f));
                    }
                    homePieceOfFurniture.setHeight(this.preferences.getLengthUnit().getMagnetizedLength(homePieceOfFurniture.getHeight(), 0.1f));
                }
                homePieceOfFurniture.setElevation(this.preferences.getLengthUnit().getMagnetizedLength(homePieceOfFurniture.getElevation(), 0.1f));
            }
        }
    }

    public void dropFiles(List<String> list, float f, float f2) {
        this.getPlanController().setMode(PlanController.Mode.SELECTION);
        final ArrayList arrayList = new ArrayList(list.size());
        CollectionListener<HomePieceOfFurniture> collectionListener = new CollectionListener<HomePieceOfFurniture>(){

            @Override
            public void collectionChanged(CollectionEvent<HomePieceOfFurniture> collectionEvent) {
                arrayList.add(collectionEvent.getItem());
            }
        };
        this.home.addFurnitureListener(collectionListener);
        UndoableEditSupport undoableEditSupport = this.getUndoableEditSupport();
        undoableEditSupport.beginUpdate();
        for (String string : list) {
            this.getFurnitureController().importFurniture(string);
        }
        this.home.removeFurnitureListener(collectionListener);
        if (arrayList.size() > 0) {
            this.getPlanController().moveItems(arrayList, f, f2);
            this.home.setSelectedItems(arrayList);
            undoableEditSupport.postEdit(new AbstractUndoableEdit(){

                public void redo() throws CannotRedoException {
                    super.redo();
                    HomeController.this.home.setSelectedItems(arrayList);
                }

                public String getPresentationName() {
                    return HomeController.this.preferences.getLocalizedString(HomeController.class, "undoDropName", new Object[0]);
                }
            });
        }
        undoableEditSupport.endUpdate();
    }

    public void pasteToGroup() {
        UndoableEditSupport undoableEditSupport = this.getUndoableEditSupport();
        undoableEditSupport.beginUpdate();
        List<HomePieceOfFurniture> list = Home.getFurnitureSubList(this.getView().getClipboardItems());
        this.adjustFurnitureSizeAndElevation(list, true);
        this.getFurnitureController().addFurnitureToGroup(list, (HomeFurnitureGroup)this.home.getSelectedItems().get(0));
        undoableEditSupport.postEdit(new AbstractUndoableEdit(){

            public String getPresentationName() {
                return HomeController.this.preferences.getLocalizedString(HomeController.class, "undoPasteToGroupName", new Object[0]);
            }
        });
        undoableEditSupport.endUpdate();
    }

    public void pasteStyle() {
        UndoableEditSupport undoableEditSupport = this.getUndoableEditSupport();
        undoableEditSupport.beginUpdate();
        Selectable selectable = this.getView().getClipboardItems().get(0);
        final List<Selectable> list = this.home.getSelectedItems();
        if (selectable instanceof HomePieceOfFurniture) {
            HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)selectable;
            HomeFurnitureController homeFurnitureController = new HomeFurnitureController(this.home, this.preferences, this.viewFactory, this.contentManager, undoableEditSupport);
            HomeMaterial[] homeMaterialArray = homePieceOfFurniture.getModelMaterials();
            if (homeMaterialArray != null) {
                homeFurnitureController.getModelMaterialsController().setMaterials(homePieceOfFurniture.getModelMaterials());
                homeFurnitureController.setPaint(HomeFurnitureController.FurniturePaint.MODEL_MATERIALS);
            } else if (homePieceOfFurniture.getTexture() != null) {
                homeFurnitureController.getTextureController().setTexture(homePieceOfFurniture.getTexture());
                homeFurnitureController.setPaint(HomeFurnitureController.FurniturePaint.TEXTURED);
            } else if (homePieceOfFurniture.getColor() != null) {
                homeFurnitureController.setColor(homePieceOfFurniture.getColor());
                homeFurnitureController.setPaint(HomeFurnitureController.FurniturePaint.COLORED);
            } else {
                homeFurnitureController.setPaint(HomeFurnitureController.FurniturePaint.DEFAULT);
            }
            Float f = homePieceOfFurniture.getShininess();
            homeFurnitureController.setShininess(f == null ? HomeFurnitureController.FurnitureShininess.DEFAULT : (f.floatValue() == 0.0f ? HomeFurnitureController.FurnitureShininess.MATT : HomeFurnitureController.FurnitureShininess.SHINY));
            homeFurnitureController.modifyFurniture();
        } else if (selectable instanceof Wall) {
            Wall wall = (Wall)selectable;
            WallController wallController = new WallController(this.home, this.preferences, this.viewFactory, this.contentManager, undoableEditSupport);
            if (wall.getLeftSideColor() != null) {
                wallController.setLeftSideColor(wall.getLeftSideColor());
                wallController.setLeftSidePaint(WallController.WallPaint.COLORED);
            } else if (wall.getLeftSideTexture() != null) {
                wallController.getLeftSideTextureController().setTexture(wall.getLeftSideTexture());
                wallController.setLeftSidePaint(WallController.WallPaint.TEXTURED);
            } else {
                wallController.setLeftSidePaint(WallController.WallPaint.DEFAULT);
            }
            wallController.setLeftSideShininess(Float.valueOf(wall.getLeftSideShininess()));
            wallController.getLeftSideBaseboardController().setBaseboard(wall.getLeftSideBaseboard());
            if (wall.getRightSideColor() != null) {
                wallController.setRightSideColor(wall.getRightSideColor());
                wallController.setRightSidePaint(WallController.WallPaint.COLORED);
            } else if (wall.getRightSideTexture() != null) {
                wallController.getRightSideTextureController().setTexture(wall.getRightSideTexture());
                wallController.setRightSidePaint(WallController.WallPaint.TEXTURED);
            } else {
                wallController.setRightSidePaint(WallController.WallPaint.DEFAULT);
            }
            wallController.setRightSideShininess(Float.valueOf(wall.getRightSideShininess()));
            wallController.getRightSideBaseboardController().setBaseboard(wall.getRightSideBaseboard());
            wallController.setPattern(wall.getPattern());
            wallController.setTopColor(wall.getTopColor());
            wallController.setTopPaint(wall.getTopColor() != null ? WallController.WallPaint.COLORED : WallController.WallPaint.DEFAULT);
            wallController.modifyWalls();
        } else if (selectable instanceof Room) {
            Room room = (Room)selectable;
            RoomController roomController = new RoomController(this.home, this.preferences, this.viewFactory, this.contentManager, undoableEditSupport);
            if (room.getFloorColor() != null) {
                roomController.setFloorColor(room.getFloorColor());
                roomController.setFloorPaint(RoomController.RoomPaint.COLORED);
            } else if (room.getFloorTexture() != null) {
                roomController.getFloorTextureController().setTexture(room.getFloorTexture());
                roomController.setFloorPaint(RoomController.RoomPaint.TEXTURED);
            } else {
                roomController.setFloorPaint(RoomController.RoomPaint.DEFAULT);
            }
            roomController.setFloorShininess(Float.valueOf(room.getFloorShininess()));
            if (room.getCeilingColor() != null) {
                roomController.setCeilingColor(room.getCeilingColor());
                roomController.setCeilingPaint(RoomController.RoomPaint.COLORED);
            } else if (room.getCeilingTexture() != null) {
                roomController.getCeilingTextureController().setTexture(room.getCeilingTexture());
                roomController.setCeilingPaint(RoomController.RoomPaint.TEXTURED);
            } else {
                roomController.setCeilingPaint(RoomController.RoomPaint.DEFAULT);
            }
            roomController.setCeilingShininess(Float.valueOf(room.getCeilingShininess()));
            roomController.modifyRooms();
        } else if (selectable instanceof Polyline) {
            Polyline polyline = (Polyline)selectable;
            PolylineController polylineController = new PolylineController(this.home, this.preferences, this.viewFactory, this.contentManager, undoableEditSupport);
            polylineController.setThickness(Float.valueOf(polyline.getThickness()));
            polylineController.setJoinStyle(polyline.getJoinStyle());
            polylineController.setCapStyle(polyline.getCapStyle());
            polylineController.setStartArrowStyle(polyline.getStartArrowStyle());
            polylineController.setEndArrowStyle(polyline.getEndArrowStyle());
            polylineController.setDashStyle(polyline.getDashStyle());
            polylineController.setColor(polyline.getColor());
            polylineController.modifyPolylines();
        } else if (selectable instanceof Label) {
            Label label = (Label)selectable;
            LabelController labelController = new LabelController(this.home, this.preferences, this.viewFactory, undoableEditSupport);
            labelController.setColor(label.getColor());
            TextStyle textStyle = label.getStyle();
            if (textStyle != null) {
                labelController.setFontName(textStyle.getFontName());
                labelController.setFontSize(Float.valueOf(textStyle.getFontSize()));
            } else {
                labelController.setFontName(null);
                labelController.setFontSize(Float.valueOf(this.preferences.getDefaultTextStyle(Label.class).getFontSize()));
            }
            labelController.modifyLabels();
        }
        undoableEditSupport.postEdit(new AbstractUndoableEdit(){

            public void redo() throws CannotRedoException {
                HomeController.this.home.setSelectedItems(list);
                super.redo();
            }

            public String getPresentationName() {
                return HomeController.this.preferences.getLocalizedString(HomeController.class, "undoPasteStyleName", new Object[0]);
            }
        });
        undoableEditSupport.endUpdate();
    }

    public void delete() {
        if (this.focusedView == this.getFurnitureCatalogController().getView()) {
            if (this.getView().confirmDeleteCatalogSelection()) {
                this.getFurnitureCatalogController().deleteSelection();
            }
        } else if (this.focusedView == this.getFurnitureController().getView()) {
            this.getFurnitureController().deleteSelection();
        } else if (this.focusedView == this.getPlanController().getView()) {
            this.getPlanController().deleteSelection();
        }
    }

    public void focusedViewChanged(View view) {
        this.focusedView = view;
        this.enableActionsBoundToSelection();
        this.enablePasteAction();
        this.enablePasteToGroupAction();
        this.enablePasteStyleAction();
        this.enableSelectAllAction();
    }

    public void selectAll() {
        if (this.focusedView == this.getFurnitureController().getView()) {
            this.getFurnitureController().selectAll();
        } else if (this.focusedView == this.getPlanController().getView() || this.focusedView == this.getHomeController3D().getView()) {
            this.getPlanController().selectAll();
        }
    }

    public void newHome() {
        Home home = this.application != null ? this.application.createHome() : new Home(this.preferences.getNewWallHeight());
        this.application.addHome(home);
    }

    public void open() {
        this.getView().invokeLater(new Runnable(){

            public void run() {
                String string = HomeController.this.getView().showOpenDialog();
                if (string != null) {
                    HomeController.this.open(string);
                }
            }
        });
    }

    public void open(final String string) {
        for (Home object2 : this.application.getHomes()) {
            if (!string.equals(object2.getName())) continue;
            String string2 = this.preferences.getLocalizedString(HomeController.class, "alreadyOpen", string);
            this.getView().showMessage(string2);
            return;
        }
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws RecorderException {
                Home home = HomeController.this.application.getHomeRecorder().readHome(string);
                home.setName(string);
                HomeController.this.addHomeToApplication(home);
                if (home.isRepaired()) {
                    HomeController.this.getView().invokeLater(new Runnable(){

                        public void run() {
                            String string = HomeController.this.preferences.getLocalizedString(HomeController.class, "openRepairedHomeMessage", string);
                            HomeController.this.getView().showMessage(string);
                        }
                    });
                }
                return null;
            }
        };
        ThreadedTaskController.ExceptionHandler exceptionHandler = new ThreadedTaskController.ExceptionHandler(){

            public void handleException(Exception exception) {
                if (!(exception instanceof InterruptedRecorderException)) {
                    if (exception instanceof DamagedHomeRecorderException) {
                        DamagedHomeRecorderException damagedHomeRecorderException = (DamagedHomeRecorderException)exception;
                        HomeController.this.openDamagedHome(string, damagedHomeRecorderException.getDamagedHome(), damagedHomeRecorderException.getInvalidContent());
                    } else if (exception instanceof RecorderException) {
                        String string2 = HomeController.this.preferences.getLocalizedString(HomeController.class, "openError", string);
                        HomeController.this.getView().showError(string2);
                    } else {
                        exception.printStackTrace();
                    }
                }
            }
        };
        new ThreadedTaskController(callable, this.preferences.getLocalizedString(HomeController.class, "openMessage", new Object[0]), exceptionHandler, this.preferences, this.viewFactory).executeTask(this.getView());
    }

    private void addHomeToApplication(final Home home) {
        this.getView().invokeLater(new Runnable(){

            public void run() {
                HomeController.this.application.addHome(home);
            }
        });
    }

    private void openDamagedHome(String string, Home home, List<Content> list) {
        HomeView.OpenDamagedHomeAnswer openDamagedHomeAnswer = this.getView().confirmOpenDamagedHome(string, home, list);
        switch (openDamagedHomeAnswer) {
            case REMOVE_DAMAGED_ITEMS: {
                this.removeDamagedItems(home, list);
                break;
            }
            case REPLACE_DAMAGED_ITEMS: {
                this.replaceDamagedItems(home, list);
            }
        }
        if (openDamagedHomeAnswer != HomeView.OpenDamagedHomeAnswer.DO_NOT_OPEN_HOME) {
            home.setName(string);
            home.setRepaired(true);
            this.addHomeToApplication(home);
        }
    }

    private void removeDamagedItems(Home home, List<Content> list) {
        BackgroundImage backgroundImage;
        for (HomePieceOfFurniture serializable2 : home.getFurniture()) {
            if (this.referencesInvalidContent(serializable2, list)) {
                home.deletePieceOfFurniture(serializable2);
                continue;
            }
            this.removeInvalidTextures(serializable2, list);
        }
        for (Wall wall : home.getWalls()) {
            if (this.referencesInvalidContent(wall.getLeftSideTexture(), list)) {
                wall.setLeftSideTexture(null);
            }
            if (!this.referencesInvalidContent(wall.getRightSideTexture(), list)) continue;
            wall.setRightSideTexture(null);
        }
        for (Room room : home.getRooms()) {
            if (this.referencesInvalidContent(room.getFloorTexture(), list)) {
                room.setFloorTexture(null);
            }
            if (!this.referencesInvalidContent(room.getCeilingTexture(), list)) continue;
            room.setCeilingTexture(null);
        }
        HomeEnvironment homeEnvironment = home.getEnvironment();
        if (this.referencesInvalidContent(homeEnvironment.getGroundTexture(), list)) {
            homeEnvironment.setGroundTexture(null);
        }
        if (this.referencesInvalidContent(homeEnvironment.getSkyTexture(), list)) {
            homeEnvironment.setSkyTexture(null);
        }
        if ((backgroundImage = home.getBackgroundImage()) != null && list.contains(backgroundImage)) {
            home.setBackgroundImage(null);
        }
        for (Level level : home.getLevels()) {
            BackgroundImage backgroundImage2 = level.getBackgroundImage();
            if (backgroundImage2 == null || !list.contains(backgroundImage2)) continue;
            level.setBackgroundImage(null);
        }
    }

    private boolean referencesInvalidContent(HomePieceOfFurniture homePieceOfFurniture, List<Content> list) {
        if (list.contains(homePieceOfFurniture.getIcon()) || list.contains(homePieceOfFurniture.getPlanIcon()) || list.contains(homePieceOfFurniture.getModel())) {
            return true;
        }
        if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
            for (HomePieceOfFurniture homePieceOfFurniture2 : ((HomeFurnitureGroup)homePieceOfFurniture).getFurniture()) {
                if (!this.referencesInvalidContent(homePieceOfFurniture2, list)) continue;
                return true;
            }
        }
        return false;
    }

    private void removeInvalidTextures(HomePieceOfFurniture homePieceOfFurniture, List<Content> list) {
        HomeMaterial[] homeMaterialArray;
        if (this.referencesInvalidContent(homePieceOfFurniture.getTexture(), list)) {
            homePieceOfFurniture.setTexture(null);
        }
        if ((homeMaterialArray = homePieceOfFurniture.getModelMaterials()) != null) {
            for (int i = 0; i < homeMaterialArray.length; ++i) {
                if (homeMaterialArray[i] != null && this.referencesInvalidContent(homeMaterialArray[i].getTexture(), list)) {
                    homeMaterialArray[i] = null;
                }
                homePieceOfFurniture.setModelMaterials(homeMaterialArray);
            }
        }
        if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
            for (HomePieceOfFurniture homePieceOfFurniture2 : ((HomeFurnitureGroup)homePieceOfFurniture).getFurniture()) {
                this.removeInvalidTextures(homePieceOfFurniture2, list);
            }
        }
    }

    private boolean referencesInvalidContent(TextureImage textureImage, List<Content> list) {
        return textureImage != null && list.contains(textureImage.getImage());
    }

    private void replaceDamagedItems(Home home, List<Content> list) {
        BackgroundImage backgroundImage;
        List<HomePieceOfFurniture> list2 = home.getFurniture();
        for (int i = list2.size() - 1; i >= 0; --i) {
            HomePieceOfFurniture serializable2 = list2.get(i);
            if (this.referencesInvalidContent(serializable2, list)) {
                HomePieceOfFurniture homePieceOfFurniture = this.getFurnitureController().createHomePieceOfFurniture(new CatalogPieceOfFurniture(serializable2.getCatalogId(), serializable2.getName(), serializable2.getDescription(), REPAIRED_ICON_CONTENT, REPAIRED_IMAGE_CONTENT, REPAIRED_MODEL_CONTENT, serializable2.getWidth(), serializable2.getDepth(), serializable2.getHeight(), serializable2.getElevation(), serializable2.isMovable(), serializable2.getStaircaseCutOutShape(), null, serializable2.getCreator(), serializable2.isResizable(), serializable2.isDeformable(), serializable2.isTexturable(), serializable2.getPrice(), serializable2.getValueAddedTaxPercentage(), serializable2.getCurrency()));
                homePieceOfFurniture.setNameVisible(serializable2.isNameVisible());
                homePieceOfFurniture.setNameXOffset(serializable2.getNameXOffset());
                homePieceOfFurniture.setNameYOffset(serializable2.getNameYOffset());
                homePieceOfFurniture.setNameStyle(serializable2.getNameStyle());
                homePieceOfFurniture.setVisible(serializable2.isVisible());
                homePieceOfFurniture.setAngle(serializable2.getAngle());
                homePieceOfFurniture.setX(serializable2.getX());
                homePieceOfFurniture.setY(serializable2.getY());
                home.addPieceOfFurniture(homePieceOfFurniture, i);
                homePieceOfFurniture.setLevel(serializable2.getLevel());
                home.deletePieceOfFurniture(serializable2);
                continue;
            }
            this.replaceInvalidTextures(serializable2, list);
        }
        for (Wall wall : home.getWalls()) {
            if (this.referencesInvalidContent(wall.getLeftSideTexture(), list)) {
                wall.setLeftSideTexture(this.getErrorTexture(wall.getLeftSideTexture()));
            }
            if (!this.referencesInvalidContent(wall.getRightSideTexture(), list)) continue;
            wall.setRightSideTexture(this.getErrorTexture(wall.getRightSideTexture()));
        }
        for (Room room : home.getRooms()) {
            if (this.referencesInvalidContent(room.getFloorTexture(), list)) {
                room.setFloorTexture(this.getErrorTexture(room.getFloorTexture()));
            }
            if (!this.referencesInvalidContent(room.getCeilingTexture(), list)) continue;
            room.setCeilingTexture(this.getErrorTexture(room.getCeilingTexture()));
        }
        HomeEnvironment homeEnvironment = home.getEnvironment();
        if (this.referencesInvalidContent(homeEnvironment.getGroundTexture(), list)) {
            homeEnvironment.setGroundTexture(this.getErrorTexture(homeEnvironment.getGroundTexture()));
        }
        if (this.referencesInvalidContent(homeEnvironment.getSkyTexture(), list)) {
            homeEnvironment.setSkyTexture(this.getErrorTexture(homeEnvironment.getSkyTexture()));
        }
        if ((backgroundImage = home.getBackgroundImage()) != null && list.contains(backgroundImage)) {
            home.setBackgroundImage(this.getErrorBackgroundImage(backgroundImage));
        }
        for (Level level : home.getLevels()) {
            BackgroundImage backgroundImage2 = level.getBackgroundImage();
            if (backgroundImage2 == null || !list.contains(backgroundImage2)) continue;
            level.setBackgroundImage(this.getErrorBackgroundImage(backgroundImage2));
        }
    }

    private void replaceInvalidTextures(HomePieceOfFurniture homePieceOfFurniture, List<Content> list) {
        HomeMaterial[] homeMaterialArray;
        if (this.referencesInvalidContent(homePieceOfFurniture.getTexture(), list)) {
            homePieceOfFurniture.setTexture(this.getErrorTexture(homePieceOfFurniture.getTexture()));
        }
        if ((homeMaterialArray = homePieceOfFurniture.getModelMaterials()) != null) {
            for (int i = 0; i < homeMaterialArray.length; ++i) {
                HomeMaterial serializable = homeMaterialArray[i];
                if (serializable != null && this.referencesInvalidContent(serializable.getTexture(), list)) {
                    homeMaterialArray[i] = new HomeMaterial(serializable.getName(), serializable.getColor(), this.getErrorTexture(serializable.getTexture()), serializable.getShininess());
                }
                homePieceOfFurniture.setModelMaterials(homeMaterialArray);
            }
        }
        if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
            for (HomePieceOfFurniture homePieceOfFurniture2 : ((HomeFurnitureGroup)homePieceOfFurniture).getFurniture()) {
                this.replaceInvalidTextures(homePieceOfFurniture2, list);
            }
        }
    }

    private HomeTexture getErrorTexture(HomeTexture homeTexture) {
        return new HomeTexture(new CatalogTexture(homeTexture.getName(), REPAIRED_IMAGE_CONTENT, homeTexture.getWidth(), homeTexture.getHeight()));
    }

    private BackgroundImage getErrorBackgroundImage(BackgroundImage backgroundImage) {
        return new BackgroundImage(REPAIRED_IMAGE_CONTENT, backgroundImage.getScaleDistance(), backgroundImage.getScaleDistanceXStart(), backgroundImage.getScaleDistanceYStart(), backgroundImage.getScaleDistanceXEnd(), backgroundImage.getScaleDistanceYEnd(), backgroundImage.getXOrigin(), backgroundImage.getYOrigin(), backgroundImage.isVisible());
    }

    private void updateUserPreferencesRecentHomes(List<String> list) {
        if (this.application != null) {
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                try {
                    if (this.application.getHomeRecorder().exists(iterator.next())) continue;
                    iterator.remove();
                }
                catch (RecorderException recorderException) {}
            }
            this.preferences.setRecentHomes(list);
        }
    }

    public List<String> getRecentHomes() {
        if (this.application != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : this.preferences.getRecentHomes()) {
                try {
                    if (!this.application.getHomeRecorder().exists(string)) continue;
                    arrayList.add(string);
                    if (arrayList.size() != this.preferences.getRecentHomesMaxCount()) continue;
                    break;
                }
                catch (RecorderException recorderException) {
                }
            }
            this.getView().setEnabled(HomeView.ActionType.DELETE_RECENT_HOMES, !arrayList.isEmpty());
            return Collections.unmodifiableList(arrayList);
        }
        return new ArrayList<String>();
    }

    public String getVersion() {
        if (this.application != null) {
            String string = this.application.getVersion();
            try {
                String string2 = System.getProperty("com.eteks.sweethome3d.deploymentInformation");
                if (string2 != null) {
                    string = string + " " + string2;
                }
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
            return string;
        }
        return "";
    }

    public void deleteRecentHomes() {
        this.updateUserPreferencesRecentHomes(new ArrayList<String>());
        this.getView().setEnabled(HomeView.ActionType.DELETE_RECENT_HOMES, false);
    }

    public void close() {
        this.close(null);
    }

    public void close(final Runnable runnable) {
        Runnable runnable2 = new Runnable(){

            public void run() {
                HomeController.this.home.setRecovered(false);
                HomeController.this.application.deleteHome(HomeController.this.home);
                if (runnable != null) {
                    runnable.run();
                }
            }
        };
        if (this.home.isModified() || this.home.isRecovered() || this.home.isRepaired()) {
            switch (this.getView().confirmSave(this.home.getName())) {
                case SAVE: {
                    this.save(HomeRecorder.Type.DEFAULT, runnable2);
                }
                case CANCEL: {
                    return;
                }
            }
        }
        runnable2.run();
    }

    public void save() {
        this.save(HomeRecorder.Type.DEFAULT, null);
    }

    private void save(HomeRecorder.Type type, Runnable runnable) {
        if (this.home.getName() == null || this.home.isRepaired()) {
            this.saveAs(type, runnable);
        } else {
            this.save(this.home.getName(), type, runnable);
        }
    }

    public void saveAs() {
        this.saveAs(HomeRecorder.Type.DEFAULT, null);
    }

    protected void saveAs(HomeRecorder.Type type, Runnable runnable) {
        String string = this.getView().showSaveDialog(this.home.getName());
        if (string != null) {
            this.save(string, type, runnable);
        }
    }

    public void saveAndCompress() {
        this.save(HomeRecorder.Type.COMPRESSED, null);
    }

    public void saveAsAndCompress() {
        this.saveAs(HomeRecorder.Type.COMPRESSED, null);
    }

    private void save(final String string, final HomeRecorder.Type type, final Runnable runnable) {
        if (this.home.getVersion() <= 5200L || !string.equals(this.home.getName()) || this.getView().confirmSaveNewerHome(string)) {
            Home home;
            try {
                home = this.home.clone();
            }
            catch (RuntimeException runtimeException) {
                this.getView().showError(this.preferences.getLocalizedString(HomeController.class, "saveError", string, runtimeException));
                throw runtimeException;
            }
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws RecorderException {
                    HomeController.this.application.getHomeRecorder(type).writeHome(home, string);
                    HomeController.this.updateSavedHome(string, home.getVersion(), runnable);
                    return null;
                }
            };
            ThreadedTaskController.ExceptionHandler exceptionHandler = new ThreadedTaskController.ExceptionHandler(){

                public void handleException(Exception exception) {
                    if (!(exception instanceof InterruptedRecorderException)) {
                        String string3 = exception.toString();
                        if (exception instanceof NotEnoughSpaceRecorderException) {
                            long l = ((NotEnoughSpaceRecorderException)exception).getMissingSpace();
                            float f = Math.max(0.1f, (float)l / 1048576.0f);
                            string3 = "Missing " + new DecimalFormat("#.#").format(f) + " MB to save home";
                        } else if (exception instanceof RecorderException) {
                            string3 = "RecorderException";
                            String string2 = exception.getMessage();
                            if (string2 != null) {
                                string3 = string3 + ": " + string2;
                            }
                            if (exception.getCause() != null) {
                                string3 = string3 + "<br>" + exception.getCause();
                            }
                        }
                        exception.printStackTrace();
                        HomeController.this.getView().showError(HomeController.this.preferences.getLocalizedString(HomeController.class, "saveError", string, string3));
                    }
                }
            };
            new ThreadedTaskController(callable, this.preferences.getLocalizedString(HomeController.class, "saveMessage", new Object[0]), exceptionHandler, this.preferences, this.viewFactory).executeTask(this.getView());
        }
    }

    private void updateSavedHome(final String string, final long l, final Runnable runnable) {
        this.getView().invokeLater(new Runnable(){

            public void run() {
                HomeController.this.home.setName(string);
                HomeController.this.home.setModified(false);
                HomeController.this.home.setRecovered(false);
                HomeController.this.home.setRepaired(false);
                HomeController.this.home.setVersion(l);
                ArrayList<String> arrayList = new ArrayList<String>(HomeController.this.preferences.getRecentHomes());
                int n = arrayList.indexOf(string);
                if (n >= 0) {
                    arrayList.remove(n);
                }
                arrayList.add(0, string);
                HomeController.this.updateUserPreferencesRecentHomes(arrayList);
                if (runnable != null) {
                    runnable.run();
                }
            }
        });
    }

    public void exportToCSV() {
        final String string = this.getView().showExportToCSVDialog(this.home.getName());
        if (string != null) {
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws RecorderException {
                    HomeController.this.getView().exportToCSV(string);
                    return null;
                }
            };
            ThreadedTaskController.ExceptionHandler exceptionHandler = new ThreadedTaskController.ExceptionHandler(){

                public void handleException(Exception exception) {
                    if (!(exception instanceof InterruptedRecorderException)) {
                        if (exception instanceof RecorderException) {
                            String string2 = HomeController.this.preferences.getLocalizedString(HomeController.class, "exportToCSVError", string);
                            HomeController.this.getView().showError(string2);
                        } else {
                            exception.printStackTrace();
                        }
                    }
                }
            };
            new ThreadedTaskController(callable, this.preferences.getLocalizedString(HomeController.class, "exportToCSVMessage", new Object[0]), exceptionHandler, this.preferences, this.viewFactory).executeTask(this.getView());
        }
    }

    public void exportToSVG() {
        final String string = this.getView().showExportToSVGDialog(this.home.getName());
        if (string != null) {
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws RecorderException {
                    HomeController.this.getView().exportToSVG(string);
                    return null;
                }
            };
            ThreadedTaskController.ExceptionHandler exceptionHandler = new ThreadedTaskController.ExceptionHandler(){

                public void handleException(Exception exception) {
                    if (!(exception instanceof InterruptedRecorderException)) {
                        if (exception instanceof RecorderException) {
                            String string2 = HomeController.this.preferences.getLocalizedString(HomeController.class, "exportToSVGError", string);
                            HomeController.this.getView().showError(string2);
                        } else {
                            exception.printStackTrace();
                        }
                    }
                }
            };
            new ThreadedTaskController(callable, this.preferences.getLocalizedString(HomeController.class, "exportToSVGMessage", new Object[0]), exceptionHandler, this.preferences, this.viewFactory).executeTask(this.getView());
        }
    }

    public void exportToOBJ() {
        final String string = this.getView().showExportToOBJDialog(this.home.getName());
        if (string != null) {
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws RecorderException {
                    HomeController.this.getView().exportToOBJ(string);
                    return null;
                }
            };
            ThreadedTaskController.ExceptionHandler exceptionHandler = new ThreadedTaskController.ExceptionHandler(){

                public void handleException(Exception exception) {
                    if (!(exception instanceof InterruptedRecorderException)) {
                        if (exception instanceof RecorderException) {
                            String string2 = HomeController.this.preferences.getLocalizedString(HomeController.class, "exportToOBJError", string);
                            HomeController.this.getView().showError(string2);
                        } else {
                            exception.printStackTrace();
                        }
                    }
                }
            };
            new ThreadedTaskController(callable, this.preferences.getLocalizedString(HomeController.class, "exportToOBJMessage", new Object[0]), exceptionHandler, this.preferences, this.viewFactory).executeTask(this.getView());
        }
    }

    public void createPhotos() {
        PhotosController photosController = new PhotosController(this.home, this.preferences, this.getHomeController3D().getView(), this.viewFactory, this.contentManager);
        photosController.displayView(this.getView());
    }

    public void createPhoto() {
        PhotoController photoController = new PhotoController(this.home, this.preferences, this.getHomeController3D().getView(), this.viewFactory, this.contentManager);
        photoController.displayView(this.getView());
    }

    public void createVideo() {
        this.getPlanController().setMode(PlanController.Mode.SELECTION);
        this.getHomeController3D().viewFromObserver();
        VideoController videoController = new VideoController(this.home, this.preferences, this.viewFactory, this.contentManager);
        videoController.displayView(this.getView());
    }

    public void setupPage() {
        new PageSetupController(this.home, this.preferences, this.viewFactory, this.getUndoableEditSupport()).displayView(this.getView());
    }

    public void previewPrint() {
        new PrintPreviewController(this.home, this.preferences, this, this.viewFactory).displayView(this.getView());
    }

    public void print() {
        Callable<Void> callable = this.getView().showPrintDialog();
        if (callable != null) {
            ThreadedTaskController.ExceptionHandler exceptionHandler = new ThreadedTaskController.ExceptionHandler(){

                public void handleException(Exception exception) {
                    if (!(exception instanceof InterruptedRecorderException)) {
                        if (exception instanceof RecorderException) {
                            String string = HomeController.this.preferences.getLocalizedString(HomeController.class, "printError", HomeController.this.home.getName());
                            HomeController.this.getView().showError(string);
                        } else {
                            exception.printStackTrace();
                        }
                    }
                }
            };
            new ThreadedTaskController(callable, this.preferences.getLocalizedString(HomeController.class, "printMessage", new Object[0]), exceptionHandler, this.preferences, this.viewFactory).executeTask(this.getView());
        }
    }

    public void printToPDF() {
        final String string = this.getView().showPrintToPDFDialog(this.home.getName());
        if (string != null) {
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws RecorderException {
                    HomeController.this.getView().printToPDF(string);
                    return null;
                }
            };
            ThreadedTaskController.ExceptionHandler exceptionHandler = new ThreadedTaskController.ExceptionHandler(){

                public void handleException(Exception exception) {
                    if (!(exception instanceof InterruptedRecorderException)) {
                        if (exception instanceof RecorderException) {
                            String string2 = HomeController.this.preferences.getLocalizedString(HomeController.class, "printToPDFError", string);
                            HomeController.this.getView().showError(string2);
                        } else {
                            exception.printStackTrace();
                        }
                    }
                }
            };
            new ThreadedTaskController(callable, this.preferences.getLocalizedString(HomeController.class, "printToPDFMessage", new Object[0]), exceptionHandler, this.preferences, this.viewFactory).executeTask(this.getView());
        }
    }

    public void exit() {
        for (Home home : this.application.getHomes()) {
            if (!home.isModified() && !home.isRecovered() && !home.isRepaired()) continue;
            if (this.getView().confirmExit()) break;
            return;
        }
        for (Home home : this.application.getHomes()) {
            home.setRecovered(false);
            this.application.deleteHome(home);
        }
    }

    public void editPreferences() {
        new UserPreferencesController(this.preferences, this.viewFactory, this.contentManager, this).displayView(this.getView());
    }

    public void setMode(PlanController.Mode mode) {
        if (this.getPlanController().getMode() != mode) {
            final String string = mode == PlanController.Mode.WALL_CREATION ? HomeView.ActionType.CREATE_WALLS.name() : (mode == PlanController.Mode.ROOM_CREATION ? HomeView.ActionType.CREATE_ROOMS.name() : (mode == PlanController.Mode.POLYLINE_CREATION ? HomeView.ActionType.CREATE_POLYLINES.name() : (mode == PlanController.Mode.DIMENSION_LINE_CREATION ? HomeView.ActionType.CREATE_DIMENSION_LINES.name() : (mode == PlanController.Mode.LABEL_CREATION ? HomeView.ActionType.CREATE_LABELS.name() : null))));
            if (string != null && !this.preferences.isActionTipIgnored(string)) {
                this.getView().invokeLater(new Runnable(){

                    public void run() {
                        if (HomeController.this.getView().showActionTipMessage(string)) {
                            HomeController.this.preferences.setActionTipIgnored(string);
                        }
                    }
                });
            }
            this.getPlanController().setMode(mode);
        }
    }

    public void importBackgroundImage() {
        new BackgroundImageWizardController(this.home, this.preferences, this.viewFactory, this.contentManager, this.getUndoableEditSupport()).displayView(this.getView());
    }

    public void modifyBackgroundImage() {
        this.importBackgroundImage();
    }

    public void hideBackgroundImage() {
        this.toggleBackgroundImageVisibility("undoHideBackgroundImageName");
    }

    public void showBackgroundImage() {
        this.toggleBackgroundImageVisibility("undoShowBackgroundImageName");
    }

    private void toggleBackgroundImageVisibility(final String string) {
        final Level level = this.home.getSelectedLevel();
        this.doToggleBackgroundImageVisibility();
        AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

            public void undo() throws CannotUndoException {
                super.undo();
                HomeController.this.home.setSelectedLevel(level);
                HomeController.this.doToggleBackgroundImageVisibility();
            }

            public void redo() throws CannotRedoException {
                super.redo();
                HomeController.this.home.setSelectedLevel(level);
                HomeController.this.doToggleBackgroundImageVisibility();
            }

            public String getPresentationName() {
                return HomeController.this.preferences.getLocalizedString(HomeController.class, string, new Object[0]);
            }
        };
        this.getUndoableEditSupport().postEdit(abstractUndoableEdit);
    }

    private void doToggleBackgroundImageVisibility() {
        BackgroundImage backgroundImage = this.home.getSelectedLevel() != null ? this.home.getSelectedLevel().getBackgroundImage() : this.home.getBackgroundImage();
        backgroundImage = new BackgroundImage(backgroundImage.getImage(), backgroundImage.getScaleDistance(), backgroundImage.getScaleDistanceXStart(), backgroundImage.getScaleDistanceYStart(), backgroundImage.getScaleDistanceXEnd(), backgroundImage.getScaleDistanceYEnd(), backgroundImage.getXOrigin(), backgroundImage.getYOrigin(), !backgroundImage.isVisible());
        if (this.home.getSelectedLevel() != null) {
            this.home.getSelectedLevel().setBackgroundImage(backgroundImage);
        } else {
            this.home.setBackgroundImage(backgroundImage);
        }
    }

    public void deleteBackgroundImage() {
        BackgroundImage backgroundImage;
        final Level level = this.home.getSelectedLevel();
        if (level != null) {
            backgroundImage = level.getBackgroundImage();
            level.setBackgroundImage(null);
        } else {
            backgroundImage = this.home.getBackgroundImage();
            this.home.setBackgroundImage(null);
        }
        AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

            public void undo() throws CannotUndoException {
                super.undo();
                HomeController.this.home.setSelectedLevel(level);
                if (level != null) {
                    level.setBackgroundImage(backgroundImage);
                } else {
                    HomeController.this.home.setBackgroundImage(backgroundImage);
                }
            }

            public void redo() throws CannotRedoException {
                super.redo();
                HomeController.this.home.setSelectedLevel(level);
                if (level != null) {
                    level.setBackgroundImage(null);
                } else {
                    HomeController.this.home.setBackgroundImage(null);
                }
            }

            public String getPresentationName() {
                return HomeController.this.preferences.getLocalizedString(HomeController.class, "undoDeleteBackgroundImageName", new Object[0]);
            }
        };
        this.getUndoableEditSupport().postEdit(abstractUndoableEdit);
    }

    public void zoomOut() {
        PlanController planController = this.getPlanController();
        float f = planController.getScale() / 1.5f;
        planController.setScale(f);
    }

    public void zoomIn() {
        PlanController planController = this.getPlanController();
        float f = planController.getScale() * 1.5f;
        planController.setScale(f);
    }

    public void storeCamera() {
        String string = DateFormat.getDateTimeInstance(3, 2).format(new Date());
        String string2 = this.getView().showStoreCameraDialog(string);
        if (string2 != null) {
            this.getHomeController3D().storeCamera(string2);
        }
    }

    public void deleteCameras() {
        List<Camera> list = this.getView().showDeletedCamerasDialog();
        if (list != null) {
            this.getHomeController3D().deleteCameras(list);
        }
    }

    public void detachView(View view) {
        if (view != null) {
            this.getView().detachView(view);
            this.notUndoableModifications = true;
            this.home.setModified(true);
        }
    }

    public void attachView(View view) {
        if (view != null) {
            this.getView().attachView(view);
            this.notUndoableModifications = true;
            this.home.setModified(true);
        }
    }

    public void help() {
        if (helpController == null) {
            helpController = new HelpController(this.preferences, this.viewFactory);
        }
        helpController.displayView();
    }

    public void about() {
        this.getView().showAboutDialog();
    }

    public void setVisualProperty(String string, Object object) {
        this.home.setVisualProperty(string, object);
    }

    public void setHomeProperty(String string, String string2) {
        this.home.setProperty(string, string2);
    }

    public void checkUpdates(final boolean bl) {
        String string = this.getPropertyValue("com.eteks.sweethome3d.updatesUrl", "updatesUrl");
        if (string != null && string.length() > 0) {
            URL uRL;
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                return;
            }
            final List<Library> list = this.preferences.getLibraries();
            final Long l = bl ? this.preferences.getUpdatesMinimumDate() : null;
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws IOException, SAXException {
                    final Map map = HomeController.this.readAvailableUpdates(uRL, list, l, bl ? 3000 : -1);
                    HomeController.this.getView().invokeLater(new Runnable(){

                        public void run() {
                            if (map.isEmpty()) {
                                if (!bl) {
                                    HomeController.this.getView().showMessage(HomeController.this.preferences.getLocalizedString(HomeController.class, "noUpdateMessage", new Object[0]));
                                }
                            } else if (!HomeController.this.getView().showUpdatesMessage(HomeController.this.getUpdatesMessage(map), !bl)) {
                                long l = Long.MIN_VALUE;
                                for (List list : map.values()) {
                                    for (Update update : list) {
                                        l = Math.max(l, update.getDate().getTime());
                                    }
                                }
                                HomeController.this.preferences.setUpdatesMinimumDate(l + 1L);
                            }
                        }
                    });
                    return null;
                }
            };
            ThreadedTaskController.ExceptionHandler exceptionHandler = new ThreadedTaskController.ExceptionHandler(){

                public void handleException(Exception exception) {
                    if (!bl && !(exception instanceof InterruptedIOException)) {
                        if (exception instanceof IOException) {
                            HomeController.this.getView().showError(HomeController.this.preferences.getLocalizedString(HomeController.class, "checkUpdatesIOError", exception));
                        } else if (exception instanceof SAXException) {
                            HomeController.this.getView().showError(HomeController.this.preferences.getLocalizedString(HomeController.class, "checkUpdatesXMLError", exception.getMessage()));
                        } else {
                            exception.printStackTrace();
                        }
                    }
                }
            };
            ViewFactoryAdapter viewFactoryAdapter = new ViewFactoryAdapter(){

                public ThreadedTaskView createThreadedTaskView(String string, UserPreferences userPreferences, ThreadedTaskController threadedTaskController) {
                    return new ThreadedTaskView(){

                        public void setTaskRunning(boolean bl, View view) {
                        }

                        public void invokeLater(Runnable runnable) {
                            HomeController.this.getView().invokeLater(runnable);
                        }
                    };
                }
            };
            new ThreadedTaskController(callable, this.preferences.getLocalizedString(HomeController.class, "checkUpdatesMessage", new Object[0]), exceptionHandler, this.preferences, bl ? viewFactoryAdapter : this.viewFactory).executeTask(this.getView());
        }
    }

    private String getPropertyValue(String string, String string2) {
        String string3 = System.getProperty(string);
        if (string3 != null) {
            return string3;
        }
        try {
            return this.preferences.getLocalizedString(HomeController.class, string2, new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private Map<Library, List<Update>> readAvailableUpdates(URL uRL, List<Library> list, Long l, int n) throws IOException, SAXException {
        try {
            Object object;
            Object object2;
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            UpdatesHandler updatesHandler = new UpdatesHandler(uRL);
            URLConnection uRLConnection = uRL.openConnection();
            if (n > 0) {
                uRLConnection.setConnectTimeout(n);
                uRLConnection.setReadTimeout(n);
            }
            sAXParser.parse(uRLConnection.getInputStream(), (DefaultHandler)updatesHandler);
            LinkedHashMap<Library, List<Update>> linkedHashMap = new LinkedHashMap<Library, List<Update>>();
            long l2 = System.currentTimeMillis();
            if (this.application != null && !(object2 = this.getAvailableUpdates(updatesHandler.getUpdates((String)(object = this.application.getId())), this.application.getVersion(), l, l2)).isEmpty()) {
                linkedHashMap.put(null, (List<Update>)object2);
            }
            object = new HashSet();
            for (Library library : list) {
                if (Thread.interrupted()) {
                    throw new InterruptedIOException();
                }
                String string = library.getId();
                if (string == null || object.contains(string)) continue;
                List<Update> list2 = this.getAvailableUpdates(updatesHandler.getUpdates(string), library.getVersion(), l, l2);
                if (!list2.isEmpty()) {
                    linkedHashMap.put(library, list2);
                }
                object.add(string);
            }
            return linkedHashMap;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            if (sAXException.getCause() instanceof InterruptedIOException) {
                throw (InterruptedIOException)sAXException.getCause();
            }
            throw sAXException;
        }
    }

    private List<Update> getAvailableUpdates(List<Update> list, String string, Long l, long l2) {
        if (list != null) {
            boolean bl = false;
            ArrayList<Update> arrayList = new ArrayList<Update>();
            for (Update update : list) {
                Date date;
                String string2 = update.getMinVersion();
                String string3 = update.getMaxVersion();
                String string4 = update.getOperatingSystem();
                if (OperatingSystem.compareVersions(string, update.getVersion()) >= 0 || string2 != null && OperatingSystem.compareVersions(string2, string) > 0 || string3 != null && OperatingSystem.compareVersions(string, string3) >= 0 || string4 != null && !System.getProperty("os.name").matches(string4) || (date = update.getDate()) != null && (l != null && date.getTime() < l || date.getTime() >= l2)) continue;
                arrayList.add(update);
                bl = true;
            }
            if (bl) {
                Collections.sort(arrayList, new Comparator<Update>(){

                    @Override
                    public int compare(Update update, Update update2) {
                        return -OperatingSystem.compareVersions(update.getVersion(), update2.getVersion());
                    }
                });
                return arrayList;
            }
        }
        return Collections.emptyList();
    }

    private String getUpdatesMessage(Map<Library, List<Update>> map) {
        if (map.isEmpty()) {
            return this.preferences.getLocalizedString(HomeController.class, "noUpdateMessage", new Object[0]);
        }
        String string = "<html><head><style>" + this.preferences.getLocalizedString(HomeController.class, "updatesMessageStyleSheet", new Object[0]) + " .separator { margin: 0px;}</style></head><body>" + this.preferences.getLocalizedString(HomeController.class, "updatesMessageTitle", new Object[0]);
        String string2 = this.preferences.getLocalizedString(HomeController.class, "applicationUpdateMessage", new Object[0]);
        String string3 = this.preferences.getLocalizedString(HomeController.class, "libraryUpdateMessage", new Object[0]);
        String string4 = this.preferences.getLocalizedString(HomeController.class, "sizeUpdateMessage", new Object[0]);
        String string5 = this.preferences.getLocalizedString(HomeController.class, "downloadUpdateMessage", new Object[0]);
        String string6 = this.preferences.getLocalizedString(HomeController.class, "updatesMessageSeparator", new Object[0]);
        Iterator<Map.Entry<Library, List<Update>>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Library, List<Update>> entry = iterator.next();
            Library library = entry.getKey();
            if (library == null) {
                if (this.application != null) {
                    string = string + this.getApplicationOrLibraryUpdateMessage(entry.getValue(), this.application.getName(), string2, string4, string5);
                }
            } else {
                String string7 = library.getName();
                if (string7 == null && (string7 = library.getDescription()) == null) {
                    string7 = library.getLocation();
                }
                string = string + this.getApplicationOrLibraryUpdateMessage(entry.getValue(), string7, string3, string4, string5);
            }
            if (!iterator.hasNext()) continue;
            string = string + string6;
        }
        string = string + "</body></html>";
        return string;
    }

    private String getApplicationOrLibraryUpdateMessage(List<Update> list, String string, String string2, String string3, String string4) {
        String string5 = "";
        boolean bl = true;
        DateFormat dateFormat = DateFormat.getDateInstance(1);
        DecimalFormat decimalFormat = new DecimalFormat("#,##0.#");
        for (Update update : list) {
            Object object;
            String string6 = update.getSize() != null ? String.format(string3, decimalFormat.format((double)update.getSize().longValue() / 1048576.0)) : "";
            string5 = string5 + String.format(string2, string, update.getVersion(), dateFormat.format(update.getDate()), string6);
            if (bl) {
                bl = false;
                object = update.getDownloadPage();
                if (object == null) {
                    object = update.getDefaultDownloadPage();
                }
                if (object != null) {
                    string5 = string5 + String.format(string4, object);
                }
            }
            if ((object = update.getComment()) == null) {
                object = update.getDefaultComment();
            }
            if (object == null) continue;
            string5 = string5 + "<p class='separator'/>";
            string5 = string5 + (String)object;
            string5 = string5 + "<p class='separator'/>";
        }
        return string5;
    }

    static {
        REPAIRED_IMAGE_CONTENT = new ResourceURLContent(HomeController.class, "resources/repairedImage.png");
        REPAIRED_ICON_CONTENT = new ResourceURLContent(HomeController.class, "resources/repairedIcon.png");
        REPAIRED_MODEL_CONTENT = new ResourceURLContent(HomeController.class, "resources/repairedModel.obj");
    }

    private static class Update
    implements Cloneable {
        private String id;
        private final String version;
        private Date date;
        private String minVersion;
        private String maxVersion;
        private Long size;
        private String operatingSystem;
        private URL defaultDownloadPage;
        private URL downloadPage;
        private String defaultComment;
        private String comment;

        public Update(String string, String string2) {
            this.id = string;
            this.version = string2;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String string) {
            this.id = string;
        }

        public String getVersion() {
            return this.version;
        }

        public Date getDate() {
            return this.date;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public String getMinVersion() {
            return this.minVersion;
        }

        public void setMinVersion(String string) {
            this.minVersion = string;
        }

        public String getMaxVersion() {
            return this.maxVersion;
        }

        public void setMaxVersion(String string) {
            this.maxVersion = string;
        }

        public Long getSize() {
            return this.size;
        }

        public void setSize(Long l) {
            this.size = l;
        }

        public String getOperatingSystem() {
            return this.operatingSystem;
        }

        public void setOperatingSystem(String string) {
            this.operatingSystem = string;
        }

        public URL getDefaultDownloadPage() {
            return this.defaultDownloadPage;
        }

        public void setDefaultDownloadPage(URL uRL) {
            this.defaultDownloadPage = uRL;
        }

        public URL getDownloadPage() {
            return this.downloadPage;
        }

        public void setDownloadPage(URL uRL) {
            this.downloadPage = uRL;
        }

        public String getDefaultComment() {
            return this.defaultComment;
        }

        public void setDefaultComment(String string) {
            this.defaultComment = string;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String string) {
            this.comment = string;
        }

        protected Update clone() {
            try {
                return (Update)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UpdatesHandler
    extends DefaultHandler {
        private final URL baseUrl;
        private final StringBuilder comment = new StringBuilder();
        private final SimpleDateFormat dateTimeFormat;
        private final SimpleDateFormat dateFormat;
        private final Map<String, List<Update>> updates = new HashMap<String, List<Update>>();
        private Update update;
        private boolean inComment;
        private boolean inUpdate;
        private String language;

        public UpdatesHandler(URL uRL) {
            this.baseUrl = uRL;
            TimeZone timeZone = TimeZone.getTimeZone("GMT");
            this.dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
            this.dateTimeFormat.setTimeZone(timeZone);
            this.dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            this.dateFormat.setTimeZone(timeZone);
        }

        private List<Update> getUpdates(String string) {
            return this.updates.get(string);
        }

        private void checkCurrentThreadIsntInterrupted() throws SAXException {
            if (Thread.interrupted()) {
                throw new SAXException(new InterruptedIOException());
            }
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.checkCurrentThreadIsntInterrupted();
            if (this.inComment) {
                this.comment.append("<" + string3);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    this.comment.append(" " + attributes.getQName(i) + "=\"" + attributes.getValue(i) + "\"");
                }
                this.comment.append(">");
            } else if (this.inUpdate && "comment".equals(string3)) {
                this.comment.setLength(0);
                this.language = attributes.getValue("lang");
                if (this.language == null || HomeController.this.preferences.getLanguage().equals(this.language)) {
                    this.inComment = true;
                }
            } else if (this.inUpdate && "downloadPage".equals(string3)) {
                String string4 = attributes.getValue("url");
                if (string4 != null) {
                    try {
                        String string5 = attributes.getValue("lang");
                        if (string5 == null) {
                            this.update.setDefaultDownloadPage(new URL(this.baseUrl, string4));
                        } else if (HomeController.this.preferences.getLanguage().equals(string5)) {
                            this.update.setDownloadPage(new URL(this.baseUrl, string4));
                        }
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            } else if (!this.inUpdate && "update".equals(string3)) {
                String string6 = attributes.getValue("id");
                String string7 = attributes.getValue("version");
                if (string6 != null && string7 != null) {
                    List<Update> list;
                    String string8;
                    String string9;
                    Object object;
                    Object object2;
                    Object object3;
                    this.update = new Update(string6, string7);
                    String string10 = attributes.getValue("inherits");
                    if (string10 != null && (object3 = this.updates.get(string10)) != null) {
                        object2 = object3.iterator();
                        while (object2.hasNext()) {
                            object = (Update)object2.next();
                            if (!string7.equals(((Update)object).getVersion())) continue;
                            this.update = ((Update)object).clone();
                            this.update.setId(string6);
                            break;
                        }
                    }
                    if ((object3 = attributes.getValue("date")) != null) {
                        try {
                            this.update.setDate(this.dateTimeFormat.parse((String)object3));
                        }
                        catch (ParseException parseException) {
                            try {
                                this.update.setDate(this.dateFormat.parse((String)object3));
                            }
                            catch (ParseException parseException2) {
                                // empty catch block
                            }
                        }
                    }
                    if ((object2 = attributes.getValue("minVersion")) != null) {
                        this.update.setMinVersion((String)object2);
                    }
                    if ((object = attributes.getValue("maxVersion")) != null) {
                        this.update.setMaxVersion((String)object);
                    }
                    if ((string9 = attributes.getValue("size")) != null) {
                        try {
                            this.update.setSize(new Long(string9));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if ((string8 = attributes.getValue("operatingSystem")) != null) {
                        this.update.setOperatingSystem(string8);
                    }
                    if ((list = this.updates.get(string6)) == null) {
                        list = new ArrayList<Update>();
                        this.updates.put(string6, list);
                    }
                    list.add(this.update);
                    this.inUpdate = true;
                }
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.checkCurrentThreadIsntInterrupted();
            if (this.inComment) {
                this.comment.append(cArray, n, n2);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.inComment) {
                if ("comment".equals(string3)) {
                    String string4 = this.comment.toString().trim().replace('\n', ' ');
                    if (string4.length() == 0) {
                        string4 = null;
                    }
                    if (this.language == null) {
                        this.update.setDefaultComment(string4);
                    } else {
                        this.update.setComment(string4);
                    }
                    this.inComment = false;
                } else {
                    this.comment.append("</" + string3 + ">");
                }
            } else if (this.inUpdate && "update".equals(string3)) {
                this.inUpdate = false;
            }
        }
    }

    private static class LanguageChangeListener
    implements PropertyChangeListener {
        private WeakReference<HomeController> homeController;

        public LanguageChangeListener(HomeController homeController) {
            this.homeController = new WeakReference<HomeController>(homeController);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            HomeController homeController = (HomeController)this.homeController.get();
            if (homeController == null) {
                ((UserPreferences)propertyChangeEvent.getSource()).removePropertyChangeListener(UserPreferences.Property.LANGUAGE, this);
            } else {
                homeController.getView().setUndoRedoName(homeController.undoManager.canUndo() ? homeController.undoManager.getUndoPresentationName() : null, homeController.undoManager.canRedo() ? homeController.undoManager.getRedoPresentationName() : null);
            }
        }
    }

    private static class UserPreferencesPropertiesChangeListener
    extends UserPreferencesChangeListener
    implements PropertyChangeListener {
        private WeakReference<HomeController> homeController;

        public UserPreferencesPropertiesChangeListener(HomeController homeController) {
            this.homeController = new WeakReference<HomeController>(homeController);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            HomeController homeController = (HomeController)this.homeController.get();
            if (homeController == null) {
                ((UserPreferences)propertyChangeEvent.getSource()).removePropertyChangeListener(UserPreferences.Property.valueOf(propertyChangeEvent.getPropertyName()), this);
            } else {
                this.writePreferences(homeController);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TexturesCatalogChangeListener
    extends UserPreferencesChangeListener
    implements CollectionListener<CatalogTexture> {
        private WeakReference<HomeController> homeController;

        public TexturesCatalogChangeListener(HomeController homeController) {
            this.homeController = new WeakReference<HomeController>(homeController);
        }

        @Override
        public void collectionChanged(CollectionEvent<CatalogTexture> collectionEvent) {
            HomeController homeController = (HomeController)this.homeController.get();
            if (homeController == null) {
                ((TexturesCatalog)collectionEvent.getSource()).removeTexturesListener(this);
            } else {
                this.writePreferences(homeController);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FurnitureCatalogChangeListener
    extends UserPreferencesChangeListener
    implements CollectionListener<CatalogPieceOfFurniture> {
        private WeakReference<HomeController> homeController;

        public FurnitureCatalogChangeListener(HomeController homeController) {
            this.homeController = new WeakReference<HomeController>(homeController);
        }

        @Override
        public void collectionChanged(CollectionEvent<CatalogPieceOfFurniture> collectionEvent) {
            HomeController homeController = (HomeController)this.homeController.get();
            if (homeController == null) {
                ((FurnitureCatalog)collectionEvent.getSource()).removeFurnitureListener(this);
            } else {
                this.writePreferences(homeController);
            }
        }
    }

    private static abstract class UserPreferencesChangeListener {
        private static Set<UserPreferences> writingPreferences = new HashSet<UserPreferences>();

        private UserPreferencesChangeListener() {
        }

        public void writePreferences(final HomeController homeController) {
            if (!writingPreferences.contains(homeController.preferences)) {
                writingPreferences.add(homeController.preferences);
                homeController.getView().invokeLater(new Runnable(){

                    public void run() {
                        try {
                            homeController.preferences.write();
                            writingPreferences.remove(homeController.preferences);
                        }
                        catch (RecorderException recorderException) {
                            homeController.getView().showError(homeController.preferences.getLocalizedString(HomeController.class, "savePreferencesError", new Object[0]));
                        }
                    }
                });
            }
        }
    }
}

