/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Unit;
import java.beans.PropertyVetoException;

public class ComposedUnit
extends Unit {
    protected Composed[] composedUnits = new Composed[0];

    public Composed[] getComposedUnits() {
        return this.composedUnits;
    }

    public void setComposedUnits(Composed[] composedUnits) throws PropertyVetoException {
        Composed[] oldValue = this.composedUnits;
        Composed[] newValue = composedUnits;
        if (oldValue == newValue) {
            return;
        }
        if (this.extending != null) {
            throw new IllegalArgumentException("This order not implemented yet. Works only with units that do not extend another one.");
        }
        for (int i = 0; i < composedUnits.length; ++i) {
            if (this.isAbstract() && !composedUnits[i].getUnit().isAbstract()) {
                throw new IllegalArgumentException(ComposedUnit.formatMessage("err_abstractUnitComposedOfConcrete", this.toString(), composedUnits[i].getUnit().toString()));
            }
            if (this.isAbstract() || !composedUnits[i].getUnit().isAbstract()) continue;
            throw new IllegalArgumentException(ComposedUnit.formatMessage("err_concreteUnitComposedOfAbstract", this.toString(), composedUnits[i].getUnit().toString()));
        }
        this.fireVetoableChange("composedUnits", oldValue, newValue);
        this.composedUnits = composedUnits;
        this.firePropertyChange("composedUnits", oldValue, newValue);
    }

    @Override
    public boolean isDependentOn(Element e) {
        if (this.extending != null && this.extending.isDependentOn(e)) {
            return true;
        }
        for (int i = 0; i < this.composedUnits.length; ++i) {
            Composed c = this.composedUnits[i];
            if (!c.getUnit().isDependentOn(e)) continue;
            return true;
        }
        return super.isDependentOn(e);
    }

    @Override
    protected void checkExtending(Unit ext) {
        if (ext != null && ext.isDependentOn(this)) {
            throw new IllegalArgumentException("The unit \"" + this.getName() + "\" can not be based on \"" + ext.getName() + ", because the latter depends on the former.");
        }
        if (ext != null) {
            if (!(ext instanceof ComposedUnit)) {
                throw new IllegalArgumentException(ComposedUnit.formatMessage("err_composedUnitExtendingNonComposed", this.toString(), ext.toString()));
            }
            ComposedUnit e = (ComposedUnit)ext;
            if (this.composedUnits.length != e.composedUnits.length) {
                throw new IllegalArgumentException(ComposedUnit.formatMessage("err_composedUnitExtendingUnequalCardinality", this.toString(), e.toString()));
            }
            for (int i = 0; i < this.composedUnits.length; ++i) {
                if (!this.composedUnits[i].getUnit().isExtendingIndirectly(e.composedUnits[i].getUnit())) {
                    throw new IllegalArgumentException(ComposedUnit.formatMessage("err_unitCantExtendBecauseOfPart", this.toString(), e.toString(), this.composedUnits[i].getUnit().toString(), e.composedUnits[i].getUnit().toString()));
                }
                if (this.composedUnits[i].getCompositionOperator() == e.composedUnits[i].getCompositionOperator()) continue;
                if (this.composedUnits[i].getCompositionOperator() == '/') {
                    throw new IllegalArgumentException(ComposedUnit.formatMessage("err_unitCantExtendBecauseOfDiv", this.toString(), e.toString(), e.composedUnits[i].getUnit().toString()));
                }
                throw new IllegalArgumentException(ComposedUnit.formatMessage("err_unitCantExtendBecauseOfMult", this.toString(), e.toString(), e.composedUnits[i].getUnit().toString()));
            }
        }
    }

    @Override
    public void setAbstract(boolean abst) throws PropertyVetoException {
        if (!abst) {
            for (int i = 0; i < this.composedUnits.length; ++i) {
                if (this.composedUnits[i] == null || this.composedUnits[i].getUnit() == null || !this.composedUnits[i].getUnit().isAbstract()) continue;
                throw new IllegalArgumentException(ComposedUnit.formatMessage("err_concreteUnitComposedOfAbstract", this.toString(), this.composedUnits[i].getUnit().toString()));
            }
        } else {
            for (int i = 0; i < this.composedUnits.length; ++i) {
                if (this.composedUnits[i] == null || this.composedUnits[i].getUnit() == null || this.composedUnits[i].getUnit().isAbstract()) continue;
                throw new IllegalArgumentException(ComposedUnit.formatMessage("err_abstractUnitComposedOfConcrete", this.toString(), this.composedUnits[i].getUnit().toString()));
            }
        }
        super.setAbstract(abst);
    }

    public static class Composed {
        protected char compositionOperator;
        protected Unit unit;

        public Composed(char compositionOperator, Unit unit) {
            this.compositionOperator = compositionOperator;
            this.unit = unit;
            if (compositionOperator != '*' && compositionOperator != '/') {
                throw new IllegalArgumentException(Element.rsrc.getString("err_illegalUnitCompositionOperator"));
            }
        }

        public Unit getUnit() {
            return this.unit;
        }

        public char getCompositionOperator() {
            return this.compositionOperator;
        }
    }
}

