/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.valid;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.List;

public class SimpleNestedRingTester {
    private GeometryGraph graph;
    private List rings = new ArrayList();
    private Coordinate nestedPt;

    public SimpleNestedRingTester(GeometryGraph graph) {
        this.graph = graph;
    }

    public void add(LinearRing ring) {
        this.rings.add(ring);
    }

    public Coordinate getNestedPoint() {
        return this.nestedPt;
    }

    public boolean isNonNested() {
        for (int i = 0; i < this.rings.size(); ++i) {
            LinearRing innerRing = (LinearRing)this.rings.get(i);
            Coordinate[] innerRingPts = innerRing.getCoordinates();
            for (int j = 0; j < this.rings.size(); ++j) {
                LinearRing searchRing = (LinearRing)this.rings.get(j);
                Coordinate[] searchRingPts = searchRing.getCoordinates();
                if (innerRing == searchRing || !innerRing.getEnvelopeInternal().intersects(searchRing.getEnvelopeInternal())) continue;
                Coordinate innerRingPt = IsValidOp.findPtNotNode(innerRingPts, searchRing, this.graph);
                Assert.isTrue(innerRingPt != null, "Unable to find a ring point not a node of the search ring");
                boolean isInside = CGAlgorithms.isPointInRing(innerRingPt, searchRingPts);
                if (!isInside) continue;
                this.nestedPt = innerRingPt;
                return false;
            }
        }
        return true;
    }
}

