/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.health;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.health.ClusterIndexHealth;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.RoutingTableValidation;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.rest.RestStatus;

public final class ClusterStateHealth
implements Iterable<ClusterIndexHealth>,
Streamable {
    private int numberOfNodes = 0;
    private int numberOfDataNodes = 0;
    private int activeShards = 0;
    private int relocatingShards = 0;
    private int activePrimaryShards = 0;
    private int initializingShards = 0;
    private int unassignedShards = 0;
    private double activeShardsPercent = 100.0;
    private ClusterHealthStatus status = ClusterHealthStatus.RED;
    private List<String> validationFailures;
    private Map<String, ClusterIndexHealth> indices = new HashMap<String, ClusterIndexHealth>();

    public static ClusterStateHealth readClusterHealth(StreamInput in) throws IOException {
        ClusterStateHealth clusterStateHealth = new ClusterStateHealth();
        clusterStateHealth.readFrom(in);
        return clusterStateHealth;
    }

    ClusterStateHealth() {
    }

    public ClusterStateHealth(int numberOfNodes, int numberOfDataNodes, int activeShards, int relocatingShards, int activePrimaryShards, int initializingShards, int unassignedShards, double activeShardsPercent, ClusterHealthStatus status, List<String> validationFailures, Map<String, ClusterIndexHealth> indices) {
        this.numberOfNodes = numberOfNodes;
        this.numberOfDataNodes = numberOfDataNodes;
        this.activeShards = activeShards;
        this.relocatingShards = relocatingShards;
        this.activePrimaryShards = activePrimaryShards;
        this.initializingShards = initializingShards;
        this.unassignedShards = unassignedShards;
        this.activeShardsPercent = activeShardsPercent;
        this.status = status;
        this.validationFailures = validationFailures;
        this.indices = indices;
    }

    public ClusterStateHealth(MetaData clusterMetaData, RoutingTable routingTables) {
        this(ClusterState.builder(ClusterName.DEFAULT).metaData(clusterMetaData).routingTable(routingTables).build());
    }

    public ClusterStateHealth(ClusterState clusterState) {
        this(clusterState, clusterState.metaData().concreteAllIndices());
    }

    public ClusterStateHealth(ClusterState clusterState, String[] concreteIndices) {
        RoutingTableValidation validation = clusterState.routingTable().validate(clusterState.metaData());
        this.validationFailures = validation.failures();
        this.numberOfNodes = clusterState.nodes().size();
        this.numberOfDataNodes = clusterState.nodes().dataNodes().size();
        for (String index : concreteIndices) {
            IndexRoutingTable indexRoutingTable = clusterState.routingTable().index(index);
            IndexMetaData indexMetaData = clusterState.metaData().index(index);
            if (indexRoutingTable == null) continue;
            ClusterIndexHealth indexHealth = new ClusterIndexHealth(indexMetaData, indexRoutingTable);
            this.indices.put(indexHealth.getIndex(), indexHealth);
        }
        this.status = ClusterHealthStatus.GREEN;
        for (ClusterIndexHealth indexHealth : this.indices.values()) {
            this.activePrimaryShards += indexHealth.getActivePrimaryShards();
            this.activeShards += indexHealth.getActiveShards();
            this.relocatingShards += indexHealth.getRelocatingShards();
            this.initializingShards += indexHealth.getInitializingShards();
            this.unassignedShards += indexHealth.getUnassignedShards();
            if (indexHealth.getStatus() == ClusterHealthStatus.RED) {
                this.status = ClusterHealthStatus.RED;
                continue;
            }
            if (indexHealth.getStatus() != ClusterHealthStatus.YELLOW || this.status == ClusterHealthStatus.RED) continue;
            this.status = ClusterHealthStatus.YELLOW;
        }
        if (!this.validationFailures.isEmpty()) {
            this.status = ClusterHealthStatus.RED;
        } else if (clusterState.blocks().hasGlobalBlock(RestStatus.SERVICE_UNAVAILABLE)) {
            this.status = ClusterHealthStatus.RED;
        }
        if (this.status.equals((Object)ClusterHealthStatus.GREEN)) {
            this.activeShardsPercent = 100.0;
        } else {
            List<ShardRouting> shardRoutings = clusterState.getRoutingTable().allShards();
            int activeShardCount = 0;
            int totalShardCount = 0;
            for (ShardRouting shardRouting : shardRoutings) {
                if (shardRouting.active()) {
                    ++activeShardCount;
                }
                ++totalShardCount;
            }
            this.activeShardsPercent = (double)activeShardCount / (double)totalShardCount * 100.0;
        }
    }

    public List<String> getValidationFailures() {
        return Collections.unmodifiableList(this.validationFailures);
    }

    public int getActiveShards() {
        return this.activeShards;
    }

    public int getRelocatingShards() {
        return this.relocatingShards;
    }

    public int getActivePrimaryShards() {
        return this.activePrimaryShards;
    }

    public int getInitializingShards() {
        return this.initializingShards;
    }

    public int getUnassignedShards() {
        return this.unassignedShards;
    }

    public int getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public int getNumberOfDataNodes() {
        return this.numberOfDataNodes;
    }

    public void setStatus(ClusterHealthStatus status) {
        if (status == null) {
            throw new IllegalArgumentException("'status' must not be null");
        }
        this.status = status;
    }

    public ClusterHealthStatus getStatus() {
        return this.status;
    }

    public Map<String, ClusterIndexHealth> getIndices() {
        return Collections.unmodifiableMap(this.indices);
    }

    public double getActiveShardsPercent() {
        return this.activeShardsPercent;
    }

    @Override
    public Iterator<ClusterIndexHealth> iterator() {
        return this.indices.values().iterator();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int i;
        this.activePrimaryShards = in.readVInt();
        this.activeShards = in.readVInt();
        this.relocatingShards = in.readVInt();
        this.initializingShards = in.readVInt();
        this.unassignedShards = in.readVInt();
        this.numberOfNodes = in.readVInt();
        this.numberOfDataNodes = in.readVInt();
        this.status = ClusterHealthStatus.fromValue(in.readByte());
        int size = in.readVInt();
        for (i = 0; i < size; ++i) {
            ClusterIndexHealth indexHealth = ClusterIndexHealth.readClusterIndexHealth(in);
            this.indices.put(indexHealth.getIndex(), indexHealth);
        }
        size = in.readVInt();
        if (size == 0) {
            this.validationFailures = Collections.emptyList();
        } else {
            for (i = 0; i < size; ++i) {
                this.validationFailures.add(in.readString());
            }
        }
        this.activeShardsPercent = in.readDouble();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.activePrimaryShards);
        out.writeVInt(this.activeShards);
        out.writeVInt(this.relocatingShards);
        out.writeVInt(this.initializingShards);
        out.writeVInt(this.unassignedShards);
        out.writeVInt(this.numberOfNodes);
        out.writeVInt(this.numberOfDataNodes);
        out.writeByte(this.status.value());
        out.writeVInt(this.indices.size());
        for (ClusterIndexHealth indexHealth : this) {
            indexHealth.writeTo(out);
        }
        out.writeVInt(this.validationFailures.size());
        for (String failure : this.validationFailures) {
            out.writeString(failure);
        }
        out.writeDouble(this.activeShardsPercent);
    }
}

