/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestExecutionException;
import org.gradle.api.tasks.testing.TestFilter;
import org.gradle.execution.BuildConfigurationAction;
import org.gradle.execution.BuildExecutionContext;
import org.gradle.tooling.internal.protocol.events.InternalTestDescriptor;
import org.gradle.tooling.internal.protocol.test.InternalJvmTestRequest;
import org.gradle.tooling.internal.provider.TestExecutionRequestAction;
import org.gradle.tooling.internal.provider.events.DefaultTestDescriptor;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TestExecutionBuildConfigurationAction
implements BuildConfigurationAction {
    private final GradleInternal gradle;
    private final TestExecutionRequestAction testExecutionRequest;

    public TestExecutionBuildConfigurationAction(TestExecutionRequestAction testExecutionRequest, GradleInternal gradle) {
        this.testExecutionRequest = testExecutionRequest;
        this.gradle = gradle;
    }

    public void configure(BuildExecutionContext context) {
        LinkedHashSet<Test> allTestTasksToRun = new LinkedHashSet<Test>();
        GradleInternal gradleInternal = context.getGradle();
        allTestTasksToRun.addAll(this.configureBuildForTestDescriptors(gradleInternal, this.testExecutionRequest));
        allTestTasksToRun.addAll(this.configureBuildForInternalJvmTestRequest(gradleInternal, this.testExecutionRequest));
        this.configureTestTasks(allTestTasksToRun);
        this.gradle.getTaskGraph().addTasks(allTestTasksToRun);
    }

    private void configureTestTasks(Set<Test> allTestTasksToRun) {
        for (Test task : allTestTasksToRun) {
            task.setIgnoreFailures(true);
            task.getFilter().setFailOnNoMatchingTests(false);
            task.getOutputs().upToDateWhen(Specs.SATISFIES_NONE);
        }
    }

    private List<Test> configureBuildForTestDescriptors(GradleInternal gradle, TestExecutionRequestAction testExecutionRequest) {
        Collection testDescriptors = testExecutionRequest.getTestExecutionDescriptors();
        List testTaskPaths = CollectionUtils.collect((Iterable)testDescriptors, (Transformer)new Transformer<String, InternalTestDescriptor>(){

            public String transform(InternalTestDescriptor testDescriptor) {
                return ((DefaultTestDescriptor)testDescriptor).getTaskPath();
            }
        });
        ArrayList<Test> testTasksToRun = new ArrayList<Test>();
        for (String testTaskPath : testTaskPaths) {
            Task task = gradle.getRootProject().getTasks().findByPath(testTaskPath);
            if (task == null) {
                throw new TestExecutionException(String.format("Requested test task with path '%s' cannot be found.", testTaskPath));
            }
            if (!(task instanceof Test)) {
                throw new TestExecutionException(String.format("Task '%s' of type '%s' not supported for executing tests via TestLauncher API.", testTaskPath, task.getClass().getName()));
            }
            Test testTask = (Test)task;
            for (InternalTestDescriptor testDescriptor : testDescriptors) {
                DefaultTestDescriptor defaultTestDescriptor = (DefaultTestDescriptor)testDescriptor;
                if (!defaultTestDescriptor.getTaskPath().equals(testTaskPath)) continue;
                String className = defaultTestDescriptor.getClassName();
                String methodName = defaultTestDescriptor.getMethodName();
                if (className == null && methodName == null) {
                    testTask.getFilter().includeTestsMatching("*");
                    continue;
                }
                testTask.getFilter().includeTest(className, methodName);
            }
            testTasksToRun.add(testTask);
        }
        return testTasksToRun;
    }

    private List<Test> configureBuildForInternalJvmTestRequest(GradleInternal gradle, TestExecutionRequestAction testExecutionRequest) {
        Collection internalJvmTestRequests = testExecutionRequest.getInternalJvmTestRequests();
        if (internalJvmTestRequests.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Test> tasksToExecute = new ArrayList<Test>();
        Set allprojects = gradle.getRootProject().getAllprojects();
        for (Project project : allprojects) {
            TaskCollection testTasks = project.getTasks().withType(Test.class);
            for (Test testTask : testTasks) {
                for (InternalJvmTestRequest jvmTestRequest : internalJvmTestRequests) {
                    TestFilter filter = testTask.getFilter();
                    filter.includeTest(jvmTestRequest.getClassName(), jvmTestRequest.getMethodName());
                }
            }
            tasksToExecute.addAll((Collection<Test>)testTasks);
        }
        return tasksToExecute;
    }
}

