/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import org.gradle.api.JavaVersion;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.buildinit.plugins.internal.BuildInitTestFramework;
import org.gradle.buildinit.plugins.internal.LanguageLibraryProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.ProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.TemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.TemplateOperationFactory;
import org.gradle.util.GUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaLibraryProjectInitDescriptor
extends LanguageLibraryProjectInitDescriptor {
    public static final String TESTNG_JAVA6_WARNING = "Latest version of TestNG is not compatible with Java 6. Change the version of TestNG in generated build script manually or upgrade Java.";
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaLibraryProjectInitDescriptor.class);

    public JavaLibraryProjectInitDescriptor(TemplateOperationFactory templateOperationFactory, FileResolver fileResolver, TemplateLibraryVersionProvider libraryVersionProvider, ProjectInitDescriptor globalSettingsDescriptor) {
        super("java", templateOperationFactory, fileResolver, libraryVersionProvider, globalSettingsDescriptor);
    }

    public void generate(BuildInitTestFramework testFramework) {
        if (testFramework == BuildInitTestFramework.TESTNG && JavaVersion.current().isJava6()) {
            LOGGER.warn(TESTNG_JAVA6_WARNING);
        }
        this.globalSettingsDescriptor.generate(testFramework);
        this.templateOperationFactory.newTemplateOperation().withTemplate(this.gradleBuildTemplate(testFramework)).withTarget("build.gradle").withDocumentationBindings(GUtil.map((Object[])new Object[]{"ref_userguide_java_tutorial", "tutorial_java_projects"})).withBindings(GUtil.map((Object[])new Object[]{"junitVersion", this.libraryVersionProvider.getVersion("junit")})).withBindings(GUtil.map((Object[])new Object[]{"slf4jVersion", this.libraryVersionProvider.getVersion("slf4j")})).withBindings(GUtil.map((Object[])new Object[]{"groovyVersion", this.libraryVersionProvider.getVersion("groovy")})).withBindings(GUtil.map((Object[])new Object[]{"spockVersion", this.libraryVersionProvider.getVersion("spock")})).withBindings(GUtil.map((Object[])new Object[]{"testngVersion", this.libraryVersionProvider.getVersion("testng")})).create().generate();
        TemplateOperation javalibraryTemplateOperation = this.fromClazzTemplate("javalibrary/Library.java.template", "main");
        this.whenNoSourcesAvailable(javalibraryTemplateOperation, this.testTemplateOperation(testFramework)).generate();
    }

    private String gradleBuildTemplate(BuildInitTestFramework testFramework) {
        switch (testFramework) {
            case SPOCK: {
                return "javalibrary/spock-build.gradle.template";
            }
            case TESTNG: {
                return "javalibrary/testng-build.gradle.template";
            }
        }
        return "javalibrary/build.gradle.template";
    }

    private TemplateOperation testTemplateOperation(BuildInitTestFramework testFramework) {
        switch (testFramework) {
            case SPOCK: {
                return this.fromClazzTemplate("groovylibrary/LibraryTest.groovy.template", "test", "groovy");
            }
            case TESTNG: {
                return this.fromClazzTemplate("javalibrary/LibraryTestNG.java.template", "test", "java", "LibraryTest.java");
            }
        }
        return this.fromClazzTemplate("javalibrary/LibraryTest.java.template", "test");
    }

    public boolean supports(BuildInitTestFramework testFramework) {
        return testFramework == BuildInitTestFramework.SPOCK || testFramework == BuildInitTestFramework.TESTNG;
    }
}

