# 
# This package is only kept for compatibility reasons with old softwares.
# Please use the real INN::Config Perl module instead.
#
# Author:       James Brister <brister@vix.com> -- berkeley-unix --
# Start Date:   Sat, 24 Aug 1996 22:08:19 +0200
# Project:      INN 
# File:         innshellvars.pl
# RCSId:        $Id: innshellvars.pl.in 9567 2013-11-17 20:24:35Z iulius $
# Description:  Set up any and all variables that an INN perl script
#               might need.  Also sets umask.
#

package inn ;

$ENV{'LC_CTYPE'} = "C";

$prefix = '/usr';
$exec_prefix = "${prefix}";
eval `${exec_prefix}/bin/innconfval -p`;

$newshome = $pathnews;
$spooldir = $pathspool;
$most_logs = $pathlog;
$ENV{'NEWSHOME'} = $pathnews;
$ENV{'SPOOLDIR'} = $spooldir;
$ENV{'MOST_LOGS'} = $most_logs;

$newsbin = $pathbin;
$newsetc = $pathetc;
$newslib = "${exec_prefix}/lib";
$innddir = $pathrun;
$locks = $pathrun;
$ENV{'NEWSBIN'} = $newsbin;
$ENV{'NEWSETC'} = $newsetc;
$ENV{'NEWSLIB'} = $newslib;
$ENV{'INNDDIR'} = $innddir;
$ENV{'LOCKS'} = $locks;

$errlog = "${most_logs}/errlog";
$log = "${most_logs}/news";

$archivedir = $patharchive;
$spool = $patharticles;
$batch = $pathoutgoing;
$incoming = $pathincoming;
$overviewdir = $pathoverview;
$spoolnews = $pathincoming;
$badnews = "$pathincoming/bad";

$active = "${pathdb}/active" ;
$activetimes = "${pathdb}/active.times" ;
$ctlfile = "${newsetc}/control.ctl" ;
$ctlwatch = "${newsetc}/innwatch.ctl" ;
$history = "${pathdb}/history" ;
$newactive = "${pathdb}/active.tmp" ;
$newsfeeds = "${newsetc}/newsfeeds" ;
$newsgroups = "${pathdb}/newsgroups" ;
$oldactive = "${pathdb}/active.old" ;
$path_motd_innd = "${newsetc}/motd.innd" ;
$path_motd_nnrpd = "${newsetc}/motd.nnrpd" ;
$path_motd = "${path_motd_nnrpd}" ;
$expirectl = "${newsetc}/expire.ctl" ;
$localgroups = "$newsetc/localgroups" ;

$controlprogs = $pathcontrol;
$innconfval = "${newsbin}/innconfval" ;
$innd = "${newsbin}/innd" ;
$innwatch = "${newsbin}/innwatch" ;
$inews = "${newsbin}/inews" ;
$rnews = "${newsbin}/rnews" ;
$perl_startup_innd = "$pathfilter/startup_innd.pl" ;
$perl_filter_innd = "$pathfilter/filter_innd.pl" ;
$perl_filter_nnrpd = "$pathfilter/filter_nnrpd.pl" ;
$python_filter_innd = "$pathfilter/filter_innd.py" ;
$path_python_inn_module = "$pathfilter/INN.py" ;
$path_tcl_startup = "$pathfilter/startup.tcl" ;
$path_tcl_filter = "$pathfilter/filter.tcl" ;

$daily = "${locks}/LOCK.news.daily" ;

$newscontrol = "${innddir}/control" ;
$nntpconnect = "${innddir}/nntpin" ;
$serverpid = "${innddir}/innd.pid" ;
$innwstatus = "${innddir}/innwatch.status" ;
$watchpid = "${innddir}/innwatch.pid" ;

$awk = 'gawk' ;
$sed = '/usr/bin/sed' ;
$inndf = "${newsbin}/inndf" ;
$egrep = '/usr/bin/grep -E' ;
$perl = '/usr/bin/perl' ;
$gpgv = '/usr/bin/gpgv2' ;
$pgp = '' ;
$sort = '/usr/bin/sort' ;
$getftp = "${exec_prefix}/bin/simpleftp" ;
$uustat = '' ;
$uux = 'uux' ;

$bzip2 = '/usr/bin/bzip2' ;
$compress = 'compress' ;
$gzip = '/usr/bin/gzip' ;
$uncompress = '/usr/bin/gzip -d' ;
$log_compress = '/usr/bin/gzip' ;
$z = '.gz' ;

if ($ovmethod && $ovmethod eq "ovdb") {
    $ENV{'DB_HOME'} = $pathoverview;
}

($tempsock = "${innddir}/ctlinndXXXXXX") =~ s!.*/(.*)XXXXXX$!$1*! ;
($tempsockdir = "${innddir}/ctlinndXXXXXX") =~ s!/[^/]*$!! ;

$newsmaster = 'usenet' ;
$newsuser = ${runasuser} ;
$newsgroup = ${runasgroup} ;

$filemode = 0664;
$inewsmode = 0550;
$rnewsmode = 0500;

$do_dbz_tagged_hash = 'DONT';

$tmpdir = ${pathtmp};
$ENV{'TMPDIR'} = ${pathtmp};

$spooltemp = ${pathtmp};

$newslbin = "${newshome}/local";
$ENV{'NEWSLBIN'} = ${newslbin};

umask 02;
$umask = 02;

$syslog_facility = lc("LOG_NEWS");
$syslog_facility =~ s/log_//;

$path = $ENV{'PATH'} || '';
$path = "${newslbin}:${newsbin}:${path}:/bin:/usr/bin";
$ENV{'PATH'} = $path;


$home = ${pathnews};

##  Load another script that can override or add variables.
if (-x "${pathetc}/innshellvars.pl.local") {
    do "${pathetc}/innshellvars.pl.local";
}

1 ;
