/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.encoding;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.specific.ISO8859_16Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.util.ByteList;
import org.jruby.util.encoding.ISO_8859_16;

public class EncodingManager {
    private final DynamicObject[] ENCODING_LIST_BY_ENCODING_LIST_INDEX = new DynamicObject[EncodingDB.getEncodings().size()];
    private final DynamicObject[] ENCODING_LIST_BY_ENCODING_INDEX = new DynamicObject[EncodingDB.getEncodings().size()];
    private final Map<String, DynamicObject> LOOKUP = new HashMap<String, DynamicObject>();
    private final RubyContext context;

    public EncodingManager(RubyContext context) {
        this.context = context;
    }

    @CompilerDirectives.TruffleBoundary
    public static DynamicObject newRubyEncoding(RubyContext context, Encoding encoding, byte[] name, int p, int end, boolean dummy) {
        Rope rope = StringOperations.ropeFromByteList(new ByteList(name, p, end, (Encoding)USASCIIEncoding.INSTANCE, false));
        Rope cachedRope = context.getRopeTable().getRope(rope.getBytes(), rope.getEncoding(), rope.getCodeRange());
        DynamicObject string = context.getFrozenStrings().getFrozenString(cachedRope);
        return Layouts.ENCODING.createEncoding(context.getCoreLibrary().getEncodingFactory(), encoding, string, dummy);
    }

    public DynamicObject[] getUnsafeEncodingList() {
        return this.ENCODING_LIST_BY_ENCODING_LIST_INDEX;
    }

    public DynamicObject getRubyEncoding(Encoding encoding) {
        DynamicObject rubyEncoding = this.ENCODING_LIST_BY_ENCODING_INDEX[encoding.getIndex()];
        if (rubyEncoding == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.ENCODING_LIST_BY_ENCODING_INDEX[encoding.getIndex()] = rubyEncoding = this.LOOKUP.get(new String(encoding.getName(), StandardCharsets.UTF_8).toLowerCase(Locale.ENGLISH));
        }
        return rubyEncoding;
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject getRubyEncoding(String name) {
        return this.LOOKUP.get(name.toLowerCase(Locale.ENGLISH));
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject getRubyEncoding(int encodingListIndex) {
        return this.ENCODING_LIST_BY_ENCODING_LIST_INDEX[encodingListIndex];
    }

    @CompilerDirectives.TruffleBoundary
    public void defineEncoding(EncodingDB.Entry encodingEntry, byte[] name, int p, int end) {
        DynamicObject rubyEncoding;
        this.ENCODING_LIST_BY_ENCODING_LIST_INDEX[encodingEntry.getIndex()] = rubyEncoding = EncodingManager.newRubyEncoding(this.context, null, name, p, end, encodingEntry.isDummy());
        this.LOOKUP.put(Layouts.ENCODING.getName(rubyEncoding).toString().toLowerCase(Locale.ENGLISH), rubyEncoding);
    }

    @CompilerDirectives.TruffleBoundary
    public void defineAlias(int encodingListIndex, String name) {
        DynamicObject rubyEncoding = this.getRubyEncoding(encodingListIndex);
        this.LOOKUP.put(name.toLowerCase(Locale.ENGLISH), rubyEncoding);
    }

    @CompilerDirectives.TruffleBoundary
    public Encoding getLocaleEncoding() {
        return this.context.getJRubyRuntime().getEncodingService().getLocaleEncoding();
    }

    @CompilerDirectives.TruffleBoundary
    public static Charset charsetForEncoding(Encoding encoding) {
        String encodingName = encoding.toString();
        if (encodingName.equals("ASCII-8BIT")) {
            return Charset.forName("ISO-8859-1");
        }
        if (encoding == ISO8859_16Encoding.INSTANCE) {
            return ISO_8859_16.INSTANCE;
        }
        try {
            return Charset.forName(encodingName);
        }
        catch (UnsupportedCharsetException uce) {
            throw new UnsupportedOperationException("no java.nio.charset.Charset found for encoding `" + encoding.toString() + "'", uce);
        }
    }
}

