/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.ea.train.basic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.encog.Encog;
import org.encog.EncogError;
import org.encog.EncogShutdownTask;
import org.encog.mathutil.randomize.factory.RandomFactory;
import org.encog.ml.CalculateScore;
import org.encog.ml.MLContext;
import org.encog.ml.MLMethod;
import org.encog.ml.ea.codec.GeneticCODEC;
import org.encog.ml.ea.codec.GenomeAsPhenomeCODEC;
import org.encog.ml.ea.genome.Genome;
import org.encog.ml.ea.opp.EvolutionaryOperator;
import org.encog.ml.ea.opp.OperationList;
import org.encog.ml.ea.opp.selection.SelectionOperator;
import org.encog.ml.ea.opp.selection.TournamentSelection;
import org.encog.ml.ea.population.Population;
import org.encog.ml.ea.rules.BasicRuleHolder;
import org.encog.ml.ea.rules.RuleHolder;
import org.encog.ml.ea.score.AdjustScore;
import org.encog.ml.ea.score.parallel.ParallelScore;
import org.encog.ml.ea.sort.GenomeComparator;
import org.encog.ml.ea.sort.MaximizeAdjustedScoreComp;
import org.encog.ml.ea.sort.MaximizeScoreComp;
import org.encog.ml.ea.sort.MinimizeAdjustedScoreComp;
import org.encog.ml.ea.sort.MinimizeScoreComp;
import org.encog.ml.ea.species.SingleSpeciation;
import org.encog.ml.ea.species.Speciation;
import org.encog.ml.ea.species.Species;
import org.encog.ml.ea.train.EvolutionaryAlgorithm;
import org.encog.ml.ea.train.basic.EAWorker;
import org.encog.ml.genetic.GeneticError;
import org.encog.util.concurrency.MultiThreadable;
import org.encog.util.logging.EncogLogging;

public class BasicEA
implements EvolutionaryAlgorithm,
MultiThreadable,
EncogShutdownTask,
Serializable {
    private static final long serialVersionUID = 1L;
    private boolean ignoreExceptions;
    private GenomeComparator bestComparator;
    private GenomeComparator selectionComparator;
    private Population population;
    private final CalculateScore scoreFunction;
    private SelectionOperator selection;
    private final List<AdjustScore> adjusters = new ArrayList<AdjustScore>();
    private final OperationList operators = new OperationList();
    private GeneticCODEC codec = new GenomeAsPhenomeCODEC();
    private RandomFactory randomNumberFactory = Encog.getInstance().getRandomFactory().factorFactory();
    private boolean validationMode;
    private int iteration;
    private int threadCount;
    private int actualThreadCount = -1;
    private Speciation speciation = new SingleSpeciation();
    private Throwable reportedError;
    private Genome oldBestGenome;
    private final List<Genome> newPopulation = new ArrayList<Genome>();
    private EvolutionaryOperator champMutation;
    private double eliteRate = 0.3;
    private int maxTries = 5;
    private Genome bestGenome;
    private ExecutorService taskExecutor;
    private final List<Callable<Object>> threadList = new ArrayList<Callable<Object>>();
    private RuleHolder rules;
    private int maxOperationErrors = 500;

    public static void calculateScoreAdjustment(Genome genome, List<AdjustScore> adjusters) {
        double score = genome.getScore();
        double delta = 0.0;
        for (AdjustScore a : adjusters) {
            delta += a.calculateAdjustment(genome);
        }
        genome.setAdjustedScore(score + delta);
    }

    public BasicEA(Population thePopulation, CalculateScore theScoreFunction) {
        this.population = thePopulation;
        this.scoreFunction = theScoreFunction;
        this.selection = new TournamentSelection(this, 4);
        this.rules = new BasicRuleHolder();
        if (theScoreFunction.shouldMinimize()) {
            this.selectionComparator = new MinimizeAdjustedScoreComp();
            this.bestComparator = new MinimizeScoreComp();
        } else {
            this.selectionComparator = new MaximizeAdjustedScoreComp();
            this.bestComparator = new MaximizeScoreComp();
        }
        for (Species species : thePopulation.getSpecies()) {
            for (Genome genome : species.getMembers()) {
                this.setIteration(Math.max(this.getIteration(), genome.getBirthGeneration()));
            }
        }
        if (this.population.getSpecies().size() > 0 && this.population.getSpecies().get(0).getMembers().size() > 0) {
            this.bestGenome = this.population.getSpecies().get(0).getMembers().get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addChild(Genome genome) {
        List<Genome> list = this.newPopulation;
        synchronized (list) {
            if (this.newPopulation.size() < this.getPopulation().getPopulationSize()) {
                if (genome != this.oldBestGenome) {
                    if (this.isValidationMode() && this.newPopulation.contains(genome)) {
                        throw new EncogError("Genome already added to population: " + genome.toString());
                    }
                    this.newPopulation.add(genome);
                }
                if (!Double.isInfinite(genome.getScore()) && !Double.isNaN(genome.getScore()) && this.getBestComparator().isBetterThan(genome, this.bestGenome)) {
                    this.bestGenome = genome;
                    this.getPopulation().setBestGenome(this.bestGenome);
                }
                return true;
            }
            return false;
        }
    }

    @Override
    public void addOperation(double probability, EvolutionaryOperator opp) {
        this.getOperators().add(probability, opp);
        opp.init(this);
    }

    @Override
    public void addScoreAdjuster(AdjustScore scoreAdjust) {
        this.adjusters.add(scoreAdjust);
    }

    @Override
    public void calculateScore(Genome g) {
        double score;
        this.rules.rewrite(g);
        MLMethod phenotype = this.getCODEC().decode(g);
        if (phenotype == null) {
            score = this.getBestComparator().shouldMinimize() ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        } else {
            if (phenotype instanceof MLContext) {
                ((MLContext)phenotype).clearContext();
            }
            score = this.getScoreFunction().calculateScore(phenotype);
        }
        g.setScore(score);
        g.setAdjustedScore(score);
    }

    @Override
    public void finishTraining() {
        if (this.taskExecutor != null) {
            this.taskExecutor.shutdown();
            try {
                this.taskExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                throw new GeneticError(e);
            }
            finally {
                this.taskExecutor = null;
                Encog.getInstance().removeShutdownTask(this);
            }
        }
    }

    @Override
    public GenomeComparator getBestComparator() {
        return this.bestComparator;
    }

    @Override
    public Genome getBestGenome() {
        return this.bestGenome;
    }

    public EvolutionaryOperator getChampMutation() {
        return this.champMutation;
    }

    @Override
    public GeneticCODEC getCODEC() {
        return this.codec;
    }

    public double getEliteRate() {
        return this.eliteRate;
    }

    @Override
    public double getError() {
        double err;
        if (this.bestGenome != null && !Double.isNaN(err = this.bestGenome.getScore())) {
            return err;
        }
        if (this.getScoreFunction().shouldMinimize()) {
            return Double.POSITIVE_INFINITY;
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public int getIteration() {
        return this.iteration;
    }

    @Override
    public int getMaxIndividualSize() {
        return this.population.getMaxIndividualSize();
    }

    @Override
    public int getMaxTries() {
        return this.maxTries;
    }

    public Genome getOldBestGenome() {
        return this.oldBestGenome;
    }

    @Override
    public OperationList getOperators() {
        return this.operators;
    }

    @Override
    public Population getPopulation() {
        return this.population;
    }

    public RandomFactory getRandomNumberFactory() {
        return this.randomNumberFactory;
    }

    @Override
    public RuleHolder getRules() {
        return this.rules;
    }

    @Override
    public List<AdjustScore> getScoreAdjusters() {
        return this.adjusters;
    }

    @Override
    public CalculateScore getScoreFunction() {
        return this.scoreFunction;
    }

    @Override
    public SelectionOperator getSelection() {
        return this.selection;
    }

    @Override
    public GenomeComparator getSelectionComparator() {
        return this.selectionComparator;
    }

    @Override
    public boolean getShouldIgnoreExceptions() {
        return this.ignoreExceptions;
    }

    @Override
    public Speciation getSpeciation() {
        return this.speciation;
    }

    @Override
    public int getThreadCount() {
        return this.threadCount;
    }

    @Override
    public boolean isValidationMode() {
        return this.validationMode;
    }

    @Override
    public void iteration() {
        if (this.actualThreadCount == -1) {
            this.preIteration();
        }
        if (this.getPopulation().getSpecies().size() == 0) {
            throw new EncogError("Population is empty, there are no species.");
        }
        ++this.iteration;
        this.newPopulation.clear();
        this.newPopulation.add(this.bestGenome);
        this.oldBestGenome = this.bestGenome;
        this.threadList.clear();
        for (Species species : this.getPopulation().getSpecies()) {
            int numToSpawn = species.getOffspringCount();
            if (species.getMembers().size() > 5) {
                int idealEliteCount = (int)((double)species.getMembers().size() * this.getEliteRate());
                int eliteCount = Math.min(numToSpawn, idealEliteCount);
                for (int i = 0; i < eliteCount; ++i) {
                    Genome eliteGenome = species.getMembers().get(i);
                    if (this.getOldBestGenome() == eliteGenome) continue;
                    --numToSpawn;
                    if (!this.addChild(eliteGenome)) break;
                }
            }
            while (numToSpawn-- > 0) {
                EAWorker worker = new EAWorker(this, species);
                this.threadList.add(worker);
            }
        }
        try {
            this.taskExecutor.invokeAll(this.threadList);
        }
        catch (InterruptedException e) {
            EncogLogging.log(e);
        }
        if (this.reportedError != null && !this.getShouldIgnoreExceptions()) {
            throw new GeneticError(this.reportedError);
        }
        if (this.isValidationMode()) {
            if (this.oldBestGenome != null && !this.newPopulation.contains(this.oldBestGenome)) {
                throw new EncogError("The top genome died, this should never happen!!");
            }
            if (this.bestGenome != null && this.oldBestGenome != null && this.getBestComparator().isBetterThan(this.oldBestGenome, this.bestGenome)) {
                throw new EncogError("The best genome's score got worse, this should never happen!! Went from " + this.oldBestGenome.getScore() + " to " + this.bestGenome.getScore());
            }
        }
        this.speciation.performSpeciation(this.newPopulation);
        this.population.purgeInvalidGenomes();
    }

    @Override
    public void performShutdownTask() {
        this.finishTraining();
    }

    private void preIteration() {
        this.speciation.init(this);
        this.actualThreadCount = this.threadCount == 0 ? Runtime.getRuntime().availableProcessors() : this.threadCount;
        ParallelScore pscore = new ParallelScore(this.getPopulation(), this.getCODEC(), new ArrayList<AdjustScore>(), this.getScoreFunction(), this.actualThreadCount);
        pscore.setThreadCount(this.actualThreadCount);
        pscore.process();
        this.actualThreadCount = pscore.getThreadCount();
        this.taskExecutor = this.actualThreadCount == 1 ? Executors.newSingleThreadScheduledExecutor() : Executors.newFixedThreadPool(this.actualThreadCount);
        Encog.getInstance().addShutdownTask(this);
        List<Genome> list = this.getPopulation().flatten();
        int idx = 0;
        do {
            this.bestGenome = list.get(idx++);
        } while (idx < list.size() && (Double.isInfinite(this.bestGenome.getScore()) || Double.isNaN(this.bestGenome.getScore())));
        this.getPopulation().setBestGenome(this.bestGenome);
        List<Genome> genomes = this.getPopulation().flatten();
        this.speciation.performSpeciation(genomes);
        this.population.purgeInvalidGenomes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportError(Throwable t) {
        BasicEA basicEA = this;
        synchronized (basicEA) {
            if (this.reportedError == null) {
                this.reportedError = t;
            }
        }
    }

    @Override
    public void setBestComparator(GenomeComparator theComparator) {
        this.bestComparator = theComparator;
    }

    public void setChampMutation(EvolutionaryOperator champMutation) {
        this.champMutation = champMutation;
    }

    public void setCODEC(GeneticCODEC theCodec) {
        this.codec = theCodec;
    }

    public void setEliteRate(double eliteRate) {
        this.eliteRate = eliteRate;
    }

    public void setIteration(int iteration) {
        this.iteration = iteration;
    }

    public void setMaxTries(int maxTries) {
        this.maxTries = maxTries;
    }

    @Override
    public void setPopulation(Population thePopulation) {
        this.population = thePopulation;
    }

    public void setRandomNumberFactory(RandomFactory randomNumberFactory) {
        this.randomNumberFactory = randomNumberFactory;
    }

    @Override
    public void setRules(RuleHolder rules) {
        this.rules = rules;
    }

    @Override
    public void setSelection(SelectionOperator selection) {
        this.selection = selection;
    }

    @Override
    public void setSelectionComparator(GenomeComparator theComparator) {
        this.selectionComparator = theComparator;
    }

    @Override
    public void setShouldIgnoreExceptions(boolean b) {
        this.ignoreExceptions = b;
    }

    @Override
    public void setSpeciation(Speciation speciation) {
        this.speciation = speciation;
    }

    @Override
    public void setThreadCount(int numThreads) {
        this.threadCount = numThreads;
    }

    @Override
    public void setValidationMode(boolean validationMode) {
        this.validationMode = validationMode;
    }

    public int getMaxOperationErrors() {
        return this.maxOperationErrors;
    }

    public void setMaxOperationErrors(int maxOperationErrors) {
        this.maxOperationErrors = maxOperationErrors;
    }
}

