/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.genetic.crossover;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.encog.ml.ea.genome.Genome;
import org.encog.ml.ea.opp.EvolutionaryOperator;
import org.encog.ml.ea.train.EvolutionaryAlgorithm;
import org.encog.ml.genetic.GeneticError;
import org.encog.ml.genetic.genome.IntegerArrayGenome;

public class SpliceNoRepeat
implements EvolutionaryOperator {
    private EvolutionaryAlgorithm owner;
    private int cutLength;

    private static int getNotTaken(IntegerArrayGenome source, Set<Integer> taken) {
        for (int trial : source.getData()) {
            if (taken.contains(trial)) continue;
            taken.add(trial);
            return trial;
        }
        throw new GeneticError("Ran out of integers to select.");
    }

    public SpliceNoRepeat(int theCutLength) {
        this.cutLength = theCutLength;
    }

    @Override
    public void performOperation(Random rnd, Genome[] parents, int parentIndex, Genome[] offspring, int offspringIndex) {
        int i;
        IntegerArrayGenome mother = (IntegerArrayGenome)parents[parentIndex];
        IntegerArrayGenome father = (IntegerArrayGenome)parents[parentIndex + 1];
        IntegerArrayGenome offspring1 = (IntegerArrayGenome)this.owner.getPopulation().getGenomeFactory().factor();
        IntegerArrayGenome offspring2 = (IntegerArrayGenome)this.owner.getPopulation().getGenomeFactory().factor();
        offspring[offspringIndex] = offspring1;
        offspring[offspringIndex + 1] = offspring2;
        int geneLength = mother.size();
        int cutpoint1 = rnd.nextInt(geneLength - this.cutLength);
        int cutpoint2 = cutpoint1 + this.cutLength;
        HashSet<Integer> taken1 = new HashSet<Integer>();
        HashSet<Integer> taken2 = new HashSet<Integer>();
        for (i = 0; i < geneLength; ++i) {
            if (i < cutpoint1 || i > cutpoint2) continue;
            offspring1.copy(father, i, i);
            offspring2.copy(mother, i, i);
            taken1.add(father.getData()[i]);
            taken2.add(mother.getData()[i]);
        }
        for (i = 0; i < geneLength; ++i) {
            if (i >= cutpoint1 && i <= cutpoint2) continue;
            offspring1.getData()[i] = SpliceNoRepeat.getNotTaken(mother, taken1);
            offspring2.getData()[i] = SpliceNoRepeat.getNotTaken(father, taken2);
        }
    }

    @Override
    public int offspringProduced() {
        return 2;
    }

    @Override
    public int parentsNeeded() {
        return 2;
    }

    @Override
    public void init(EvolutionaryAlgorithm theOwner) {
        this.owner = theOwner;
    }
}

