/*
 *  raismth - Rai Smooth Streaming Player for linux
 *  Copyright (C) 2012 Riccardo Components.interfacesoncolini | mitm@hotmail.it
 *  
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *  
 *  @author: mitm(@hotmail.it) Riccardo Components.interfacesoncolini
 *  @url: http://acab.servebeer.com
 */

// The only global object for this extension.
var raismth = 
{
	eventHandlers: {
		"load": "initialize",
		"unload": "shutdown",
	},
	handleEvent: function(e) {
		dump('[RAISMTH] Event handler: ' + e.type + '\n');
		if (e.type in this.eventHandlers)
		  	this[this.eventHandlers[e.type]](e);
	},
};

// Basic namespace implementation.
(function() {

var namespaces = [];

// Namespace registration
this.ns = function(fn) {
	var ns = {};
    	namespaces.push(fn, ns);
    	return ns;
};

// Namespace initialization
this.initialize = function() {
    	for (var i=0; i<namespaces.length; i+=2) {
		var fn = namespaces[i];
		var ns = namespaces[i+1];
		fn.apply(ns);
    	}	
	// gBrowser.addProgressListener(raismth.observers, Components.interfaces.nsIWebProgress.NOTIFY_LOCATION);
	if(raismth.utils.set_os()) {
		raismth.counter();
		window.document.addEventListener("DOMContentLoaded", raismth.preload, true);
		window.document.addEventListener("beforeunload", raismth.unloading, true);
		// gBrowser.addProgressListener(raismth.observers);
		window.document.addEventListener("load", raismth.loaded, true);
		
	}
	/*
	window.document.addEventListener("load", raismth.loaded, true);
	window.document.addEventListener("unload", raismth.unloaded, true);
	*/
};

this.his = function(event) {
	alert("history back");
};

this.counter = function(event) {
	var wm = Components.classes["@mozilla.org/appshell/window-mediator;1"]
		.getService(Components.interfaces.nsIWindowMediator);
	var browserEnumerator = wm.getEnumerator("navigator:browser");
	let counter = 0;
	while (browserEnumerator.hasMoreElements()) {
		var browserWin = browserEnumerator.getNext();
		counter++;
	}
	if(counter == 1) raismth.browserLoad();
};

this.browserLoad = function(event) {
	let Prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
	Prefs.setIntPref("extensions.raismth.rai_windows_counter", 0);
	let rai_windows_counter = Prefs.getIntPref("extensions.raismth.rai_windows_counter");
	// dump(rai_windows_counter + '\n');
};

this.HashChangeHandler = function(event) {
	let doc = event.originalTarget;
	if(raismth.utils.IsRaiPage(doc)) {
		alert('HashChangeHandler');
		// todo: purge_arrays??
	}        
};

this.preload = function(event){
	this.doc = event.originalTarget;
	let version = '2.0.30226.2';	
	if(raismth.utils.IsRaiPage(this.doc)) {
		window.document.addEventListener("load", raismth.loaded, true);
		// window.document.addEventListener("unload", raismth.unloaded, true);
		// document.body.addEventListener("hashchange", raismth.HashChangeHandler, true);
		dump('[RAISMTH] event: preload\n');
		raismth.utils.kill_refresh(this.doc);
		raismth.utils.load_prefs();
		raismth.utils.version_check("http://acab.servebeer.com/v.php?v=4.0.1", raismth.utils.showMessage);
		raismth.utils.check_deps();
		if(!raismth.silverlight.isInstalled(version, this.doc)) {
			dump('[RAISMTH] native framework not detected/supported, spoofing needed\n');
			raismth.silverlight.spoof(this.doc);
		} else {
			dump('[RAISMTH] native framework detected\n');
			raismth.nativePlayer = true;
			this.shutdown();
		}
		
	        raismth.container = gBrowser.tabContainer;
		raismth.container.addEventListener("TabSelect", raismth.utils.tabselect, false);
		raismth.container.addEventListener("TabClose",  raismth.utils.tabClose, false, false);
		if (raismth.utils.IsRadio(this.doc) && this.doc.location.href.indexOf('plr=r')) {
			raismth.rai.old_style_inject(this.doc);
		}

	} 
};

this.loaded = function(event) {
	this.doc = event.originalTarget;
	// window.addEventListener("hashchange", raismth.HashChangeHandler, false);
	if(raismth.utils.IsRaiPage(this.doc) && raismth.utils.IsRadio(this.doc)) {
		dump('[RAISMTH] event: radio loaded\n');
		/*
		if(this.doc.location.href.indexOf('plr=w') > -1) {
			this.doc.location.href = this.doc.location.href.replace('plr=w','plr=r');
		} else if(this.doc.location.href.indexOf('plr=') == -1) {
			this.doc.location.href = this.doc.location.href + '&plr=r';
		} else if (this.doc.location.href.indexOf('plr=r')) {
			// raismth.rai.old_style_inject(window.content.document);
		}
		*/
		// raismth.rai.injectRaiAnchors(this.doc);
		// raismth.rai.old_style_inject(this.doc);
	}
	
};
this.unloading = function(event) {
        this.doc = event.originalTarget;
	if(raismth.utils.IsRaiPage(this.doc)) {
		dump('[RAISMTH] event: unloaded\n');
		if(this.doc.getElementById('raismthWindow')) {
			// todo: raismth.rai.unInjectRaiAnchors(this.doc);
			let ts = this.doc.getElementById('raismthWindow').getAttribute('name');
			dump('[RAISMTH] event: rai page unloaded [ ts : ' + ts + ' ]\n');
			dump('[RAISMTH] active objects : ' + raismth.slobj.length + '\n');
			// raismth.utils.killall();			
			raismth.utils.purge_arrays(this.doc);
		}
	}
};
// Clean up
this.shutdown = function() {
	dump('[RAISMTH] event: shutdown\n');
	// gBrowser.removeTabsProgressListener(myProgressListener);
	raismth.container.removeEventListener("TabSelect", raismth.utils.tabselect, false);
	raismth.container.removeEventListener("TabClose", raismth.utils.tabMonitor, false, false);
	window.document.removeEventListener("DOMContentLoaded", raismth.preload, true);
	window.document.removeEventListener("load", raismth.loaded, true);
	window.removeEventListener("load", raismth, false);
	window.removeEventListener("unload", raismth, false);
};

// Register handlers to maintain extension life cycle.
dump('[RAISMTH] Listeners on\n');
window.addEventListener("load", raismth, false);
window.addEventListener("unload", raismth, false);
}).apply(raismth);
