/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import jogamp.graph.font.typecast.ot.table.CffTable;
import jogamp.graph.font.typecast.ot.table.Charstring;

public class CharstringType2
extends Charstring {
    private static final String[] _oneByteOperators = new String[]{"-Reserved-", "hstem", "-Reserved-", "vstem", "vmoveto", "rlineto", "hlineto", "vlineto", "rrcurveto", "-Reserved-", "callsubr", "return", "escape", "-Reserved-", "endchar", "-Reserved-", "-Reserved-", "-Reserved-", "hstemhm", "hintmask", "cntrmask", "rmoveto", "hmoveto", "vstemhm", "rcurveline", "rlinecurve", "vvcurveto", "hhcurveto", "shortint", "callgsubr", "vhcurveto", "hvcurveto"};
    private static final String[] _twoByteOperators = new String[]{"-Reserved- (dotsection)", "-Reserved-", "-Reserved-", "and", "or", "not", "-Reserved-", "-Reserved-", "-Reserved-", "abs", "add", "sub", "div", "-Reserved-", "neg", "eq", "-Reserved-", "-Reserved-", "drop", "-Reserved-", "put", "get", "ifelse", "random", "mul", "-Reserved-", "sqrt", "dup", "exch", "index", "roll", "-Reserved-", "-Reserved-", "-Reserved-", "hflex", "flex", "hflex1", "flex1", "-Reserved-"};
    private int _index;
    private String _name;
    private int[] _data;
    private int _offset;
    private int _length;
    private CffTable.Index _localSubrIndex;
    private CffTable.Index _globalSubrIndex;
    private int _ip;

    protected CharstringType2(int n, String string, int[] nArray, int n2, int n3, CffTable.Index index, CffTable.Index index2) {
        this._index = n;
        this._name = string;
        this._data = nArray;
        this._offset = n2;
        this._length = n3;
        this._localSubrIndex = index;
        this._globalSubrIndex = index2;
    }

    @Override
    public int getIndex() {
        return this._index;
    }

    @Override
    public String getName() {
        return this._name;
    }

    private void disassemble(StringBuilder stringBuilder) {
        String string;
        Number number = null;
        while (this.isOperandAtIndex()) {
            number = this.nextOperand();
            stringBuilder.append(number).append(" ");
        }
        int n = this.nextByte();
        if (n == 12) {
            n = this.nextByte();
            if (n > 38) {
                n = 38;
            }
            string = _twoByteOperators[n];
        } else {
            string = _oneByteOperators[n];
        }
        stringBuilder.append(string);
    }

    public void resetIP() {
        this._ip = this._offset;
    }

    public boolean isOperandAtIndex() {
        int n = this._data[this._ip];
        return 32 <= n && n <= 255 || n == 28;
    }

    public Number nextOperand() {
        int n = this._data[this._ip];
        if (32 <= n && n <= 246) {
            ++this._ip;
            return new Integer(n - 139);
        }
        if (247 <= n && n <= 250) {
            int n2 = this._data[this._ip + 1];
            this._ip += 2;
            return new Integer((n - 247) * 256 + n2 + 108);
        }
        if (251 <= n && n <= 254) {
            int n3 = this._data[this._ip + 1];
            this._ip += 2;
            return new Integer(-(n - 251) * 256 - n3 - 108);
        }
        if (n == 28) {
            int n4 = this._data[this._ip + 1];
            int n5 = this._data[this._ip + 2];
            this._ip += 3;
            return new Integer(n4 << 8 | n5);
        }
        if (n == 255) {
            byte by = (byte)this._data[this._ip + 1];
            int n6 = this._data[this._ip + 2];
            int n7 = this._data[this._ip + 3];
            int n8 = this._data[this._ip + 4];
            this._ip += 5;
            return new Float((double)(by << 8 | n6) + (double)(n7 << 8 | n8) / 65536.0);
        }
        return null;
    }

    public int nextByte() {
        return this._data[this._ip++];
    }

    public boolean moreBytes() {
        return this._ip < this._offset + this._length;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.resetIP();
        while (this.moreBytes()) {
            this.disassemble(stringBuilder);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

