/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.file.BufferedStreamingHasher;
import org.gradle.api.internal.file.FileTreeElementComparator;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.serialize.Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTreeElementHasher {
    private static final byte HASH_PATH_SEPARATOR = 47;
    private static final byte HASH_FIELD_SEPARATOR = 9;
    private static final byte HASH_RECORD_SEPARATOR = 10;

    public static final int calculateHashForFileMetadata(Collection<? extends FileTreeElement> allFileTreeElements) {
        FileTreeElement[] sortedFileTreeElement = FileTreeElementHasher.sortForHashing(allFileTreeElements);
        BufferedStreamingHasher hasher = new BufferedStreamingHasher();
        Encoder encoder = hasher.getEncoder();
        try {
            for (FileTreeElement fileTreeElement : sortedFileTreeElement) {
                for (String pathPart : fileTreeElement.getRelativePath().getSegments()) {
                    encoder.writeString((CharSequence)pathPart);
                    encoder.writeByte((byte)47);
                }
                if (!fileTreeElement.isDirectory()) {
                    encoder.writeByte((byte)9);
                    encoder.writeLong(fileTreeElement.getSize());
                    encoder.writeByte((byte)9);
                    encoder.writeLong(fileTreeElement.getLastModified());
                }
                encoder.writeByte((byte)10);
            }
            return hasher.checksum();
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public static Hasher createHasher() {
        return Hashing.crc32().newHasher();
    }

    public static final int calculateHashForFilePaths(Collection<? extends FileTreeElement> allFileTreeElements) {
        FileTreeElement[] sortedFileTreeElement = FileTreeElementHasher.sortForHashing(allFileTreeElements);
        BufferedStreamingHasher hasher = new BufferedStreamingHasher();
        Encoder encoder = hasher.getEncoder();
        try {
            for (FileTreeElement fileTreeElement : sortedFileTreeElement) {
                for (String pathPart : fileTreeElement.getRelativePath().getSegments()) {
                    encoder.writeString((CharSequence)pathPart);
                    encoder.writeByte((byte)47);
                }
                encoder.writeByte((byte)10);
            }
            return hasher.checksum();
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private static FileTreeElement[] sortForHashing(Collection<? extends FileTreeElement> allFileTreeElements) {
        FileTreeElement[] sortedFileTreeElement = allFileTreeElements.toArray(new FileTreeElement[0]);
        Arrays.sort(sortedFileTreeElement, FileTreeElementComparator.INSTANCE);
        return sortedFileTreeElement;
    }
}

