/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model.internal;

import org.gradle.api.Project;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.eclipse.model.ProjectDependency;
import org.gradle.plugins.ide.internal.resolver.model.IdeProjectDependency;
import org.gradle.util.DeprecationLogger;

public class ProjectDependencyBuilder {
    public ProjectDependency build(IdeProjectDependency dependency) {
        return this.buildProjectDependency(this.determineProjectName(dependency), dependency.getProjectPath(), dependency.getDeclaredConfiguration());
    }

    private String determineProjectName(IdeProjectDependency dependency) {
        Project project = dependency.getProject();
        if (project == null) {
            return dependency.getModuleName();
        }
        if (project.getPlugins().hasPlugin(EclipsePlugin.class)) {
            return ((EclipseModel)((Object)project.getExtensions().getByType(EclipseModel.class))).getProject().getName();
        }
        return project.getName();
    }

    private ProjectDependency buildProjectDependency(String name, String projectPath, final String declaredConfigurationName) {
        final ProjectDependency out = new ProjectDependency("/" + name, projectPath);
        out.setExported(false);
        DeprecationLogger.whileDisabled((Runnable)new Runnable(){

            public void run() {
                out.setDeclaredConfigurationName(declaredConfigurationName);
            }
        });
        return out;
    }
}

