/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes;

import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.AbstractModuleExcludeRuleFilter;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.IvyArtifactName;

class IvyPatternMatcherExcludeRuleSpec
extends AbstractModuleExcludeRuleFilter {
    private final ModuleIdentifier moduleId;
    private final IvyArtifactName ivyArtifactName;
    private final PatternMatcher matcher;
    private final boolean isArtifactExclude;

    IvyPatternMatcherExcludeRuleSpec(ExcludeRule rule) {
        this.moduleId = DefaultModuleIdentifier.newId(rule.getId().getModuleId().getOrganisation(), rule.getId().getModuleId().getName());
        this.ivyArtifactName = new DefaultIvyArtifactName(rule.getId().getName(), rule.getId().getType(), rule.getId().getExt());
        this.matcher = rule.getMatcher();
        this.isArtifactExclude = !IvyPatternMatcherExcludeRuleSpec.isWildcard(this.ivyArtifactName.getName()) || !IvyPatternMatcherExcludeRuleSpec.isWildcard(this.ivyArtifactName.getType()) || !IvyPatternMatcherExcludeRuleSpec.isWildcard(this.ivyArtifactName.getExtension());
    }

    public String toString() {
        return String.format("{exclude-rule %s:%s with matcher %s}", this.moduleId, this.ivyArtifactName, this.matcher.getName());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        IvyPatternMatcherExcludeRuleSpec other = (IvyPatternMatcherExcludeRuleSpec)o;
        return this.doAcceptsSameModulesAs(other);
    }

    public int hashCode() {
        return this.moduleId.hashCode() ^ this.ivyArtifactName.hashCode();
    }

    protected boolean doAcceptsSameModulesAs(AbstractModuleExcludeRuleFilter other) {
        IvyPatternMatcherExcludeRuleSpec otherSpec = (IvyPatternMatcherExcludeRuleSpec)other;
        return this.moduleId.equals(otherSpec.moduleId) && this.ivyArtifactName.equals(otherSpec.ivyArtifactName) && this.matcher.getName().equals(otherSpec.matcher.getName());
    }

    protected boolean acceptsAllModules() {
        return this.isArtifactExclude;
    }

    public boolean acceptModule(ModuleIdentifier module) {
        return this.isArtifactExclude || !this.matches(this.moduleId.getGroup(), module.getGroup()) || !this.matches(this.moduleId.getName(), module.getName());
    }

    public boolean acceptArtifact(ModuleIdentifier module, IvyArtifactName artifact) {
        if (this.isArtifactExclude) {
            return !this.matches(this.moduleId.getGroup(), module.getGroup()) || !this.matches(this.moduleId.getName(), module.getName()) || !this.matches(this.ivyArtifactName.getName(), artifact.getName()) || !this.matches(this.ivyArtifactName.getExtension(), artifact.getExtension()) || !this.matches(this.ivyArtifactName.getType(), artifact.getType());
        }
        return true;
    }

    public boolean acceptsAllArtifacts() {
        return !this.isArtifactExclude;
    }

    private boolean matches(String expression, String input) {
        return this.matcher.getMatcher(expression).matches(input);
    }
}

