/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import groovy.lang.Closure;
import java.io.File;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.PublishException;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.internal.artifacts.ArtifactPublicationServices;
import org.gradle.api.internal.artifacts.ArtifactPublisher;
import org.gradle.api.internal.artifacts.ModuleInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.repositories.PublicationAwareRepository;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.Transformers;
import org.gradle.util.CollectionUtils;
import org.gradle.util.ConfigureUtil;

public class Upload
extends ConventionTask {
    private Configuration configuration;
    private boolean uploadDescriptor;
    private File descriptorDestination;
    private RepositoryHandler repositories;

    @Inject
    protected ArtifactPublicationServices getPublicationServices() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    protected void upload() {
        this.getLogger().info("Publishing configuration: " + this.configuration);
        ModuleInternal module = ((ConfigurationInternal)this.configuration).getModule();
        ArtifactPublisher artifactPublisher = this.getPublicationServices().createArtifactPublisher();
        File descriptorDestination = this.isUploadDescriptor() ? this.getDescriptorDestination() : null;
        List publishRepositories = CollectionUtils.collect((List)this.getRepositories(), (Transformer)Transformers.cast(PublicationAwareRepository.class));
        try {
            artifactPublisher.publish((Iterable)publishRepositories, module, this.configuration, descriptorDestination);
        }
        catch (Exception e) {
            throw new PublishException(String.format("Could not publish configuration '%s'", this.configuration.getName()), (Throwable)e);
        }
    }

    public boolean isUploadDescriptor() {
        return this.uploadDescriptor;
    }

    public void setUploadDescriptor(boolean uploadDescriptor) {
        this.uploadDescriptor = uploadDescriptor;
    }

    public File getDescriptorDestination() {
        return this.descriptorDestination;
    }

    public void setDescriptorDestination(File descriptorDestination) {
        this.descriptorDestination = descriptorDestination;
    }

    public RepositoryHandler getRepositories() {
        if (this.repositories == null) {
            this.repositories = this.getPublicationServices().createRepositoryHandler();
        }
        return this.repositories;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public RepositoryHandler repositories(Closure configureClosure) {
        return (RepositoryHandler)ConfigureUtil.configure((Closure)configureClosure, (Object)this.getRepositories());
    }

    @InputFiles
    public FileCollection getArtifacts() {
        Configuration configuration = this.getConfiguration();
        return configuration == null ? null : configuration.getAllArtifacts().getFiles();
    }
}

