/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.draw;

import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.gui.draw.MapPath2D;
import org.openstreetmap.josm.gui.draw.SymbolShape;

public class MapViewPath
extends MapPath2D {
    private final MapViewState state;

    public MapViewPath(MapView mapView) {
        this(mapView.getState());
    }

    public MapViewPath(MapViewState mapViewState) {
        this.state = mapViewState;
    }

    public MapViewPath moveTo(Node node) {
        this.moveTo(node.getEastNorth());
        return this;
    }

    public MapViewPath moveTo(EastNorth eastNorth) {
        this.moveTo(this.state.getPointFor(eastNorth));
        return this;
    }

    @Override
    public MapViewPath moveTo(MapViewState.MapViewPoint mapViewPoint) {
        super.moveTo(mapViewPoint);
        return this;
    }

    public MapViewPath lineTo(Node node) {
        this.lineTo(node.getEastNorth());
        return this;
    }

    public MapViewPath lineTo(EastNorth eastNorth) {
        this.lineTo(this.state.getPointFor(eastNorth));
        return this;
    }

    @Override
    public MapViewPath lineTo(MapViewState.MapViewPoint mapViewPoint) {
        super.lineTo(mapViewPoint);
        return this;
    }

    public MapViewPath shapeAround(Node node, SymbolShape symbolShape, double d) {
        this.shapeAround(node.getEastNorth(), symbolShape, d);
        return this;
    }

    public MapViewPath shapeAround(EastNorth eastNorth, SymbolShape symbolShape, double d) {
        this.shapeAround(this.state.getPointFor(eastNorth), symbolShape, d);
        return this;
    }

    @Override
    public MapViewPath shapeAround(MapViewState.MapViewPoint mapViewPoint, SymbolShape symbolShape, double d) {
        super.shapeAround(mapViewPoint, symbolShape, d);
        return this;
    }

    public MapViewPath append(Iterable<Node> iterable, boolean bl) {
        this.appendWay(iterable, bl, false);
        return this;
    }

    public MapViewPath appendClosed(Iterable<Node> iterable, boolean bl) {
        this.appendWay(iterable, bl, true);
        return this;
    }

    private void appendWay(Iterable<Node> iterable, boolean bl, boolean bl2) {
        boolean bl3 = !bl;
        Node node = null;
        for (Node node2 : iterable) {
            if (bl3) {
                this.moveTo(node2);
            } else {
                this.lineTo(node2);
            }
            if (bl2 && node == null) {
                node = node2;
            }
            bl3 = false;
        }
        if (node != null) {
            this.lineTo(node);
        }
    }
}

