/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.ui.tablemodels;

import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.table.AbstractTableModel;

public class SingleColumnModel
extends AbstractTableModel {
    private static final long serialVersionUID = 7819538656432704429L;
    private final String columnName;
    private final ArrayList<String> dataVector;

    public SingleColumnModel(String columnName) {
        this.columnName = columnName;
        this.dataVector = new ArrayList();
    }

    public String[] getAllRows() {
        this.dataVector.trimToSize();
        String[] outputCategories = new String[this.dataVector.size()];
        return this.dataVector.toArray(outputCategories);
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnName;
    }

    @Override
    public int getRowCount() {
        return this.dataVector.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.dataVector.get(row);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void setData(String[] values) {
        this.fireTableRowsDeleted(0, this.getRowCount());
        this.dataVector.clear();
        if (values == null) {
            return;
        }
        this.dataVector.addAll(Arrays.asList(values));
        this.fireTableRowsInserted(0, values.length);
        this.dataVector.trimToSize();
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this.dataVector.set(row, value.toString());
        this.fireTableCellUpdated(row, col);
    }
}

