/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.network;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.parosproxy.paros.network.HttpBody;

public class HttpResponseBody
extends HttpBody {
    private static final Logger log = Logger.getLogger(HttpResponseBody.class);
    private static final Pattern patternCharset = Pattern.compile("<META +[^>]+charset *= *['\\x22]?([^>'\\x22;]+)['\\x22]? *[/]?>", 2);

    public HttpResponseBody() {
    }

    public HttpResponseBody(int n) {
        super(n);
    }

    public HttpResponseBody(String string) {
        super(string);
    }

    public HttpResponseBody(byte[] byArray) {
        super(byArray);
    }

    @Override
    protected String createString(Charset charset) {
        if (charset != null) {
            return super.createString(charset);
        }
        return this.createStringWithMetaCharset();
    }

    private String createStringWithMetaCharset() {
        String string = null;
        String string2 = null;
        try {
            string2 = new String(this.getBytes(), 0, this.getPos(), StandardCharsets.ISO_8859_1);
            Matcher matcher = patternCharset.matcher(string2);
            if (matcher.find()) {
                String string3 = matcher.group(1);
                string = new String(this.getBytes(), 0, this.getPos(), string3);
                this.setCharset(string3);
            } else {
                String string4 = this.toUTF8();
                if (string4 != null) {
                    this.setCharset(StandardCharsets.UTF_8.name());
                    string = string4;
                } else {
                    string = string2;
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.error((Object)("Unable to encode with the (X)HTML meta charset: " + unsupportedEncodingException.getMessage()));
            log.warn((Object)("Using default charset: " + DEFAULT_CHARSET));
            string = string2;
        }
        return string;
    }

    private String toUTF8() {
        String string = new String(this.getBytes(), 0, this.getPos(), StandardCharsets.UTF_8);
        int n = string.getBytes(StandardCharsets.UTF_8).length;
        if (this.getPos() != n) {
            return null;
        }
        return string;
    }
}

