/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;
import org.eclipse.swt.internal.theme.ToolBarDrawData;

public class ToolItemDrawData
extends DrawData {
    public ToolBarDrawData parent;
    static final int ARROW_WIDTH = 8;
    static final int ARROW_HEIGHT = 6;

    public ToolItemDrawData() {
        this.state = new int[2];
    }

    @Override
    Rectangle computeTrim(Theme theme, GC gC) {
        int n = theme.buttonHandle;
        int n2 = this.gtk_widget_get_style(n);
        int n3 = theme.getWidgetProperty(n, "focus-line-width");
        int n4 = theme.getWidgetProperty(n, "focus-padding");
        int n5 = OS.gtk_style_get_xthickness(n2);
        int n6 = OS.gtk_style_get_ythickness(n2);
        int n7 = n5 + n3 + n4;
        int n8 = n6 + n3 + n4;
        int n9 = this.clientArea.x - n7;
        int n10 = this.clientArea.y - n8;
        int n11 = this.clientArea.width + 2 * n7;
        int n12 = this.clientArea.height + 2 * n8;
        if ((this.style & 4) != 0) {
            n11 += 8;
        }
        return new Rectangle(n9, n10, n11, n12);
    }

    @Override
    void draw(Theme theme, GC gC, Rectangle rectangle) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = this.state[0];
        int n7 = n5 = OS.GTK3 ? gC.getGCData().cairo : gC.getGCData().drawable;
        if ((this.style & 2) != 0) {
            int n8 = this.getStateType(0);
            int n9 = theme.separatorHandle;
            byte[] byArray = Converter.wcsToMbcs(null, "vseparator", true);
            int n10 = this.gtk_widget_get_style(n9);
            theme.transferClipping(gC, n10);
            if ((this.parent.style & 0x200) != 0) {
                if (OS.GTK3) {
                    OS.gtk_render_line(n10, n5, rectangle.x, rectangle.y + rectangle.height / 2, rectangle.x + rectangle.width, rectangle.y + rectangle.height / 2);
                } else {
                    OS.gtk_paint_hline(n10, n5, n8, null, n9, byArray, rectangle.x, rectangle.x + rectangle.width, rectangle.y + rectangle.height / 2);
                }
            } else if (OS.GTK3) {
                OS.gtk_render_line(n10, n5, rectangle.x + rectangle.width / 2, rectangle.y, rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height);
            } else {
                OS.gtk_paint_vline(n10, n5, n8, null, n9, byArray, rectangle.y, rectangle.y + rectangle.height, rectangle.x + rectangle.width / 2);
            }
            return;
        }
        int n11 = theme.buttonHandle;
        int n12 = this.gtk_widget_get_style(n11);
        theme.transferClipping(gC, n12);
        int n13 = theme.getWidgetProperty(n11, "focus-line-width");
        int n14 = theme.getWidgetProperty(n11, "focus-padding");
        int n15 = OS.gtk_container_get_border_width(n11);
        int n16 = rectangle.x + n15;
        int n17 = rectangle.y + n15;
        int n18 = rectangle.width - n15 * 2;
        int n19 = rectangle.height - n15 * 2;
        byte[] byArray = null;
        if ((this.style & 0xC) != 0) {
            byArray = Converter.wcsToMbcs(null, "button", true);
        } else if ((this.style & 0x30) != 0) {
            byArray = Converter.wcsToMbcs(null, "togglebutton", true);
        }
        int[] nArray = new int[1];
        int n20 = theme.toolbarHandle;
        OS.gtk_widget_style_get(n20, OS.button_relief, nArray, 0);
        int n21 = 2;
        if ((n6 & 0xA) != 0) {
            n21 = 1;
        }
        int n22 = this.getStateType(0);
        if (nArray[0] != 2 || (n6 & 0x4A) != 0) {
            this.gtk_render_box(n12, n5, n22, n21, null, n11, byArray, n16, n17, n18, n19);
        }
        if (this.clientArea != null) {
            this.clientArea.x = rectangle.x + n15;
            this.clientArea.y = rectangle.y + n15;
            this.clientArea.width = rectangle.width - 2 * n15;
            this.clientArea.height = rectangle.height - 2 * n15;
        }
        int n23 = OS.gtk_style_get_xthickness(n12);
        int n24 = theme.getWidgetProperty(n11, "interior-focus");
        if ((this.style & 4) != 0) {
            n4 = 8;
            n3 = 6;
            n2 = n16 + n18 - n4 - n23 - n14;
            if (n24 == 0) {
                n2 -= n13;
            }
            n = n17 + (n19 - n3) / 2;
            byte[] byArray2 = Converter.wcsToMbcs(null, "arrow", true);
            this.gtk_render_arrow(n12, n5, n22, 0, null, theme.arrowHandle, byArray2, 1, true, n2, n, n4, n3);
            if (this.clientArea != null) {
                this.clientArea.width -= rectangle.x + rectangle.width - n2;
            }
        }
        if ((n6 & 4) != 0) {
            n4 = theme.getWidgetProperty(n11, "child-displacement-y");
            n3 = theme.getWidgetProperty(n11, "child-displacement-x");
            n2 = theme.getWidgetProperty(n11, "displace-focus");
            if (n24 != 0) {
                n = OS.gtk_style_get_ythickness(n12);
                n16 += n23 + n14;
                n17 += n + n14;
                n18 -= 2 * (n23 + n14);
                n19 -= 2 * (n + n14);
            } else {
                n16 -= n13 + n14;
                n17 -= n13 + n14;
                n18 += 2 * (n13 + n14);
                n19 += 2 * (n13 + n14);
            }
            if ((n6 & 0xA) != 0 && n2 != 0) {
                n16 += n3;
                n17 += n4;
            }
            this.gtk_render_focus(n12, n5, n22, null, n11, byArray, n16, n17, n18, n19);
        }
    }

    @Override
    int hit(Theme theme, Point point, Rectangle rectangle) {
        if (!rectangle.contains(point)) {
            return -1;
        }
        if ((this.style & 4) != 0) {
            int n = theme.buttonHandle;
            int n2 = this.gtk_widget_get_style(n);
            int n3 = OS.gtk_style_get_xthickness(n2);
            int n4 = theme.getWidgetProperty(n, "interior-focus");
            int n5 = theme.getWidgetProperty(n, "focus-line-width");
            int n6 = theme.getWidgetProperty(n, "focus-padding");
            int n7 = 8;
            int n8 = rectangle.x + rectangle.width - n7 - n3 - n6;
            if (n4 == 0) {
                n8 -= n5;
            }
            if (n8 <= point.x) {
                return 1;
            }
        }
        return 0;
    }
}

