/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Kit;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Token;
import org.mozilla.javascript.UintMap;

public class Decompiler {
    public static final int ONLY_BODY_FLAG = 1;
    public static final int TO_SOURCE_FLAG = 2;
    public static final int INITIAL_INDENT_PROP = 1;
    public static final int INDENT_GAP_PROP = 2;
    public static final int CASE_GAP_PROP = 3;
    private static final int FUNCTION_END = 165;
    private char[] sourceBuffer = new char[128];
    private int sourceTop;
    private static final boolean printSource = false;

    String getEncodedSource() {
        return this.sourceToString(0);
    }

    int getCurrentOffset() {
        return this.sourceTop;
    }

    int markFunctionStart(int n) {
        int n2 = this.getCurrentOffset();
        this.addToken(109);
        this.append((char)n);
        return n2;
    }

    int markFunctionEnd(int n) {
        int n2 = this.getCurrentOffset();
        this.append('\u00a5');
        return n2;
    }

    void addToken(int n) {
        if (0 > n || n > 164) {
            throw new IllegalArgumentException();
        }
        this.append((char)n);
    }

    void addEOL(int n) {
        if (0 > n || n > 164) {
            throw new IllegalArgumentException();
        }
        this.append((char)n);
        this.append('\u0001');
    }

    void addName(String string) {
        this.addToken(39);
        this.appendString(string);
    }

    void addString(String string) {
        this.addToken(41);
        this.appendString(string);
    }

    void addRegexp(String string, String string2) {
        this.addToken(48);
        this.appendString('/' + string + '/' + string2);
    }

    void addNumber(double d) {
        this.addToken(40);
        long l = (long)d;
        if ((double)l != d) {
            l = Double.doubleToLongBits(d);
            this.append('D');
            this.append((char)(l >> 48));
            this.append((char)(l >> 32));
            this.append((char)(l >> 16));
            this.append((char)l);
        } else {
            if (l < 0L) {
                Kit.codeBug();
            }
            if (l <= 65535L) {
                this.append('S');
                this.append((char)l);
            } else {
                this.append('J');
                this.append((char)(l >> 48));
                this.append((char)(l >> 32));
                this.append((char)(l >> 16));
                this.append((char)l);
            }
        }
    }

    private void appendString(String string) {
        int n;
        int n2 = string.length();
        int n3 = 1;
        if (n2 >= 32768) {
            n3 = 2;
        }
        if ((n = this.sourceTop + n3 + n2) > this.sourceBuffer.length) {
            this.increaseSourceCapacity(n);
        }
        if (n2 >= 32768) {
            this.sourceBuffer[this.sourceTop] = (char)(0x8000 | n2 >>> 16);
            ++this.sourceTop;
        }
        this.sourceBuffer[this.sourceTop] = (char)n2;
        ++this.sourceTop;
        string.getChars(0, n2, this.sourceBuffer, this.sourceTop);
        this.sourceTop = n;
    }

    private void append(char c) {
        if (this.sourceTop == this.sourceBuffer.length) {
            this.increaseSourceCapacity(this.sourceTop + 1);
        }
        this.sourceBuffer[this.sourceTop] = c;
        ++this.sourceTop;
    }

    private void increaseSourceCapacity(int n) {
        int n2;
        if (n <= this.sourceBuffer.length) {
            Kit.codeBug();
        }
        if ((n2 = this.sourceBuffer.length * 2) < n) {
            n2 = n;
        }
        char[] cArray = new char[n2];
        System.arraycopy(this.sourceBuffer, 0, cArray, 0, this.sourceTop);
        this.sourceBuffer = cArray;
    }

    private String sourceToString(int n) {
        if (n < 0 || this.sourceTop < n) {
            Kit.codeBug();
        }
        return new String(this.sourceBuffer, n, this.sourceTop - n);
    }

    public static String decompile(String string, int n, UintMap uintMap) {
        int n2;
        int n3;
        int n4 = string.length();
        if (n4 == 0) {
            return "";
        }
        int n5 = uintMap.getInt(1, 0);
        if (n5 < 0) {
            throw new IllegalArgumentException();
        }
        int n6 = uintMap.getInt(2, 4);
        if (n6 < 0) {
            throw new IllegalArgumentException();
        }
        int n7 = uintMap.getInt(3, 2);
        if (n7 < 0) {
            throw new IllegalArgumentException();
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = 0 != (n & 1);
        boolean bl2 = 0 != (n & 2);
        int n8 = 0;
        boolean bl3 = false;
        int n9 = 0;
        if (string.charAt(n9) == '\u0088') {
            ++n9;
            n3 = -1;
        } else {
            n3 = string.charAt(n9 + 1);
        }
        if (!bl2) {
            stringBuilder.append('\n');
            for (n2 = 0; n2 < n5; ++n2) {
                stringBuilder.append(' ');
            }
        } else if (n3 == 2) {
            stringBuilder.append('(');
        }
        block100: while (n9 < n4) {
            switch (string.charAt(n9)) {
                case '\u0097': 
                case '\u0098': 
                case '\u00a3': {
                    if (string.charAt(n9) == '\u0097') {
                        stringBuilder.append("get ");
                    } else if (string.charAt(n9) == '\u0098') {
                        stringBuilder.append("set ");
                    }
                    ++n9;
                    n9 = Decompiler.printSourceString(string, n9 + 1, false, stringBuilder);
                    ++n9;
                    break;
                }
                case '\'': 
                case '0': {
                    n9 = Decompiler.printSourceString(string, n9 + 1, false, stringBuilder);
                    continue block100;
                }
                case ')': {
                    n9 = Decompiler.printSourceString(string, n9 + 1, true, stringBuilder);
                    continue block100;
                }
                case '(': {
                    n9 = Decompiler.printSourceNumber(string, n9 + 1, stringBuilder);
                    continue block100;
                }
                case '-': {
                    stringBuilder.append("true");
                    break;
                }
                case ',': {
                    stringBuilder.append("false");
                    break;
                }
                case '*': {
                    stringBuilder.append("null");
                    break;
                }
                case '+': {
                    stringBuilder.append("this");
                    break;
                }
                case 'm': {
                    ++n9;
                    stringBuilder.append("function ");
                    break;
                }
                case '\u00a5': {
                    break;
                }
                case 'Y': {
                    stringBuilder.append(", ");
                    break;
                }
                case 'U': {
                    ++n8;
                    if (1 == Decompiler.getNext(string, n4, n9)) {
                        n5 += n6;
                    }
                    stringBuilder.append('{');
                    break;
                }
                case 'V': {
                    if (bl && --n8 == 0) break;
                    stringBuilder.append('}');
                    switch (Decompiler.getNext(string, n4, n9)) {
                        case 1: 
                        case 165: {
                            n5 -= n6;
                            break;
                        }
                        case 113: 
                        case 117: {
                            n5 -= n6;
                            stringBuilder.append(' ');
                        }
                    }
                    break;
                }
                case 'W': {
                    stringBuilder.append('(');
                    break;
                }
                case 'X': {
                    stringBuilder.append(')');
                    if (85 != Decompiler.getNext(string, n4, n9)) break;
                    stringBuilder.append(' ');
                    break;
                }
                case 'S': {
                    stringBuilder.append('[');
                    break;
                }
                case 'T': {
                    stringBuilder.append(']');
                    break;
                }
                case '\u0001': {
                    int n10;
                    if (bl2) break;
                    n2 = 1;
                    if (!bl3) {
                        bl3 = true;
                        if (bl) {
                            stringBuilder.setLength(0);
                            n5 -= n6;
                            n2 = 0;
                        }
                    }
                    if (n2 != 0) {
                        stringBuilder.append('\n');
                    }
                    if (n9 + 1 >= n4) break;
                    int n11 = 0;
                    char c = string.charAt(n9 + 1);
                    if (c == 's' || c == 't') {
                        n11 = n6 - n7;
                    } else if (c == 'V') {
                        n11 = n6;
                    } else if (c == '\'' && string.charAt(n10 = Decompiler.getSourceStringEnd(string, n9 + 2)) == 'g') {
                        n11 = n6;
                    }
                    while (n11 < n5) {
                        stringBuilder.append(' ');
                        ++n11;
                    }
                    break;
                }
                case 'l': {
                    stringBuilder.append('.');
                    break;
                }
                case '\u001e': {
                    stringBuilder.append("new ");
                    break;
                }
                case '\u001f': {
                    stringBuilder.append("delete ");
                    break;
                }
                case 'p': {
                    stringBuilder.append("if ");
                    break;
                }
                case 'q': {
                    stringBuilder.append("else ");
                    break;
                }
                case 'w': {
                    stringBuilder.append("for ");
                    break;
                }
                case '4': {
                    stringBuilder.append(" in ");
                    break;
                }
                case '{': {
                    stringBuilder.append("with ");
                    break;
                }
                case 'u': {
                    stringBuilder.append("while ");
                    break;
                }
                case 'v': {
                    stringBuilder.append("do ");
                    break;
                }
                case 'Q': {
                    stringBuilder.append("try ");
                    break;
                }
                case '|': {
                    stringBuilder.append("catch ");
                    break;
                }
                case '}': {
                    stringBuilder.append("finally ");
                    break;
                }
                case '2': {
                    stringBuilder.append("throw ");
                    break;
                }
                case 'r': {
                    stringBuilder.append("switch ");
                    break;
                }
                case 'x': {
                    stringBuilder.append("break");
                    if (39 != Decompiler.getNext(string, n4, n9)) break;
                    stringBuilder.append(' ');
                    break;
                }
                case 'y': {
                    stringBuilder.append("continue");
                    if (39 != Decompiler.getNext(string, n4, n9)) break;
                    stringBuilder.append(' ');
                    break;
                }
                case 's': {
                    stringBuilder.append("case ");
                    break;
                }
                case 't': {
                    stringBuilder.append("default");
                    break;
                }
                case '\u0004': {
                    stringBuilder.append("return");
                    if (82 == Decompiler.getNext(string, n4, n9)) break;
                    stringBuilder.append(' ');
                    break;
                }
                case 'z': {
                    stringBuilder.append("var ");
                    break;
                }
                case '\u0099': {
                    stringBuilder.append("let ");
                    break;
                }
                case 'R': {
                    stringBuilder.append(';');
                    if (1 == Decompiler.getNext(string, n4, n9)) break;
                    stringBuilder.append(' ');
                    break;
                }
                case 'Z': {
                    stringBuilder.append(" = ");
                    break;
                }
                case 'a': {
                    stringBuilder.append(" += ");
                    break;
                }
                case 'b': {
                    stringBuilder.append(" -= ");
                    break;
                }
                case 'c': {
                    stringBuilder.append(" *= ");
                    break;
                }
                case 'd': {
                    stringBuilder.append(" /= ");
                    break;
                }
                case 'e': {
                    stringBuilder.append(" %= ");
                    break;
                }
                case '[': {
                    stringBuilder.append(" |= ");
                    break;
                }
                case '\\': {
                    stringBuilder.append(" ^= ");
                    break;
                }
                case ']': {
                    stringBuilder.append(" &= ");
                    break;
                }
                case '^': {
                    stringBuilder.append(" <<= ");
                    break;
                }
                case '_': {
                    stringBuilder.append(" >>= ");
                    break;
                }
                case '`': {
                    stringBuilder.append(" >>>= ");
                    break;
                }
                case 'f': {
                    stringBuilder.append(" ? ");
                    break;
                }
                case 'B': {
                    stringBuilder.append(": ");
                    break;
                }
                case 'g': {
                    if (1 == Decompiler.getNext(string, n4, n9)) {
                        stringBuilder.append(':');
                        break;
                    }
                    stringBuilder.append(" : ");
                    break;
                }
                case 'h': {
                    stringBuilder.append(" || ");
                    break;
                }
                case 'i': {
                    stringBuilder.append(" && ");
                    break;
                }
                case '\t': {
                    stringBuilder.append(" | ");
                    break;
                }
                case '\n': {
                    stringBuilder.append(" ^ ");
                    break;
                }
                case '\u000b': {
                    stringBuilder.append(" & ");
                    break;
                }
                case '.': {
                    stringBuilder.append(" === ");
                    break;
                }
                case '/': {
                    stringBuilder.append(" !== ");
                    break;
                }
                case '\f': {
                    stringBuilder.append(" == ");
                    break;
                }
                case '\r': {
                    stringBuilder.append(" != ");
                    break;
                }
                case '\u000f': {
                    stringBuilder.append(" <= ");
                    break;
                }
                case '\u000e': {
                    stringBuilder.append(" < ");
                    break;
                }
                case '\u0011': {
                    stringBuilder.append(" >= ");
                    break;
                }
                case '\u0010': {
                    stringBuilder.append(" > ");
                    break;
                }
                case '5': {
                    stringBuilder.append(" instanceof ");
                    break;
                }
                case '\u0012': {
                    stringBuilder.append(" << ");
                    break;
                }
                case '\u0013': {
                    stringBuilder.append(" >> ");
                    break;
                }
                case '\u0014': {
                    stringBuilder.append(" >>> ");
                    break;
                }
                case ' ': {
                    stringBuilder.append("typeof ");
                    break;
                }
                case '~': {
                    stringBuilder.append("void ");
                    break;
                }
                case '\u009a': {
                    stringBuilder.append("const ");
                    break;
                }
                case 'H': {
                    stringBuilder.append("yield ");
                    break;
                }
                case '\u001a': {
                    stringBuilder.append('!');
                    break;
                }
                case '\u001b': {
                    stringBuilder.append('~');
                    break;
                }
                case '\u001c': {
                    stringBuilder.append('+');
                    break;
                }
                case '\u001d': {
                    stringBuilder.append('-');
                    break;
                }
                case 'j': {
                    stringBuilder.append("++");
                    break;
                }
                case 'k': {
                    stringBuilder.append("--");
                    break;
                }
                case '\u0015': {
                    stringBuilder.append(" + ");
                    break;
                }
                case '\u0016': {
                    stringBuilder.append(" - ");
                    break;
                }
                case '\u0017': {
                    stringBuilder.append(" * ");
                    break;
                }
                case '\u0018': {
                    stringBuilder.append(" / ");
                    break;
                }
                case '\u0019': {
                    stringBuilder.append(" % ");
                    break;
                }
                case '\u0090': {
                    stringBuilder.append("::");
                    break;
                }
                case '\u008f': {
                    stringBuilder.append("..");
                    break;
                }
                case '\u0092': {
                    stringBuilder.append(".(");
                    break;
                }
                case '\u0093': {
                    stringBuilder.append('@');
                    break;
                }
                case '\u00a0': {
                    stringBuilder.append("debugger;\n");
                    break;
                }
                default: {
                    throw new RuntimeException("Token: " + Token.name(string.charAt(n9)));
                }
            }
            ++n9;
        }
        if (!bl2) {
            if (!bl) {
                stringBuilder.append('\n');
            }
        } else if (n3 == 2) {
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    private static int getNext(String string, int n, int n2) {
        return n2 + 1 < n ? (int)string.charAt(n2 + 1) : 0;
    }

    private static int getSourceStringEnd(String string, int n) {
        return Decompiler.printSourceString(string, n, false, null);
    }

    private static int printSourceString(String string, int n, boolean bl, StringBuilder stringBuilder) {
        int n2 = string.charAt(n);
        ++n;
        if ((0x8000 & n2) != 0) {
            n2 = (Short.MAX_VALUE & n2) << 16 | string.charAt(n);
            ++n;
        }
        if (stringBuilder != null) {
            String string2 = string.substring(n, n + n2);
            if (!bl) {
                stringBuilder.append(string2);
            } else {
                stringBuilder.append('\"');
                stringBuilder.append(ScriptRuntime.escapeString(string2));
                stringBuilder.append('\"');
            }
        }
        return n + n2;
    }

    private static int printSourceNumber(String string, int n, StringBuilder stringBuilder) {
        double d = 0.0;
        char c = string.charAt(n);
        ++n;
        if (c == 'S') {
            if (stringBuilder != null) {
                char c2 = string.charAt(n);
                d = c2;
            }
            ++n;
        } else if (c == 'J' || c == 'D') {
            if (stringBuilder != null) {
                long l = (long)string.charAt(n) << 48;
                l |= (long)string.charAt(n + 1) << 32;
                l |= (long)string.charAt(n + 2) << 16;
                d = c == 'J' ? (double)l : Double.longBitsToDouble(l |= (long)string.charAt(n + 3));
            }
            n += 4;
        } else {
            throw new RuntimeException();
        }
        if (stringBuilder != null) {
            stringBuilder.append(ScriptRuntime.numberToString(d, 10));
        }
        return n;
    }
}

