/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.Primitive;
import org.jruby.truffle.builtins.PrimitiveArrayArgumentsNode;
import org.jruby.truffle.language.objects.IsTaintedNode;
import org.jruby.truffle.language.objects.IsTaintedNodeGen;
import org.jruby.truffle.language.objects.ObjectIDOperations;
import org.jruby.truffle.language.objects.ObjectIVarGetNode;
import org.jruby.truffle.language.objects.ObjectIVarGetNodeGen;
import org.jruby.truffle.language.objects.ObjectIVarSetNode;
import org.jruby.truffle.language.objects.ObjectIVarSetNodeGen;
import org.jruby.truffle.language.objects.ReadObjectFieldNode;
import org.jruby.truffle.language.objects.ReadObjectFieldNodeGen;
import org.jruby.truffle.language.objects.TaintNode;
import org.jruby.truffle.language.objects.TaintNodeGen;
import org.jruby.truffle.language.objects.WriteObjectFieldNode;
import org.jruby.truffle.language.objects.WriteObjectFieldNodeGen;

public abstract class ObjectNodes {

    @Primitive(name="object_ivar_set")
    public static abstract class ObjectIVarSetPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public Object ivarSet(DynamicObject object, DynamicObject name, Object value, @Cached(value="createObjectIVarSetNode()") ObjectIVarSetNode iVarSetNode) {
            return iVarSetNode.executeIVarSet(object, Layouts.SYMBOL.getString(name), value);
        }

        protected ObjectIVarSetNode createObjectIVarSetNode() {
            return ObjectIVarSetNodeGen.create(false, null, null, null);
        }
    }

    @Primitive(name="object_ivar_get")
    public static abstract class ObjectIVarGetPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public Object ivarGet(DynamicObject object, DynamicObject name, @Cached(value="createObjectIVarGetNode()") ObjectIVarGetNode iVarGetNode) {
            return iVarGetNode.executeIVarGet(object, Layouts.SYMBOL.getString(name));
        }

        protected ObjectIVarGetNode createObjectIVarGetNode() {
            return ObjectIVarGetNodeGen.create(false, null, null);
        }
    }

    @Primitive(name="object_infect", needsSelf=false)
    public static abstract class ObjectInfectPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private IsTaintedNode isTaintedNode;
        @Node.Child
        private TaintNode taintNode;

        public ObjectInfectPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object objectInfect(Object host, Object source) {
            if (this.isTaintedNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isTaintedNode = this.insert(IsTaintedNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if (this.isTaintedNode.executeIsTainted(source)) {
                if (this.taintNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.taintNode = this.insert(TaintNodeGen.create(this.getContext(), this.getSourceSection(), null));
                }
                this.taintNode.executeTaint(host);
            }
            return host;
        }
    }

    @Primitive(name="object_id")
    public static abstract class ObjectIDPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        public abstract Object executeObjectID(VirtualFrame var1, Object var2);

        @Specialization(guards={"isNil(nil)"})
        public long objectID(Object nil) {
            return 4L;
        }

        @Specialization(guards={"value"})
        public long objectIDTrue(boolean value) {
            return 2L;
        }

        @Specialization(guards={"!value"})
        public long objectIDFalse(boolean value) {
            return 0L;
        }

        @Specialization
        public long objectID(int value) {
            return ObjectIDOperations.smallFixnumToID(value);
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public long objectIDSmallFixnumOverflow(long value) throws ArithmeticException {
            return ObjectIDOperations.smallFixnumToIDOverflow(value);
        }

        @Specialization
        public Object objectID(long value, @Cached(value="createCountingProfile()") ConditionProfile smallProfile) {
            if (smallProfile.profile(ObjectIDOperations.isSmallFixnum(value))) {
                return ObjectIDOperations.smallFixnumToID(value);
            }
            return ObjectIDOperations.largeFixnumToID(this.getContext(), value);
        }

        @Specialization
        public Object objectID(double value) {
            return ObjectIDOperations.floatToID(this.getContext(), value);
        }

        @Specialization(guards={"!isNil(object)"})
        public long objectID(DynamicObject object, @Cached(value="createReadObjectIDNode()") ReadObjectFieldNode readObjectIdNode, @Cached(value="createWriteObjectIDNode()") WriteObjectFieldNode writeObjectIdNode) {
            long id = (Long)readObjectIdNode.execute(object);
            if (id == 0L) {
                long newId = this.getContext().getObjectSpaceManager().getNextObjectID();
                writeObjectIdNode.execute(object, newId);
                return newId;
            }
            return id;
        }

        protected ReadObjectFieldNode createReadObjectIDNode() {
            return ReadObjectFieldNodeGen.create(Layouts.OBJECT_ID_IDENTIFIER, 0L);
        }

        protected WriteObjectFieldNode createWriteObjectIDNode() {
            return WriteObjectFieldNodeGen.create(Layouts.OBJECT_ID_IDENTIFIER);
        }
    }
}

