/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import java.util.Iterator;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.LexicalScope;
import org.jruby.truffle.language.RubyConstant;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.loader.RequireNode;

@NodeChildren(value={@NodeChild(value="name"), @NodeChild(value="lexicalParent")})
public abstract class LookupForExistingModuleNode
extends RubyNode {
    @Node.Child
    private RequireNode requireNode;

    public abstract RubyConstant executeLookupForExistingModule(VirtualFrame var1, String var2, DynamicObject var3);

    @Specialization(guards={"isRubyModule(lexicalParent)"})
    public RubyConstant lookupForExistingModule(VirtualFrame frame, String name, DynamicObject lexicalParent, @Cached(value="createBinaryProfile()") ConditionProfile autoloadProfile) {
        RubyConstant constant = this.deepConstantSearch(name, lexicalParent);
        if (autoloadProfile.profile(constant != null && constant.isAutoload())) {
            Layouts.MODULE.getFields(lexicalParent).removeConstant(this.getContext(), this, name);
            this.getRequireNode().executeRequire(frame, StringOperations.getString((DynamicObject)constant.getValue()));
            return this.deepConstantSearch(name, lexicalParent);
        }
        return constant;
    }

    @CompilerDirectives.TruffleBoundary
    private RubyConstant deepConstantSearch(String name, DynamicObject lexicalParent) {
        RubyConstant constant = Layouts.MODULE.getFields(lexicalParent).getConstant(name);
        DynamicObject objectClass = this.getContext().getCoreLibrary().getObjectClass();
        if (constant == null && lexicalParent == objectClass) {
            DynamicObject included;
            Iterator<DynamicObject> iterator = Layouts.MODULE.getFields(objectClass).prependedAndIncludedModules().iterator();
            while (iterator.hasNext() && (constant = Layouts.MODULE.getFields(included = iterator.next()).getConstant(name)) == null) {
            }
        }
        if (constant != null && !constant.isVisibleTo(this.getContext(), LexicalScope.NONE, lexicalParent)) {
            throw new RaiseException(this.getContext().getCoreExceptions().nameErrorPrivateConstant(lexicalParent, name, this));
        }
        return constant;
    }

    public RequireNode getRequireNode() {
        if (this.requireNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.requireNode = this.insert(RequireNode.create());
        }
        return this.requireNode;
    }
}

