/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swinghelper.debug;

import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public class CheckThreadViolationRepaintManager
extends RepaintManager {
    private boolean completeCheck = true;
    private WeakReference<JComponent> lastComponent;

    public CheckThreadViolationRepaintManager(boolean bl) {
        this.completeCheck = bl;
    }

    public CheckThreadViolationRepaintManager() {
        this(true);
    }

    @Override
    public synchronized void addInvalidComponent(JComponent jComponent) {
        this.checkThreadViolations(jComponent);
        super.addInvalidComponent(jComponent);
    }

    @Override
    public void addDirtyRegion(JComponent jComponent, int n, int n2, int n3, int n4) {
        this.checkThreadViolations(jComponent);
        super.addDirtyRegion(jComponent, n, n2, n3, n4);
    }

    private void checkThreadViolations(JComponent jComponent) {
        if (!SwingUtilities.isEventDispatchThread() && (this.completeCheck || jComponent.isShowing())) {
            StackTraceElement[] stackTraceElementArray;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            for (StackTraceElement stackTraceElement : stackTraceElementArray = Thread.currentThread().getStackTrace()) {
                if (bl && stackTraceElement.getClassName().startsWith("javax.swing.") && !stackTraceElement.getClassName().startsWith("javax.swing.SwingWorker")) {
                    bl2 = true;
                }
                if (bl && "imageUpdate".equals(stackTraceElement.getMethodName())) {
                    bl3 = true;
                }
                if ("repaint".equals(stackTraceElement.getMethodName())) {
                    bl = true;
                    bl2 = false;
                }
                if (!"read".equals(stackTraceElement.getMethodName()) || !"javax.swing.JEditorPane".equals(stackTraceElement.getClassName())) continue;
                return;
            }
            if (bl3) {
                return;
            }
            if (bl && !bl2) {
                return;
            }
            if (this.lastComponent != null && jComponent == this.lastComponent.get()) {
                return;
            }
            this.lastComponent = new WeakReference<JComponent>(jComponent);
            this.violationFound(jComponent, stackTraceElementArray);
        }
    }

    protected void violationFound(JComponent jComponent, StackTraceElement[] stackTraceElementArray) {
        System.out.println();
        System.out.println("EDT violation detected");
        System.out.println(jComponent);
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            System.out.println("\tat " + stackTraceElement);
        }
    }
}

