/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.mutex;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.builtins.UnaryCoreMethodNode;
import org.jruby.truffle.core.cast.DurationToMillisecondsNodeGen;
import org.jruby.truffle.core.mutex.MutexOperations;
import org.jruby.truffle.core.thread.ThreadManager;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.objects.AllocateObjectNode;

@CoreClass(value="ConditionVariable")
public abstract class ConditionVariableNodes {
    private static Object getCondition(DynamicObject conditionVariable) {
        return Layouts.CONDITION_VARIABLE.getCondition(conditionVariable);
    }

    @CoreMethod(names={"marshal_dump"})
    public static abstract class MarshalDumpNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public Object marshal_dump(DynamicObject self) {
            throw new RaiseException(this.coreExceptions().typeErrorCantDump(self, this));
        }
    }

    @CoreMethod(names={"broadcast"})
    public static abstract class BroadcastNode
    extends UnaryCoreMethodNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject doBroadcast(DynamicObject conditionVariable) {
            Object condition;
            Object object = condition = ConditionVariableNodes.getCondition(conditionVariable);
            synchronized (object) {
                condition.notifyAll();
            }
            return conditionVariable;
        }
    }

    @CoreMethod(names={"signal"})
    public static abstract class SignalNode
    extends UnaryCoreMethodNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject doSignal(DynamicObject conditionVariable) {
            Object condition;
            Object object = condition = ConditionVariableNodes.getCondition(conditionVariable);
            synchronized (object) {
                condition.notify();
            }
            return conditionVariable;
        }
    }

    @CoreMethod(names={"wait"}, required=1, optional=1)
    @NodeChildren(value={@NodeChild(value="conditionVariable", type=RubyNode.class), @NodeChild(value="mutex", type=RubyNode.class), @NodeChild(value="duration", type=RubyNode.class)})
    public static abstract class WaitNode
    extends CoreMethodNode {
        @CreateCast(value={"duration"})
        public RubyNode coerceDuration(RubyNode duration) {
            return DurationToMillisecondsNodeGen.create(true, duration);
        }

        @Specialization(guards={"isRubyMutex(mutex)"})
        public DynamicObject wait(DynamicObject conditionVariable, DynamicObject mutex, long timeoutInMillis) {
            ReentrantLock lock = Layouts.MUTEX.getLock(mutex);
            DynamicObject thread = this.getContext().getThreadManager().getCurrentThread();
            Object condition = ConditionVariableNodes.getCondition(conditionVariable);
            this.doWait(timeoutInMillis, lock, thread, condition);
            return conditionVariable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private void doWait(final long durationInMillis, ReentrantLock lock, DynamicObject thread, final Object condition) {
            final long start = System.currentTimeMillis();
            boolean doLock = false;
            try {
                Object object = condition;
                synchronized (object) {
                    MutexOperations.unlock(lock, thread, this);
                    doLock = true;
                    this.getContext().getThreadManager().runUntilResult(this, new ThreadManager.BlockingAction<Boolean>(){

                        @Override
                        public Boolean block() throws InterruptedException {
                            long now = System.currentTimeMillis();
                            long slept = now - start;
                            if (slept >= durationInMillis) {
                                return true;
                            }
                            condition.wait(durationInMillis - slept);
                            return true;
                        }
                    });
                }
            }
            finally {
                if (doLock) {
                    MutexOperations.lock(lock, thread, this);
                }
            }
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateNode = AllocateObjectNode.create();

        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return this.allocateNode.allocate(rubyClass, new Object());
        }
    }
}

