/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.objectspace;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.YieldingCoreMethodNode;
import org.jruby.truffle.core.module.ModuleOperations;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.DoesRespondDispatchHeadNode;
import org.jruby.truffle.language.objects.ObjectGraph;
import org.jruby.truffle.language.objects.ObjectIDOperations;
import org.jruby.truffle.language.objects.ReadObjectFieldNode;
import org.jruby.truffle.language.objects.ReadObjectFieldNodeGen;
import org.jruby.truffle.util.StringUtils;

@CoreClass(value="ObjectSpace")
public abstract class ObjectSpaceNodes {

    @CoreMethod(names={"undefine_finalizer"}, isModuleFunction=true, required=1)
    public static abstract class UndefineFinalizerNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object undefineFinalizer(Object object) {
            this.getContext().getObjectSpaceManager().undefineFinalizer((DynamicObject)object);
            return object;
        }
    }

    @CoreMethod(names={"define_finalizer"}, isModuleFunction=true, required=2)
    public static abstract class DefineFinalizerNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private DoesRespondDispatchHeadNode respondToCallNode = new DoesRespondDispatchHeadNode(this.getContext(), true);

        public DefineFinalizerNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject defineFinalizer(VirtualFrame frame, DynamicObject object, Object finalizer, @Cached(value="create()") BranchProfile errorProfile) {
            if (this.respondToCallNode.doesRespondTo(frame, "call", finalizer)) {
                this.getContext().getObjectSpaceManager().defineFinalizer(object, finalizer);
                Object[] objects = new Object[]{0, finalizer};
                return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), objects, objects.length);
            }
            errorProfile.enter();
            throw new RaiseException(this.coreExceptions().argumentErrorWrongArgumentType(finalizer, "callable", this));
        }
    }

    @CoreMethod(names={"each_object"}, isModuleFunction=true, needsBlock=true, optional=1, returnsEnumeratorIfNoBlock=true)
    public static abstract class EachObjectNode
    extends YieldingCoreMethodNode {
        @Specialization
        public int eachObject(VirtualFrame frame, NotProvided ofClass, DynamicObject block) {
            int count = 0;
            for (DynamicObject object : ObjectGraph.stopAndGetAllObjects(this, this.getContext())) {
                if (this.isHidden(object)) continue;
                this.yield(frame, block, object);
                ++count;
            }
            return count;
        }

        @Specialization(guards={"isRubyModule(ofClass)"})
        public int eachObject(VirtualFrame frame, DynamicObject ofClass, DynamicObject block) {
            int count = 0;
            for (DynamicObject object : ObjectGraph.stopAndGetAllObjects(this, this.getContext())) {
                DynamicObject metaClass = Layouts.BASIC_OBJECT.getMetaClass(object);
                if (this.isHidden(object) || !ModuleOperations.assignableTo(metaClass, ofClass)) continue;
                this.yield(frame, block, object);
                ++count;
            }
            return count;
        }

        private boolean isHidden(DynamicObject object) {
            return RubyGuards.isRubyClass(object) && Layouts.CLASS.getIsSingleton(object);
        }
    }

    @CoreMethod(names={"_id2ref"}, isModuleFunction=true, required=1)
    @ImportStatic(value={ObjectIDOperations.class})
    public static abstract class ID2RefNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"id == NIL"})
        public Object id2RefNil(long id) {
            return this.nil();
        }

        @Specialization(guards={"id == TRUE"})
        public boolean id2RefTrue(long id) {
            return true;
        }

        @Specialization(guards={"id == FALSE"})
        public boolean id2RefFalse(long id) {
            return false;
        }

        @Specialization(guards={"isSmallFixnumID(id)"})
        public long id2RefSmallInt(long id) {
            return ObjectIDOperations.toFixnum(id);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isBasicObjectID(id)"})
        public DynamicObject id2Ref(long id, @Cached(value="createReadObjectIDNode()") ReadObjectFieldNode readObjectIdNode) {
            for (DynamicObject object : ObjectGraph.stopAndGetAllObjects(this, this.getContext())) {
                long objectID = (Long)readObjectIdNode.execute(object);
                if (objectID != id) continue;
                return object;
            }
            throw new RaiseException(this.coreExceptions().rangeError(StringUtils.format("0x%016x is not id value", id), (Node)this));
        }

        @Specialization(guards={"isRubyBignum(id)", "isLargeFixnumID(id)"})
        public Object id2RefLargeFixnum(DynamicObject id) {
            return Layouts.BIGNUM.getValue(id).longValue();
        }

        @Specialization(guards={"isRubyBignum(id)", "isFloatID(id)"})
        public double id2RefFloat(DynamicObject id) {
            return Double.longBitsToDouble(Layouts.BIGNUM.getValue(id).longValue());
        }

        protected ReadObjectFieldNode createReadObjectIDNode() {
            return ReadObjectFieldNodeGen.create(Layouts.OBJECT_ID_IDENTIFIER, 0L);
        }

        protected boolean isLargeFixnumID(DynamicObject id) {
            return ObjectIDOperations.isLargeFixnumID(Layouts.BIGNUM.getValue(id));
        }

        protected boolean isFloatID(DynamicObject id) {
            return ObjectIDOperations.isFloatID(Layouts.BIGNUM.getValue(id));
        }
    }
}

