/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.uid;

import java.io.IOException;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.lucene.uid.Versions;

final class PerThreadIDAndVersionLookup {
    private final TermsEnum termsEnum;
    private final NumericDocValues versions;
    private final boolean hasPayloads;
    private PostingsEnum docsEnum;
    private PostingsEnum posEnum;

    public PerThreadIDAndVersionLookup(LeafReader reader) throws IOException {
        Terms terms;
        TermsEnum termsEnum = null;
        NumericDocValues versions = null;
        boolean hasPayloads = false;
        Fields fields = reader.fields();
        if (fields != null && (terms = fields.terms("_uid")) != null) {
            hasPayloads = terms.hasPayloads();
            termsEnum = terms.iterator();
            assert (termsEnum != null);
            versions = reader.getNumericDocValues("_version");
        }
        this.versions = versions;
        this.termsEnum = termsEnum;
        this.hasPayloads = hasPayloads;
    }

    public Versions.DocIdAndVersion lookup(BytesRef id, Bits liveDocs, LeafReaderContext context) throws IOException {
        if (this.termsEnum.seekExact(id)) {
            if (this.versions != null || !this.hasPayloads) {
                this.docsEnum = this.termsEnum.postings(this.docsEnum, 0);
                int docID = Integer.MAX_VALUE;
                int d = this.docsEnum.nextDoc();
                while (d != Integer.MAX_VALUE) {
                    if (liveDocs == null || liveDocs.get(d)) {
                        docID = d;
                    }
                    d = this.docsEnum.nextDoc();
                }
                if (docID != Integer.MAX_VALUE) {
                    if (this.versions != null) {
                        return new Versions.DocIdAndVersion(docID, this.versions.get(docID), context);
                    }
                    return new Versions.DocIdAndVersion(docID, -2L, context);
                }
            }
            this.posEnum = this.termsEnum.postings(this.posEnum, 88);
            assert (this.posEnum != null);
            int d = this.posEnum.nextDoc();
            while (d != Integer.MAX_VALUE) {
                if (liveDocs == null || liveDocs.get(d)) {
                    this.posEnum.nextPosition();
                    BytesRef payload = this.posEnum.getPayload();
                    if (payload != null && payload.length == 8) {
                        return new Versions.DocIdAndVersion(d, Numbers.bytesToLong(payload), context);
                    }
                }
                d = this.posEnum.nextDoc();
            }
        }
        return null;
    }
}

