/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.file.FileCollection;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.NativeDependencySet;
import org.gradle.nativeplatform.NativeExecutableFileSpec;
import org.gradle.nativeplatform.NativeInstallationSpec;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.tasks.LinkExecutable;
import org.gradle.platform.base.internal.BinaryNamingScheme;

public class NativeComponents {
    public static void createExecutableTask(final NativeBinarySpecInternal binary, final File executableFile) {
        String taskName = binary.getNamingScheme().getTaskName("link");
        binary.getTasks().create(taskName, LinkExecutable.class, (Action)new Action<LinkExecutable>(){

            public void execute(LinkExecutable linkTask) {
                linkTask.setDescription("Links " + binary.getDisplayName());
                linkTask.setToolChain(binary.getToolChain());
                linkTask.setTargetPlatform(binary.getTargetPlatform());
                linkTask.setOutputFile(executableFile);
                linkTask.setLinkerArgs(binary.getLinker().getArgs());
                linkTask.lib(new BinaryLibs(binary){

                    @Override
                    protected FileCollection getFiles(NativeDependencySet nativeDependencySet) {
                        return nativeDependencySet.getLinkFiles();
                    }
                });
                binary.builtBy(new Object[]{linkTask});
            }
        });
    }

    public static void createInstallTask(final NativeBinarySpecInternal binary, final NativeInstallationSpec installation, final NativeExecutableFileSpec executable, BinaryNamingScheme namingScheme) {
        binary.getTasks().create(namingScheme.getTaskName("install"), InstallExecutable.class, (Action)new Action<InstallExecutable>(){

            public void execute(InstallExecutable installTask) {
                installTask.setDescription("Installs a development image of " + binary.getDisplayName());
                installTask.setGroup("build");
                installTask.setToolChain(executable.getToolChain());
                installTask.setPlatform(binary.getTargetPlatform());
                installTask.setExecutable(executable.getFile());
                installTask.setDestinationDir(installation.getDirectory());
                installTask.lib(new BinaryLibs(binary){

                    @Override
                    protected FileCollection getFiles(NativeDependencySet nativeDependencySet) {
                        return nativeDependencySet.getRuntimeFiles();
                    }
                });
                installTask.dependsOn(new Object[]{binary});
            }
        });
    }

    public static abstract class BinaryLibs
    implements Callable<List<FileCollection>> {
        private final NativeBinarySpec binary;

        public BinaryLibs(NativeBinarySpec binary) {
            this.binary = binary;
        }

        @Override
        public List<FileCollection> call() throws Exception {
            ArrayList runtimeFiles = Lists.newArrayList();
            for (NativeDependencySet nativeDependencySet : this.binary.getLibs()) {
                runtimeFiles.add(this.getFiles(nativeDependencySet));
            }
            return runtimeFiles;
        }

        protected abstract FileCollection getFiles(NativeDependencySet var1);
    }
}

