/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassGenerationSupport;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade;
import org.jetbrains.kotlin.asJava.finder.JavaElementFinder;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CliModuleVisibilityManagerImpl;
import org.jetbrains.kotlin.cli.common.PropertiesKt;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.CliLightClassGenerationSupport;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.kotlin.cli.jvm.compiler.CompilerJarLocator;
import org.jetbrains.kotlin.cli.jvm.compiler.JavaRoot;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmCliVirtualFileFinderFactory;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmDependenciesDynamicCompoundIndex;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmDependenciesIndex;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmDependenciesIndexFactory;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmStaticDependenciesIndexFactory;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmUpdatableDependenciesIndexFactory;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCliJavaFileManagerImpl;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreProjectEnvironment;
import org.jetbrains.kotlin.cli.jvm.config.JavaSourceRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmClasspathRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.codegen.extensions.ClassBuilderInterceptorExtension;
import org.jetbrains.kotlin.codegen.extensions.ExpressionCodegenExtension;
import org.jetbrains.kotlin.com.google.common.collect.Sets;
import org.jetbrains.kotlin.com.intellij.codeInsight.ContainerProvider;
import org.jetbrains.kotlin.com.intellij.codeInsight.runner.JavaMainMethodProvider;
import org.jetbrains.kotlin.com.intellij.core.CoreApplicationEnvironment;
import org.jetbrains.kotlin.com.intellij.core.CoreJavaFileManager;
import org.jetbrains.kotlin.com.intellij.core.JavaCoreApplicationEnvironment;
import org.jetbrains.kotlin.com.intellij.core.JavaCoreProjectEnvironment;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaParserDefinition;
import org.jetbrains.kotlin.com.intellij.mock.MockApplication;
import org.jetbrains.kotlin.com.intellij.mock.MockProject;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.application.Application;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionsArea;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileTypeExtensionPoint;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.PlainTextFileType;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtilRt;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.PersistentFSConstants;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.ZipHandler;
import org.jetbrains.kotlin.com.intellij.psi.FileContextProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFinder;
import org.jetbrains.kotlin.com.intellij.psi.augment.PsiAugmentProvider;
import org.jetbrains.kotlin.com.intellij.psi.compiled.ClassFileDecompilers;
import org.jetbrains.kotlin.com.intellij.psi.impl.JavaClassSupersImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiElementFinderImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiTreeChangePreprocessor;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.impl.JavaFileManager;
import org.jetbrains.kotlin.com.intellij.psi.meta.MetaDataContributor;
import org.jetbrains.kotlin.com.intellij.psi.util.JavaClassSupers;
import org.jetbrains.kotlin.compiler.plugin.ComponentRegistrar;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.ContentRoot;
import org.jetbrains.kotlin.config.ContentRootsKt;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.extensions.ExternalDeclarationsProvider;
import org.jetbrains.kotlin.extensions.StorageComponentContainerContributor;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.load.kotlin.JvmVirtualFileFinderFactory;
import org.jetbrains.kotlin.load.kotlin.KotlinBinaryClassCache;
import org.jetbrains.kotlin.load.kotlin.ModuleVisibilityManager;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.CodeAnalyzerInitializer;
import org.jetbrains.kotlin.resolve.jvm.KotlinJavaPsiFacade;
import org.jetbrains.kotlin.resolve.jvm.extensions.AnalysisCompletedHandlerExtension;
import org.jetbrains.kotlin.resolve.jvm.extensions.PackageFragmentProviderExtension;
import org.jetbrains.kotlin.resolve.lazy.declarations.CliDeclarationProviderFactoryService;
import org.jetbrains.kotlin.resolve.lazy.declarations.DeclarationProviderFactoryService;
import org.jetbrains.kotlin.script.KotlinConfigurableScriptDefinition;
import org.jetbrains.kotlin.script.KotlinConfigurableScriptDefinitionKt;
import org.jetbrains.kotlin.script.KotlinScriptConfig;
import org.jetbrains.kotlin.script.KotlinScriptDefinitionProvider;
import org.jetbrains.kotlin.script.KotlinScriptExternalImportsProvider;
import org.jetbrains.kotlin.script.ScriptConfigKt;
import org.jetbrains.kotlin.utils.PathUtil;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 >2\u00020\u0001:\u0001>B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&J\u0014\u0010'\u001a\u00020\u001e2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0(J\u0012\u0010)\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020*H\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&H\u0002J\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001c0(J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.H\u0002J\u0018\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020/H\u0002J\u001e\u00105\u001a\n\u0012\u0004\u0012\u000206\u0018\u00010(2\f\u00107\u001a\b\u0012\u0004\u0012\u00020608H\u0007J\u0010\u00109\u001a\u0002012\u0006\u0010:\u001a\u00020\u0019H\u0002J\u0018\u0010;\u001a\b\u0012\u0004\u0012\u00020<0(*\b\u0012\u0004\u0012\u00020=08H\u0002R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b\u001f\u0010 \u00a8\u0006?"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "", "parentDisposable", "Lorg/jetbrains/kotlin/com/intellij/openapi/Disposable;", "applicationEnvironment", "Lorg/jetbrains/kotlin/com/intellij/core/JavaCoreApplicationEnvironment;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/core/JavaCoreApplicationEnvironment;Lorg/jetbrains/kotlin/config/CompilerConfiguration;)V", "application", "Lorg/jetbrains/kotlin/com/intellij/mock/MockApplication;", "getApplication", "()Lcom/intellij/mock/MockApplication;", "Lorg/jetbrains/kotlin/com/intellij/core/CoreApplicationEnvironment;", "getApplicationEnvironment", "()Lcom/intellij/core/CoreApplicationEnvironment;", "getConfiguration", "()Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "projectEnvironment", "Lorg/jetbrains/kotlin/com/intellij/core/JavaCoreProjectEnvironment;", "rootsIndex", "Lorg/jetbrains/kotlin/cli/jvm/compiler/JvmDependenciesIndex;", "sourceFiles", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/psi/KtFile;", "sourceLinesOfCode", "", "getSourceLinesOfCode", "()I", "sourceLinesOfCode$delegate", "Lkotlin/Lazy;", "contentRootToVirtualFile", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "root", "Lorg/jetbrains/kotlin/cli/jvm/config/JvmContentRoot;", "countLinesOfCode", "", "findJarRoot", "Lorg/jetbrains/kotlin/cli/jvm/config/JvmClasspathRoot;", "findLocalDirectory", "getSourceFiles", "getSourceRootsCheckingForDuplicates", "", "", "report", "", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "message", "tryUpdateClasspath", "Ljava/io/File;", "files", "", "updateClasspathFromRootsIndex", "index", "classpathRoots", "Lorg/jetbrains/kotlin/cli/jvm/compiler/JavaRoot;", "Lorg/jetbrains/kotlin/config/ContentRoot;", "Companion", "kotlin-compiler"})
public final class KotlinCoreEnvironment {
    private final JavaCoreProjectEnvironment projectEnvironment;
    private final ArrayList<KtFile> sourceFiles;
    private final JvmDependenciesIndex rootsIndex;
    @NotNull
    private final CompilerConfiguration configuration;
    @NotNull
    private final Lazy sourceLinesOfCode$delegate;
    private static final Object APPLICATION_LOCK;
    private static JavaCoreApplicationEnvironment ourApplicationEnvironment;
    private static int ourProjectCount;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;
    public static final Companion Companion;

    @NotNull
    public final CompilerConfiguration getConfiguration() {
        return this.configuration;
    }

    private final CoreApplicationEnvironment getApplicationEnvironment() {
        CoreApplicationEnvironment coreApplicationEnvironment = this.projectEnvironment.getEnvironment();
        Intrinsics.checkExpressionValueIsNotNull(coreApplicationEnvironment, "projectEnvironment.environment");
        return coreApplicationEnvironment;
    }

    @NotNull
    public final MockApplication getApplication() {
        MockApplication mockApplication = this.getApplicationEnvironment().getApplication();
        Intrinsics.checkExpressionValueIsNotNull(mockApplication, "applicationEnvironment.application");
        return mockApplication;
    }

    @NotNull
    public final Project getProject() {
        Project project = this.projectEnvironment.getProject();
        Intrinsics.checkExpressionValueIsNotNull(project, "projectEnvironment.project");
        return project;
    }

    public final int getSourceLinesOfCode() {
        Lazy lazy = this.sourceLinesOfCode$delegate;
        KotlinCoreEnvironment kotlinCoreEnvironment = this;
        KProperty kProperty = $$delegatedProperties[0];
        return ((Number)lazy.getValue()).intValue();
    }

    /*
     * WARNING - void declaration
     */
    public final int countLinesOfCode(@NotNull List<? extends KtFile> sourceFiles) {
        void var3_3;
        Intrinsics.checkParameterIsNotNull(sourceFiles, "sourceFiles");
        Iterable $receiver$iv = sourceFiles;
        int sum$iv = 0;
        for (Object element$iv : $receiver$iv) {
            void it;
            KtFile ktFile = (KtFile)element$iv;
            int n = sum$iv;
            String text2 = it.getText();
            int n2 = StringUtil.getLineBreakCount(it.getText()) + (StringUtil.endsWithLineBreak(text2) ? 0 : 1);
            sum$iv = n + n2;
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private final List<JavaRoot> classpathRoots(@NotNull Iterable<? extends ContentRoot> $receiver) {
        void destination$iv$iv;
        void $receiver$iv$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv = CollectionsKt.filterIsInstance($receiver, JvmContentRoot.class);
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList();
        void var5_5 = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            JavaRoot javaRoot;
            Object element$iv$iv = element$iv$iv$iv;
            JvmContentRoot javaRoot2 = (JvmContentRoot)element$iv$iv;
            if (this.contentRootToVirtualFile(javaRoot2) != null) {
                JavaRoot.RootType rootType;
                FqName fqName2;
                Object object;
                VirtualFile virtualFile;
                VirtualFile virtualFile2 = virtualFile;
                JvmContentRoot jvmContentRoot = javaRoot2;
                if (!(jvmContentRoot instanceof JavaSourceRoot)) {
                    jvmContentRoot = null;
                }
                if ((object = (JavaSourceRoot)jvmContentRoot) != null && (object = ((JavaSourceRoot)object).getPackagePrefix()) != null) {
                    FqName fqName3;
                    Object object2 = object;
                    String it = (String)object2;
                    if (FqNamesUtilKt.isValidJavaFqName(it)) {
                        fqName3 = new FqName(it);
                    } else {
                        this.report(CompilerMessageSeverity.WARNING, "Invalid package prefix name is ignored: " + it);
                        fqName3 = null;
                    }
                    fqName2 = fqName3;
                } else {
                    fqName2 = null;
                }
                FqName prefixPackageFqName = fqName2;
                JvmContentRoot jvmContentRoot2 = javaRoot2;
                if (jvmContentRoot2 instanceof JavaSourceRoot) {
                    rootType = JavaRoot.RootType.SOURCE;
                } else if (jvmContentRoot2 instanceof JvmClasspathRoot) {
                    rootType = JavaRoot.RootType.BINARY;
                } else {
                    throw (Throwable)new IllegalStateException();
                }
                JavaRoot.RootType rootType2 = rootType;
                javaRoot = new JavaRoot(virtualFile2, rootType2, prefixPackageFqName);
            } else {
                javaRoot = null;
            }
            if (javaRoot == null) continue;
            JavaRoot javaRoot3 = javaRoot;
            JavaRoot it$iv$iv = javaRoot3;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final void updateClasspathFromRootsIndex(JvmDependenciesIndex index2) {
        Sequence<JavaRoot> $receiver$iv = index2.getIndexedRoots();
        Iterator<JavaRoot> iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            JavaRoot element$iv;
            JavaRoot it = element$iv = iterator2.next();
            this.projectEnvironment.addSourcesToClasspath(it.getFile());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<File> tryUpdateClasspath(@NotNull Iterable<? extends File> files) {
        List list2;
        block4: {
            block5: {
                List list3;
                void destination$iv$iv;
                void $receiver$iv$iv;
                void $receiver$iv;
                block3: {
                    Intrinsics.checkParameterIsNotNull(files, "files");
                    if (this.rootsIndex instanceof JvmDependenciesDynamicCompoundIndex) break block3;
                    this.report(CompilerMessageSeverity.WARNING, "Unable to update classpath after initialization, it is only allowed in REPL");
                    list2 = null;
                    break block4;
                }
                Object object = files;
                KotlinCoreEnvironment kotlinCoreEnvironment = this;
                JvmDependenciesDynamicCompoundIndex jvmDependenciesDynamicCompoundIndex = (JvmDependenciesDynamicCompoundIndex)this.rootsIndex;
                void var5_5 = $receiver$iv;
                Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    File file2 = (File)item$iv$iv;
                    list3 = destination$iv$iv;
                    JvmClasspathRoot jvmClasspathRoot = new JvmClasspathRoot((File)it);
                    list3.add(jvmClasspathRoot);
                }
                list3 = (List)destination$iv$iv;
                list2 = jvmDependenciesDynamicCompoundIndex.addNewIndexForRoots((Iterable<JavaRoot>)kotlinCoreEnvironment.classpathRoots(list3));
                if (list2 == null) break block5;
                object = list2;
                JvmDependenciesIndex it = (JvmDependenciesIndex)object;
                this.updateClasspathFromRootsIndex(it);
                list2 = SequencesKt.toList(SequencesKt.mapNotNull(it.getIndexedRoots(), tryUpdateClasspath.2.1.INSTANCE));
                if (list2 != null) break block4;
            }
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @Nullable
    public final VirtualFile contentRootToVirtualFile(@NotNull JvmContentRoot root) {
        Intrinsics.checkParameterIsNotNull(root, "root");
        JvmContentRoot jvmContentRoot = root;
        if (jvmContentRoot instanceof JvmClasspathRoot) {
            return root.getFile().isFile() ? this.findJarRoot((JvmClasspathRoot)root) : this.findLocalDirectory(root);
        }
        if (jvmContentRoot instanceof JavaSourceRoot) {
            return root.getFile().isDirectory() ? this.findLocalDirectory(root) : (VirtualFile)null;
        }
        throw (Throwable)new IllegalStateException("Unexpected root: " + root);
    }

    private final VirtualFile findLocalDirectory(JvmContentRoot root) {
        File path = root.getFile();
        VirtualFile localFile = this.getApplicationEnvironment().getLocalFileSystem().findFileByPath(path.getAbsolutePath());
        if (localFile == null) {
            this.report(CompilerMessageSeverity.WARNING, "Classpath entry points to a non-existent location: " + path);
            return null;
        }
        return localFile;
    }

    private final VirtualFile findJarRoot(JvmClasspathRoot root) {
        File path = root.getFile();
        VirtualFile jarFile = this.getApplicationEnvironment().getJarFileSystem().findFileByPath(path + "!/");
        if (jarFile == null) {
            this.report(CompilerMessageSeverity.WARNING, "Classpath entry points to a file that is not a JAR archive: " + path);
            return null;
        }
        return jarFile;
    }

    private final Collection<String> getSourceRootsCheckingForDuplicates() {
        LinkedHashSet<String> uniqueSourceRoots = Sets.newLinkedHashSet();
        Iterable $receiver$iv = ContentRootsKt.getKotlinSourceRoots(this.configuration);
        for (Object element$iv : $receiver$iv) {
            String path = (String)element$iv;
            if (uniqueSourceRoots.add(path)) continue;
            this.report(CompilerMessageSeverity.WARNING, "Duplicate source root: " + path);
        }
        Collection collection = uniqueSourceRoots;
        Intrinsics.checkExpressionValueIsNotNull(collection, "uniqueSourceRoots");
        return collection;
    }

    @NotNull
    public final List<KtFile> getSourceFiles() {
        return this.sourceFiles;
    }

    private final void report(CompilerMessageSeverity severity, String message) {
        MessageCollector messageCollector = this.configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        messageCollector.report(severity, message, CompilerMessageLocation.NO_LOCATION);
    }

    /*
     * WARNING - void declaration
     */
    private KotlinCoreEnvironment(Disposable parentDisposable, JavaCoreApplicationEnvironment applicationEnvironment, CompilerConfiguration configuration) {
        Collection collection;
        Object object;
        Iterable<KotlinScriptConfig> configs;
        KotlinScriptExternalImportsProvider $receiver$iv;
        CompilerConfiguration compilerConfiguration;
        this.projectEnvironment = new KotlinCoreProjectEnvironment(parentDisposable, applicationEnvironment, parentDisposable, applicationEnvironment){
            final /* synthetic */ Disposable $parentDisposable;
            final /* synthetic */ JavaCoreApplicationEnvironment $applicationEnvironment;

            protected void preregisterServices() {
                ExtensionsArea extensionsArea = Extensions.getArea(this.getProject());
                Intrinsics.checkExpressionValueIsNotNull(extensionsArea, "Extensions.getArea(getProject())");
                org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment$Companion.access$registerProjectExtensionPoints(KotlinCoreEnvironment.Companion, extensionsArea);
            }
            {
                this.$parentDisposable = $captured_local_variable$0;
                this.$applicationEnvironment = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3);
            }
        };
        this.sourceFiles = new ArrayList();
        CompilerConfiguration compilerConfiguration2 = configuration.copy();
        KotlinCoreEnvironment kotlinCoreEnvironment = this;
        Object $receiver = compilerConfiguration2;
        ((CompilerConfiguration)$receiver).setReadOnly(true);
        CompilerConfiguration compilerConfiguration3 = compilerConfiguration = compilerConfiguration2;
        Intrinsics.checkExpressionValueIsNotNull(compilerConfiguration3, "configuration.copy().apply { setReadOnly(true) }");
        kotlinCoreEnvironment.configuration = compilerConfiguration3;
        PersistentFSConstants.setMaxIntellisenseFileSize(FileUtilRt.LARGE_FOR_CONTENT_LOADING);
        MockProject project = this.projectEnvironment.getProject();
        project.registerService(DeclarationProviderFactoryService.class, new CliDeclarationProviderFactoryService((Collection<? extends KtFile>)this.sourceFiles));
        project.registerService(ModuleVisibilityManager.class, new CliModuleVisibilityManagerImpl());
        KotlinCoreEnvironment.Companion.registerProjectServicesForCLI(this.projectEnvironment);
        Companion.registerProjectServices(this.projectEnvironment);
        this.sourceFiles.addAll((Collection<KtFile>)CompileEnvironmentUtil.getKtFiles(project, this.getSourceRootsCheckingForDuplicates(), this.configuration, new Function1<String, Unit>(){

            @Override
            public final void invoke(String message) {
                String string = message;
                Intrinsics.checkExpressionValueIsNotNull(string, "message");
                this.report(CompilerMessageSeverity.ERROR, string);
            }
        }));
        CollectionsKt.sortedWith((Iterable)this.sourceFiles, (Comparator)new Comparator<KtFile>(){

            @Override
            public int compare(@NotNull KtFile o1, @NotNull KtFile o2) {
                Intrinsics.checkParameterIsNotNull(o1, "o1");
                Intrinsics.checkParameterIsNotNull(o2, "o2");
                String string = o1.getVirtualFile().getPath();
                String string2 = o2.getVirtualFile().getPath();
                Intrinsics.checkExpressionValueIsNotNull(string2, "o2.virtualFile.path");
                return StringsKt.compareTo(string, string2, true);
            }
        });
        Project project2 = project;
        Intrinsics.checkExpressionValueIsNotNull(project2, "project");
        $receiver = KotlinScriptDefinitionProvider.Companion.getInstance(project2);
        KotlinScriptDefinitionProvider scriptDefinitionProvider = (KotlinScriptDefinitionProvider)$receiver;
        Collection collection2 = configuration.getList(JVMConfigurationKeys.SCRIPT_DEFINITIONS);
        KotlinScriptDefinitionProvider kotlinScriptDefinitionProvider = scriptDefinitionProvider;
        if ($receiver$iv.isEmpty()) {
            List list2;
            Boolean bl = configuration.get(JVMConfigurationKeys.LOAD_SCRIPT_CONFIGS);
            if (bl != null ? bl : false) {
                void destination$iv$iv;
                void $receiver$iv$iv;
                void $receiver$iv2;
                String string = project.getBasePath();
                if (string == null) {
                    string = ".";
                }
                List<KotlinScriptConfig> list3 = ScriptConfigKt.loadScriptConfigsFromProjectRoot(new File(string));
                configs = list3;
                Project project3 = project;
                Intrinsics.checkExpressionValueIsNotNull(project3, "project");
                Map kotlinEnvVars = KotlinConfigurableScriptDefinitionKt.generateKotlinScriptClasspathEnvVars$default(project3, null, 2, null);
                Iterable iterable = configs;
                void var15_15 = $receiver$iv2;
                Collection collection3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    object = (KotlinScriptConfig)item$iv$iv;
                    void var20_20 = destination$iv$iv;
                    KotlinConfigurableScriptDefinition kotlinConfigurableScriptDefinition = new KotlinConfigurableScriptDefinition((KotlinScriptConfig)it, kotlinEnvVars);
                    var20_20.add(kotlinConfigurableScriptDefinition);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = null != null ? (List)null : CollectionsKt.emptyList();
            }
            collection = list2;
        } else {
            collection = $receiver$iv;
        }
        void var22_22 = collection;
        List list4 = (List)var22_22;
        Intrinsics.checkExpressionValueIsNotNull(list4, "configuration.getList(JV\u2026                        }");
        kotlinScriptDefinitionProvider.setScriptDefinitions(list4);
        Project project4 = project;
        Intrinsics.checkExpressionValueIsNotNull(project4, "project");
        KotlinScriptExternalImportsProvider kotlinScriptExternalImportsProvider = KotlinScriptExternalImportsProvider.Companion.getInstance(project4);
        if (kotlinScriptExternalImportsProvider != null) {
            void $receiver$iv3;
            $receiver$iv = kotlinScriptExternalImportsProvider;
            KotlinScriptExternalImportsProvider $receiver2 = $receiver$iv;
            configs = $receiver2.getCombinedClasspathFor((Iterable)this.sourceFiles);
            CompilerConfiguration compilerConfiguration4 = configuration;
            HashSet<String> set$iv = new HashSet<String>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $receiver$iv3) {
                File it = (File)e$iv;
                String key$iv = it.getAbsolutePath();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            object = list$iv;
            JvmContentRootsKt.addJvmClasspathRoots(compilerConfiguration4, (List<? extends File>)object);
        }
        List<JavaRoot> initialRoots = this.classpathRoots(configuration.getList(JVMConfigurationKeys.CONTENT_ROOTS));
        JvmDependenciesIndexFactory indexFactory = configuration.getBoolean(CommonConfigurationKeys.REPL_MODE) ? (JvmDependenciesIndexFactory)new JvmUpdatableDependenciesIndexFactory() : (JvmDependenciesIndexFactory)new JvmStaticDependenciesIndexFactory();
        this.rootsIndex = indexFactory.makeIndexFor(initialRoots);
        this.updateClasspathFromRootsIndex(this.rootsIndex);
        CoreJavaFileManager coreJavaFileManager = ServiceManager.getService(project, CoreJavaFileManager.class);
        if (coreJavaFileManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.cli.jvm.compiler.KotlinCliJavaFileManagerImpl");
        }
        ((KotlinCliJavaFileManagerImpl)coreJavaFileManager).initIndex(this.rootsIndex);
        project.registerService(JvmVirtualFileFinderFactory.class, new JvmCliVirtualFileFinderFactory(this.rootsIndex));
        Project project5 = project;
        Intrinsics.checkExpressionValueIsNotNull(project5, "project");
        ExternalDeclarationsProvider.Companion.registerExtensionPoint(project5);
        Project project6 = project;
        Intrinsics.checkExpressionValueIsNotNull(project6, "project");
        ExpressionCodegenExtension.Companion.registerExtensionPoint(project6);
        Project project7 = project;
        Intrinsics.checkExpressionValueIsNotNull(project7, "project");
        ClassBuilderInterceptorExtension.Companion.registerExtensionPoint(project7);
        Project project8 = project;
        Intrinsics.checkExpressionValueIsNotNull(project8, "project");
        AnalysisCompletedHandlerExtension.Companion.registerExtensionPoint(project8);
        Project project9 = project;
        Intrinsics.checkExpressionValueIsNotNull(project9, "project");
        PackageFragmentProviderExtension.Companion.registerExtensionPoint(project9);
        Project project10 = project;
        Intrinsics.checkExpressionValueIsNotNull(project10, "project");
        StorageComponentContainerContributor.Companion.registerExtensionPoint(project10);
        for (ComponentRegistrar registrar : configuration.getList(ComponentRegistrar.Companion.getPLUGIN_COMPONENT_REGISTRARS())) {
            MockProject mockProject = project;
            Intrinsics.checkExpressionValueIsNotNull(mockProject, "project");
            registrar.registerProjectComponents(mockProject, configuration);
        }
        this.sourceLinesOfCode$delegate = LazyKt.lazy((Function0)new Function0<Integer>(this){
            final /* synthetic */ KotlinCoreEnvironment this$0;

            public final int invoke() {
                return this.this$0.countLinesOfCode(KotlinCoreEnvironment.access$getSourceFiles$p(this.this$0));
            }
            {
                this.this$0 = kotlinCoreEnvironment;
                super(0);
            }
        });
    }

    static {
        Companion = new Companion(null);
        APPLICATION_LOCK = new Object();
        $$delegatedProperties = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(KotlinCoreEnvironment.class), "sourceLinesOfCode", "getSourceLinesOfCode()I"))};
    }

    @NotNull
    public static final /* synthetic */ ArrayList access$getSourceFiles$p(KotlinCoreEnvironment $this) {
        return $this.sourceFiles;
    }

    public /* synthetic */ KotlinCoreEnvironment(@NotNull Disposable parentDisposable, @NotNull JavaCoreApplicationEnvironment applicationEnvironment, @NotNull CompilerConfiguration configuration, DefaultConstructorMarker $constructor_marker) {
        this(parentDisposable, applicationEnvironment, configuration);
    }

    @JvmStatic
    @NotNull
    public static final KotlinCoreEnvironment createForProduction(@NotNull Disposable parentDisposable, @NotNull CompilerConfiguration configuration, @NotNull List<String> configFilePaths) {
        Intrinsics.checkParameterIsNotNull(parentDisposable, "parentDisposable");
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        Intrinsics.checkParameterIsNotNull(configFilePaths, "configFilePaths");
        return Companion.createForProduction(parentDisposable, configuration, configFilePaths);
    }

    @JvmStatic
    @NotNull
    public static final KotlinCoreEnvironment createForTests(@NotNull Disposable parentDisposable, @NotNull CompilerConfiguration configuration, @NotNull List<String> extensionConfigs) {
        Intrinsics.checkParameterIsNotNull(parentDisposable, "parentDisposable");
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        Intrinsics.checkParameterIsNotNull(extensionConfigs, "extensionConfigs");
        return Companion.createForTests(parentDisposable, configuration, extensionConfigs);
    }

    @JvmStatic
    public static final void registerApplicationServices(@NotNull JavaCoreApplicationEnvironment applicationEnvironment) {
        Intrinsics.checkParameterIsNotNull(applicationEnvironment, "applicationEnvironment");
        Companion.registerApplicationServices(applicationEnvironment);
    }

    @JvmStatic
    public static final void registerProjectServices(@NotNull JavaCoreProjectEnvironment projectEnvironment2) {
        Intrinsics.checkParameterIsNotNull(projectEnvironment2, "projectEnvironment");
        Companion.registerProjectServices(projectEnvironment2);
    }

    @Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J&\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0007J&\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0007J\u0006\u0010!\u001a\u00020\"J\u001e\u0010#\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\b\u0010$\u001a\u00020\"H\u0002J\u0018\u0010%\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u001cH\u0002J\u0010\u0010'\u001a\u00020\"2\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010(\u001a\u00020\"2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020.H\u0007J\u0010\u0010/\u001a\u00020\"2\u0006\u0010-\u001a\u00020.H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\n\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment$Companion;", "", "()V", "APPLICATION_LOCK", "Ljava/lang/Object;", "getAPPLICATION_LOCK", "()Ljava/lang/Object;", "applicationEnvironment", "Lorg/jetbrains/kotlin/com/intellij/core/JavaCoreApplicationEnvironment;", "getApplicationEnvironment", "()Lcom/intellij/core/JavaCoreApplicationEnvironment;", "ourApplicationEnvironment", "getOurApplicationEnvironment", "setOurApplicationEnvironment", "(Lcom/intellij/core/JavaCoreApplicationEnvironment;)V", "ourProjectCount", "", "getOurProjectCount", "()I", "setOurProjectCount", "(I)V", "createApplicationEnvironment", "parentDisposable", "Lorg/jetbrains/kotlin/com/intellij/openapi/Disposable;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "configFilePaths", "", "", "createForProduction", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "createForTests", "extensionConfigs", "disposeApplicationEnvironment", "", "getOrCreateApplicationEnvironmentForProduction", "registerAppExtensionPoints", "registerApplicationExtensionPointsAndExtensionsFrom", "configFilePath", "registerApplicationServices", "registerApplicationServicesForCLI", "registerProjectExtensionPoints", "area", "Lorg/jetbrains/kotlin/com/intellij/openapi/extensions/ExtensionsArea;", "registerProjectServices", "projectEnvironment", "Lorg/jetbrains/kotlin/com/intellij/core/JavaCoreProjectEnvironment;", "registerProjectServicesForCLI", "kotlin-compiler"})
    public static final class Companion {
        private final Object getAPPLICATION_LOCK() {
            return APPLICATION_LOCK;
        }

        private final JavaCoreApplicationEnvironment getOurApplicationEnvironment() {
            return ourApplicationEnvironment;
        }

        private final void setOurApplicationEnvironment(JavaCoreApplicationEnvironment javaCoreApplicationEnvironment) {
            ourApplicationEnvironment = javaCoreApplicationEnvironment;
        }

        private final int getOurProjectCount() {
            return ourProjectCount;
        }

        private final void setOurProjectCount(int n) {
            ourProjectCount = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final KotlinCoreEnvironment createForProduction(@NotNull Disposable parentDisposable, @NotNull CompilerConfiguration configuration, @NotNull List<String> configFilePaths) {
            Intrinsics.checkParameterIsNotNull(parentDisposable, "parentDisposable");
            Intrinsics.checkParameterIsNotNull(configuration, "configuration");
            Intrinsics.checkParameterIsNotNull(configFilePaths, "configFilePaths");
            JavaCoreApplicationEnvironment appEnv = this.getOrCreateApplicationEnvironmentForProduction(configuration, configFilePaths);
            Boolean bl = PropertiesKt.toBooleanLenient(System.getProperty(PropertiesKt.getKOTLIN_COMPILER_ENVIRONMENT_KEEPALIVE_PROPERTY()));
            if (!(bl != null ? bl : false)) {
                Disposer.register(parentDisposable, new Disposable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void dispose() {
                        Object object = org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment$Companion.access$getAPPLICATION_LOCK$p(KotlinCoreEnvironment.Companion);
                        synchronized (object) {
                            Companion companion = KotlinCoreEnvironment.Companion;
                            org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment$Companion.access$setOurProjectCount$p(companion, org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment$Companion.access$getOurProjectCount$p(companion) + -1);
                            if (org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment$Companion.access$getOurProjectCount$p(companion) <= 0) {
                                KotlinCoreEnvironment.Companion.disposeApplicationEnvironment();
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                });
            }
            KotlinCoreEnvironment environment2 = new KotlinCoreEnvironment(parentDisposable, appEnv, configuration, null);
            Object object = this.getAPPLICATION_LOCK();
            synchronized (object) {
                Companion companion = Companion;
                int n = companion.getOurProjectCount();
                companion.setOurProjectCount(n + 1);
                int n2 = n;
            }
            return environment2;
        }

        @JvmStatic
        @NotNull
        public final KotlinCoreEnvironment createForTests(@NotNull Disposable parentDisposable, @NotNull CompilerConfiguration configuration, @NotNull List<String> extensionConfigs) {
            Intrinsics.checkParameterIsNotNull(parentDisposable, "parentDisposable");
            Intrinsics.checkParameterIsNotNull(configuration, "configuration");
            Intrinsics.checkParameterIsNotNull(extensionConfigs, "extensionConfigs");
            return new KotlinCoreEnvironment(parentDisposable, this.createApplicationEnvironment(parentDisposable, configuration, extensionConfigs), configuration, null);
        }

        @Nullable
        public final JavaCoreApplicationEnvironment getApplicationEnvironment() {
            return Companion.getOurApplicationEnvironment();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final JavaCoreApplicationEnvironment getOrCreateApplicationEnvironmentForProduction(CompilerConfiguration configuration, List<String> configFilePaths) {
            Object object = this.getAPPLICATION_LOCK();
            synchronized (object) {
                Disposable parentDisposable;
                block6: {
                    if (Companion.getOurApplicationEnvironment() == null) break block6;
                    JavaCoreApplicationEnvironment javaCoreApplicationEnvironment = Companion.getOurApplicationEnvironment();
                    if (javaCoreApplicationEnvironment == null) {
                        Intrinsics.throwNpe();
                    }
                    JavaCoreApplicationEnvironment javaCoreApplicationEnvironment2 = javaCoreApplicationEnvironment;
                    return javaCoreApplicationEnvironment2;
                }
                Disposable disposable = parentDisposable = Disposer.newDisposable();
                Intrinsics.checkExpressionValueIsNotNull(disposable, "parentDisposable");
                Companion.setOurApplicationEnvironment(Companion.createApplicationEnvironment(disposable, configuration, configFilePaths));
                Companion.setOurProjectCount(0);
                Disposer.register(parentDisposable, new Disposable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void dispose() {
                        Object object = org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment$Companion.access$getAPPLICATION_LOCK$p(KotlinCoreEnvironment.Companion);
                        synchronized (object) {
                            org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment$Companion.access$setOurApplicationEnvironment$p(KotlinCoreEnvironment.Companion, null);
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                });
                JavaCoreApplicationEnvironment javaCoreApplicationEnvironment = Companion.getOurApplicationEnvironment();
                if (javaCoreApplicationEnvironment == null) {
                    Intrinsics.throwNpe();
                }
                JavaCoreApplicationEnvironment javaCoreApplicationEnvironment3 = javaCoreApplicationEnvironment;
                return javaCoreApplicationEnvironment3;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void disposeApplicationEnvironment() {
            Object object = this.getAPPLICATION_LOCK();
            synchronized (object) {
                JavaCoreApplicationEnvironment javaCoreApplicationEnvironment = Companion.getOurApplicationEnvironment();
                if (javaCoreApplicationEnvironment == null) {
                    return;
                }
                JavaCoreApplicationEnvironment environment2 = javaCoreApplicationEnvironment;
                Companion.setOurApplicationEnvironment(null);
                Disposer.dispose(environment2.getParentDisposable());
                ZipHandler.clearFileAccessorCache();
                Unit unit = Unit.INSTANCE;
            }
        }

        private final JavaCoreApplicationEnvironment createApplicationEnvironment(Disposable parentDisposable, CompilerConfiguration configuration, List<String> configFilePaths) {
            Extensions.cleanRootArea(parentDisposable);
            this.registerAppExtensionPoints();
            JavaCoreApplicationEnvironment applicationEnvironment = new JavaCoreApplicationEnvironment(parentDisposable);
            for (String configPath : configFilePaths) {
                this.registerApplicationExtensionPointsAndExtensionsFrom(configuration, configPath);
            }
            this.registerApplicationServicesForCLI(applicationEnvironment);
            this.registerApplicationServices(applicationEnvironment);
            return applicationEnvironment;
        }

        private final void registerAppExtensionPoints() {
            CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), "org.jetbrains.kotlin.com.intellij.filetype.stubBuilder", FileTypeExtensionPoint.class);
            CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), FileContextProvider.EP_NAME, FileContextProvider.class);
            CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), MetaDataContributor.EP_NAME, MetaDataContributor.class);
            CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), PsiAugmentProvider.EP_NAME, PsiAugmentProvider.class);
            CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), JavaMainMethodProvider.EP_NAME, JavaMainMethodProvider.class);
            CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), ContainerProvider.EP_NAME, ContainerProvider.class);
            CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), ClsCustomNavigationPolicy.EP_NAME, ClsCustomNavigationPolicy.class);
            CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), ClassFileDecompilers.EP_NAME, ClassFileDecompilers.Decompiler.class);
        }

        private final void registerApplicationExtensionPointsAndExtensionsFrom(CompilerConfiguration configuration, String configFilePath) {
            CompilerJarLocator locator = configuration.get(CLIConfigurationKeys.COMPILER_JAR_LOCATOR);
            File pluginRoot = locator == null ? PathUtil.getPathUtilJar() : locator.getCompilerJar();
            Application app = ApplicationManager.getApplication();
            File parentFile = pluginRoot.getParentFile();
            if (pluginRoot.isDirectory() && app != null && app.isUnitTestMode() && StringsKt.endsWith$default(FileUtil.toCanonicalPath(parentFile.getPath()), "out/production", false, 2, null)) {
                File srcDir = parentFile.getParentFile().getParentFile();
                pluginRoot = new File(srcDir, "idea/src");
            }
            CoreApplicationEnvironment.registerExtensionPointAndExtensions(pluginRoot, configFilePath, Extensions.getRootArea());
        }

        private final void registerApplicationServicesForCLI(JavaCoreApplicationEnvironment applicationEnvironment) {
            applicationEnvironment.registerFileType(PlainTextFileType.INSTANCE, "xml");
            applicationEnvironment.registerParserDefinition(new JavaParserDefinition());
        }

        @JvmStatic
        public final void registerApplicationServices(@NotNull JavaCoreApplicationEnvironment applicationEnvironment) {
            Intrinsics.checkParameterIsNotNull(applicationEnvironment, "applicationEnvironment");
            JavaCoreApplicationEnvironment $receiver = applicationEnvironment;
            $receiver.registerFileType(KotlinFileType.INSTANCE, "kt");
            $receiver.registerFileType(KotlinFileType.INSTANCE, KotlinParserDefinition.STD_SCRIPT_SUFFIX);
            $receiver.registerParserDefinition(new KotlinParserDefinition());
            $receiver.getApplication().registerService(KotlinBinaryClassCache.class, new KotlinBinaryClassCache());
            $receiver.getApplication().registerService(JavaClassSupers.class, JavaClassSupersImpl.class);
        }

        private final void registerProjectExtensionPoints(ExtensionsArea area) {
            CoreApplicationEnvironment.registerExtensionPoint(area, PsiTreeChangePreprocessor.EP_NAME, PsiTreeChangePreprocessor.class);
            CoreApplicationEnvironment.registerExtensionPoint(area, PsiElementFinder.EP_NAME, PsiElementFinder.class);
        }

        @JvmStatic
        public final void registerProjectServices(@NotNull JavaCoreProjectEnvironment projectEnvironment2) {
            Intrinsics.checkParameterIsNotNull(projectEnvironment2, "projectEnvironment");
            MockProject mockProject = projectEnvironment2.getProject();
            MockProject $receiver = mockProject;
            KotlinScriptDefinitionProvider kotlinScriptDefinitionProvider = new KotlinScriptDefinitionProvider();
            $receiver.registerService(KotlinScriptDefinitionProvider.class, kotlinScriptDefinitionProvider);
            Project project = projectEnvironment2.getProject();
            Intrinsics.checkExpressionValueIsNotNull(project, "projectEnvironment.project");
            $receiver.registerService(KotlinScriptExternalImportsProvider.class, new KotlinScriptExternalImportsProvider(project, kotlinScriptDefinitionProvider));
            $receiver.registerService(KotlinJavaPsiFacade.class, new KotlinJavaPsiFacade($receiver));
            Project project2 = $receiver;
            Intrinsics.checkExpressionValueIsNotNull(project2, "this");
            $receiver.registerService(KtLightClassForFacade.FacadeStubCache.class, new KtLightClassForFacade.FacadeStubCache(project2));
        }

        private final void registerProjectServicesForCLI(JavaCoreProjectEnvironment projectEnvironment2) {
            MockProject mockProject = projectEnvironment2.getProject();
            MockProject $receiver = mockProject;
            JavaFileManager javaFileManager = ServiceManager.getService($receiver, JavaFileManager.class);
            if (javaFileManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.core.CoreJavaFileManager");
            }
            $receiver.registerService(CoreJavaFileManager.class, (CoreJavaFileManager)javaFileManager);
            Project project = $receiver;
            Intrinsics.checkExpressionValueIsNotNull(project, "this");
            CliLightClassGenerationSupport cliLightClassGenerationSupport = new CliLightClassGenerationSupport(project);
            $receiver.registerService(LightClassGenerationSupport.class, cliLightClassGenerationSupport);
            $receiver.registerService(CliLightClassGenerationSupport.class, cliLightClassGenerationSupport);
            $receiver.registerService(CodeAnalyzerInitializer.class, cliLightClassGenerationSupport);
            ExtensionsArea area = Extensions.getArea($receiver);
            area.getExtensionPoint(PsiElementFinder.EP_NAME).registerExtension(new JavaElementFinder($receiver, cliLightClassGenerationSupport));
            area.getExtensionPoint(PsiElementFinder.EP_NAME).registerExtension(new PsiElementFinderImpl($receiver, ServiceManager.getService($receiver, JavaFileManager.class)));
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$registerProjectExtensionPoints(Companion $this, @NotNull ExtensionsArea area) {
            $this.registerProjectExtensionPoints(area);
        }

        @NotNull
        public static final /* synthetic */ Object access$getAPPLICATION_LOCK$p(Companion $this) {
            return $this.getAPPLICATION_LOCK();
        }

        public static final /* synthetic */ int access$getOurProjectCount$p(Companion $this) {
            return $this.getOurProjectCount();
        }

        public static final /* synthetic */ void access$setOurProjectCount$p(Companion $this, int n) {
            $this.setOurProjectCount(n);
        }

        @Nullable
        public static final /* synthetic */ JavaCoreApplicationEnvironment access$getOurApplicationEnvironment$p(Companion $this) {
            return $this.getOurApplicationEnvironment();
        }

        public static final /* synthetic */ void access$setOurApplicationEnvironment$p(Companion $this, @Nullable JavaCoreApplicationEnvironment javaCoreApplicationEnvironment) {
            $this.setOurApplicationEnvironment(javaCoreApplicationEnvironment);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

