/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.CompilationErrorHandler;
import org.jetbrains.kotlin.codegen.MultifileClassCodegen;
import org.jetbrains.kotlin.codegen.PackageCodegen;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.com.google.common.collect.Sets;
import org.jetbrains.kotlin.com.intellij.util.containers.MultiMap;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.KtFile;

public class KotlinCodegenFacade {
    public static void compileCorrectFiles(@NotNull GenerationState state2, @NotNull CompilationErrorHandler errorHandler) {
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "compileCorrectFiles"));
        }
        if (errorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "compileCorrectFiles"));
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        state2.beforeCompile();
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        KotlinCodegenFacade.doGenerateFiles(state2.getFiles(), state2, errorHandler);
    }

    public static void doGenerateFiles(@NotNull Collection<KtFile> files, @NotNull GenerationState state2, @NotNull CompilationErrorHandler errorHandler) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "doGenerateFiles"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "doGenerateFiles"));
        }
        if (errorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "doGenerateFiles"));
        }
        MultiMap<FqName, KtFile> filesInPackages = new MultiMap<FqName, KtFile>();
        MultiMap<FqName, KtFile> filesInMultifileClasses = new MultiMap<FqName, KtFile>();
        for (KtFile file2 : files) {
            if (file2 == null) {
                throw new IllegalArgumentException("A null file given for compilation");
            }
            JvmFileClassInfo fileClassInfo = state2.getFileClassesProvider().getFileClassInfo(file2);
            if (fileClassInfo.getWithJvmMultifileClass()) {
                filesInMultifileClasses.putValue(fileClassInfo.getFacadeClassFqName(), file2);
                continue;
            }
            filesInPackages.putValue(file2.getPackageFqName(), file2);
        }
        HashSet<FqName> obsoleteMultifileClasses = new HashSet<FqName>(state2.getObsoleteMultifileClasses());
        for (FqName multifileClassFqName : Sets.union(filesInMultifileClasses.keySet(), obsoleteMultifileClasses)) {
            KotlinCodegenFacade.doCheckCancelled(state2);
            KotlinCodegenFacade.generateMultifileClass(state2, multifileClassFqName, filesInMultifileClasses.get(multifileClassFqName), errorHandler);
        }
        HashSet<FqName> packagesWithObsoleteParts = new HashSet<FqName>(state2.getPackagesWithObsoleteParts());
        for (FqName packageFqName : Sets.union(packagesWithObsoleteParts, filesInPackages.keySet())) {
            KotlinCodegenFacade.doCheckCancelled(state2);
            KotlinCodegenFacade.generatePackage(state2, packageFqName, filesInPackages.get(packageFqName), errorHandler);
        }
        KotlinCodegenFacade.doCheckCancelled(state2);
        state2.getFactory().done();
    }

    private static void doCheckCancelled(GenerationState state2) {
        if (state2.getClassBuilderMode() == ClassBuilderMode.FULL) {
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        }
    }

    public static void generatePackage(@NotNull GenerationState state2, @NotNull FqName packageFqName, @NotNull Collection<KtFile> jetFiles, @NotNull CompilationErrorHandler errorHandler) {
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "generatePackage"));
        }
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "generatePackage"));
        }
        if (jetFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetFiles", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "generatePackage"));
        }
        if (errorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "generatePackage"));
        }
        PackageCodegen codegen = state2.getFactory().forPackage(packageFqName, jetFiles);
        codegen.generate(errorHandler);
    }

    private static void generateMultifileClass(@NotNull GenerationState state2, @NotNull FqName multifileClassFqName, @NotNull Collection<KtFile> files, @NotNull CompilationErrorHandler handler2) {
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "generateMultifileClass"));
        }
        if (multifileClassFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multifileClassFqName", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "generateMultifileClass"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "generateMultifileClass"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "org/jetbrains/kotlin/codegen/KotlinCodegenFacade", "generateMultifileClass"));
        }
        MultifileClassCodegen codegen = state2.getFactory().forMultifileClass(multifileClassFqName, files);
        codegen.generate(handler2);
    }

    private KotlinCodegenFacade() {
    }
}

