/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.vfs;

import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.application.Application;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileListener;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import org.jetbrains.kotlin.com.intellij.util.EventDispatcher;

public abstract class DeprecatedVirtualFileSystem
extends VirtualFileSystem {
    private final EventDispatcher<VirtualFileListener> myEventDispatcher = EventDispatcher.create(VirtualFileListener.class);

    protected void startEventPropagation() {
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            return;
        }
        application.getMessageBus().connect().subscribe(VirtualFileManager.VFS_CHANGES, new BulkVirtualFileListenerAdapter(this.myEventDispatcher.getMulticaster(), this));
    }

    @Override
    public void addVirtualFileListener(@NotNull VirtualFileListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/kotlin/com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "addVirtualFileListener"));
        }
        this.myEventDispatcher.addListener(listener);
    }

    @Override
    protected void deleteFile(Object requestor, @NotNull VirtualFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "org/jetbrains/kotlin/com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "deleteFile"));
        }
        throw new UnsupportedOperationException("deleteFile() not supported");
    }

    @Override
    protected void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName2) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "org/jetbrains/kotlin/com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "renameFile"));
        }
        if (newName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "org/jetbrains/kotlin/com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "renameFile"));
        }
        throw new UnsupportedOperationException("renameFile() not supported");
    }

    @Override
    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile vDir, @NotNull String fileName) throws IOException {
        if (vDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vDir", "org/jetbrains/kotlin/com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "createChildFile"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/kotlin/com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "createChildFile"));
        }
        throw new UnsupportedOperationException("createChildFile() not supported");
    }

    @Override
    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile vDir, @NotNull String dirName) throws IOException {
        if (vDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vDir", "org/jetbrains/kotlin/com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "createChildDirectory"));
        }
        if (dirName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirName", "org/jetbrains/kotlin/com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "createChildDirectory"));
        }
        throw new UnsupportedOperationException("createChildDirectory() not supported");
    }

    @Override
    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile virtualFile, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "org/jetbrains/kotlin/com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "copyFile"));
        }
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "org/jetbrains/kotlin/com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "copyFile"));
        }
        if (copyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyName", "org/jetbrains/kotlin/com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "copyFile"));
        }
        throw new UnsupportedOperationException("copyFile() not supported");
    }
}

