/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.reference.impl.manipulators;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.AbstractElementManipulator;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.PsiDocTag;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class PsiDocTagValueManipulator
extends AbstractElementManipulator<PsiDocTag> {
    @Override
    public PsiDocTag handleContentChange(@NotNull PsiDocTag tag, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/reference/impl/manipulators/PsiDocTagValueManipulator", "handleContentChange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/reference/impl/manipulators/PsiDocTagValueManipulator", "handleContentChange"));
        }
        StringBuilder replacement = new StringBuilder(tag.getText());
        replacement.replace(range.getStartOffset(), range.getEndOffset(), newContent);
        return (PsiDocTag)tag.replace(JavaPsiFacade.getInstance(tag.getProject()).getElementFactory().createDocTagFromText(replacement.toString()));
    }

    @Override
    @NotNull
    public TextRange getRangeInElement(@NotNull PsiDocTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/reference/impl/manipulators/PsiDocTagValueManipulator", "getRangeInElement"));
        }
        PsiElement[] elements = tag.getDataElements();
        if (elements.length == 0) {
            PsiElement name = tag.getNameElement();
            int offset2 = name.getStartOffsetInParent() + name.getTextLength();
            TextRange textRange = new TextRange(offset2, offset2);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/reference/impl/manipulators/PsiDocTagValueManipulator", "getRangeInElement"));
            }
            return textRange;
        }
        PsiElement first = elements[0];
        PsiElement last = elements[elements.length - 1];
        TextRange textRange = new TextRange(first.getStartOffsetInParent(), last.getStartOffsetInParent() + last.getTextLength());
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/reference/impl/manipulators/PsiDocTagValueManipulator", "getRangeInElement"));
        }
        return textRange;
    }
}

