/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.buildcomparison.outcome.internal.tooling;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.plugins.buildcomparison.outcome.internal.tooling.DefaultProjectOutcomes;
import org.gradle.api.plugins.buildcomparison.outcome.internal.tooling.PublishArtifactToFileBuildOutcomeTransformer;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.internal.ImmutableDomainObjectSet;
import org.gradle.tooling.model.internal.outcomes.GradleFileBuildOutcome;
import org.gradle.tooling.model.internal.outcomes.ProjectOutcomes;
import org.gradle.tooling.provider.model.ToolingModelBuilder;

public class ProjectOutcomesModelBuilder
implements ToolingModelBuilder {
    private final PublishArtifactToFileBuildOutcomeTransformer artifactTransformer = new PublishArtifactToFileBuildOutcomeTransformer();

    public boolean canBuild(String modelName) {
        return modelName.equals("org.gradle.tooling.model.outcomes.ProjectOutcomes");
    }

    public Object buildAll(String modelName, Project project) {
        return this.buildProjectOutput(project.getRootProject(), null);
    }

    private DefaultProjectOutcomes buildProjectOutput(Project project, ProjectOutcomes parent) {
        DefaultProjectOutcomes projectOutput = new DefaultProjectOutcomes(project.getName(), project.getPath(), project.getDescription(), project.getProjectDir(), this.getFileOutcomes(project), parent);
        for (Project child : project.getChildProjects().values()) {
            projectOutput.addChild(this.buildProjectOutput(child, projectOutput));
        }
        return projectOutput;
    }

    private DomainObjectSet<GradleFileBuildOutcome> getFileOutcomes(Project project) {
        ArrayList fileBuildOutcomes = Lists.newArrayList();
        this.addArtifacts(project, fileBuildOutcomes);
        return new ImmutableDomainObjectSet((Iterable)fileBuildOutcomes);
    }

    private void addArtifacts(Project project, List<GradleFileBuildOutcome> outcomes) {
        Configuration configuration = (Configuration)project.getConfigurations().findByName("archives");
        if (configuration != null) {
            for (PublishArtifact artifact : configuration.getArtifacts()) {
                GradleFileBuildOutcome outcome = this.artifactTransformer.transform(artifact, project);
                outcomes.add(outcome);
            }
        }
    }
}

