/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.daemon;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonClient;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonManager;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonStarter;
import org.gradle.api.internal.tasks.compile.daemon.DaemonForkOptions;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.concurrent.CompositeStoppable;

public class CompilerClientsManager {
    private static final Logger LOGGER = Logging.getLogger(CompilerDaemonManager.class);
    private final Object lock = new Object();
    private final List<CompilerDaemonClient> allClients = new ArrayList<CompilerDaemonClient>();
    private final List<CompilerDaemonClient> idleClients = new ArrayList<CompilerDaemonClient>();
    private CompilerDaemonStarter compilerDaemonStarter;

    public CompilerClientsManager(CompilerDaemonStarter compilerDaemonStarter) {
        this.compilerDaemonStarter = compilerDaemonStarter;
    }

    public CompilerDaemonClient reserveIdleClient(DaemonForkOptions forkOptions) {
        return this.reserveIdleClient(forkOptions, this.idleClients);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompilerDaemonClient reserveIdleClient(DaemonForkOptions forkOptions, List<CompilerDaemonClient> clients) {
        Object object = this.lock;
        synchronized (object) {
            Iterator<CompilerDaemonClient> it = clients.iterator();
            while (it.hasNext()) {
                CompilerDaemonClient candidate = it.next();
                if (!candidate.isCompatibleWith(forkOptions)) continue;
                it.remove();
                return candidate;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompilerDaemonClient reserveNewClient(File workingDir, DaemonForkOptions forkOptions) {
        CompilerDaemonClient client = this.compilerDaemonStarter.startDaemon(workingDir, forkOptions);
        Object object = this.lock;
        synchronized (object) {
            this.allClients.add(client);
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(CompilerDaemonClient client) {
        Object object = this.lock;
        synchronized (object) {
            this.idleClients.add(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            LOGGER.debug("Stopping {} compiler daemon(s).", (Object)this.allClients.size());
            CompositeStoppable.stoppable(this.allClients).stop();
            LOGGER.info("Stopped {} compiler daemon(s).", (Object)this.allClients.size());
            this.allClients.clear();
        }
    }
}

