/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.tasks.http;

import java.net.URI;
import org.gradle.StartParameter;
import org.gradle.api.GradleException;
import org.gradle.api.internal.tasks.cache.TaskOutputCache;
import org.gradle.api.internal.tasks.cache.TaskOutputCacheFactory;
import org.gradle.cache.tasks.http.HttpTaskOutputCache;

public class HttpTaskOutputCacheFactory
implements TaskOutputCacheFactory {
    private static final String HTTP_URI_PROPERTY = "org.gradle.cache.tasks.http.uri";
    private final URI root;

    public HttpTaskOutputCacheFactory() {
        String uri = System.getProperty(HTTP_URI_PROPERTY);
        if (uri == null) {
            throw new GradleException(String.format("Must specify HTTP cache backend URI via '%s' system property", HTTP_URI_PROPERTY));
        }
        this.root = URI.create(uri);
    }

    public HttpTaskOutputCacheFactory(URI root) {
        this.root = root;
    }

    public TaskOutputCache createCache(StartParameter startParameter) {
        return new HttpTaskOutputCache(this.root);
    }
}

